/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.jface.preference.IPreferenceStore;

public class HistoryScopeSet
extends ScopeSet {
    private static final String KEY_EXPRESSION = "expression";
    public static final String EXT = ".hist";

    public HistoryScopeSet(String expression) {
        this(expression, expression);
    }

    public HistoryScopeSet(String name, String expression) {
        super(name);
        if (expression != null) {
            this.setExpression(expression);
        }
    }

    public HistoryScopeSet(HistoryScopeSet set) {
        super(set, set.getName());
        this.setExpression(set.getExpression());
    }

    @Override
    public void copyFrom(ScopeSet set) {
        String expression = this.getExpression();
        super.copyFrom(set);
        this.setExpression(expression);
    }

    public String getExpression() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getString(KEY_EXPRESSION);
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    @Override
    protected String getExtension() {
        return EXT;
    }

    @Override
    protected String encodeFileName(String name) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '_' || Character.isLetterOrDigit(c)) {
                buf.append(c);
            } else {
                buf.append('_');
                buf.append((int)c);
                buf.append('_');
            }
            ++i;
        }
        return buf.toString();
    }

    public void setExpression(String expression) {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(KEY_EXPRESSION, expression);
    }
}

