/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.ForwardingAcceptorFactory;
import org.apache.sshd.server.ForwardingFilter;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.auth.UserAuthPublicKey;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.apache.sshd.server.channel.ChannelDirectTcpip;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.filesystem.NativeFileSystemFactory;
import org.apache.sshd.server.kex.DHG1;
import org.apache.sshd.server.kex.DHG14;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.DefaultForwardingAcceptorFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    protected int backlog = 50;
    protected boolean reuseAddress = true;
    protected IoSessionConfig sessionConfig;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    protected Factory<Command> shellFactory;
    protected SessionFactory sessionFactory;
    protected CommandFactory commandFactory;
    protected FileSystemFactory fileSystemFactory;
    protected List<NamedFactory<Command>> subsystemFactories;
    protected PasswordAuthenticator passwordAuthenticator;
    protected PublickeyAuthenticator publickeyAuthenticator;
    protected GSSAuthenticator gssAuthenticator;
    protected ForwardingFilter forwardingFilter;
    protected ForwardingAcceptorFactory x11ForwardingAcceptorFactory;
    protected ForwardingAcceptorFactory tcpipForwardingAcceptorFactory;
    protected ScheduledExecutorService executor;
    protected boolean shutdownExecutor;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public IoSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(IoSessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public Factory<Command> getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(Factory<Command> shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public FileSystemFactory getFileSystemFactory() {
        return this.fileSystemFactory;
    }

    public void setFileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
    }

    @Override
    public List<NamedFactory<Command>> getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List<NamedFactory<Command>> subsystemFactories) {
        this.subsystemFactories = subsystemFactories;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public ForwardingFilter getForwardingFilter() {
        return this.forwardingFilter;
    }

    @Override
    public ForwardingAcceptorFactory getTcpipForwardingAcceptorFactory() {
        return this.tcpipForwardingAcceptorFactory;
    }

    public void setX11ForwardNioSocketAcceptorFactory(ForwardingAcceptorFactory f) {
        this.x11ForwardingAcceptorFactory = f;
    }

    @Override
    public ForwardingAcceptorFactory getX11ForwardingAcceptorFactory() {
        return this.x11ForwardingAcceptorFactory;
    }

    public void setTcpipForwardNioSocketAcceptorFactory(ForwardingAcceptorFactory f) {
        this.tcpipForwardingAcceptorFactory = f;
    }

    public void setForwardingFilter(ForwardingFilter forwardingFilter) {
        this.forwardingFilter = forwardingFilter;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor) {
        this.setScheduledExecutorService(executor, false);
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor, boolean shutdownExecutor) {
        this.executor = executor;
        this.shutdownExecutor = shutdownExecutor;
    }

    protected void checkConfig() {
        if (this.getPort() < 0) {
            throw new IllegalArgumentException("Bad port number: " + this.port);
        }
        if (this.getKeyExchangeFactories() == null) {
            throw new IllegalArgumentException("KeyExchangeFactories not set");
        }
        if (this.getUserAuthFactories() == null) {
            ArrayList<NamedFactory<UserAuth>> factories = new ArrayList<NamedFactory<UserAuth>>();
            if (this.getPasswordAuthenticator() != null) {
                factories.add(new UserAuthPassword.Factory());
            }
            if (this.getPublickeyAuthenticator() != null) {
                factories.add(new UserAuthPublicKey.Factory());
            }
            if (this.getGSSAuthenticator() != null) {
                factories.add(new UserAuthGSS.Factory());
            }
            if (factories.size() > 0) {
                this.setUserAuthFactories(factories);
            } else {
                throw new IllegalArgumentException("UserAuthFactories not set");
            }
        }
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(), true);
        }
        if (this.getCipherFactories() == null) {
            throw new IllegalArgumentException("CipherFactories not set");
        }
        if (this.getCompressionFactories() == null) {
            throw new IllegalArgumentException("CompressionFactories not set");
        }
        if (this.getMacFactories() == null) {
            throw new IllegalArgumentException("MacFactories not set");
        }
        if (this.getChannelFactories() == null) {
            throw new IllegalArgumentException("ChannelFactories not set");
        }
        if (this.getRandomFactory() == null) {
            throw new IllegalArgumentException("RandomFactory not set");
        }
        if (this.getKeyPairProvider() == null) {
            throw new IllegalArgumentException("HostKeyProvider not set");
        }
        if (this.getFileSystemFactory() == null) {
            throw new IllegalArgumentException("FileSystemFactory not set");
        }
        if (this.getTcpipForwardingAcceptorFactory() == null) {
            throw new IllegalArgumentException("TcpipForwardingAcceptorFactory not set");
        }
        if (this.getX11ForwardingAcceptorFactory() == null) {
            throw new IllegalArgumentException("X11ForwardingAcceptorFactory not set");
        }
    }

    public void start() throws IOException {
        this.checkConfig();
        this.acceptor = this.createAcceptor();
        this.configure(this.acceptor);
        SessionFactory handler = this.sessionFactory;
        if (handler == null) {
            handler = this.createSessionFactory();
        }
        handler.setServer(this);
        this.acceptor.setHandler((IoHandler)handler);
        this.acceptor.bind((SocketAddress)(this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port)));
        if (this.port == 0) {
            this.port = ((InetSocketAddress)this.acceptor.getLocalAddress()).getPort();
        }
    }

    public void stop() throws InterruptedException {
        this.stop(false);
    }

    public void stop(boolean immediately) throws InterruptedException {
        List<Object> sessions = new ArrayList();
        if (this.acceptor != null) {
            this.acceptor.setCloseOnDeactivation(false);
            this.acceptor.unbind();
            sessions = this.getActiveSessions();
        }
        final CountDownLatch latch = new CountDownLatch(sessions.size());
        SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture future) {
                latch.countDown();
            }
        };
        for (AbstractSession abstractSession : sessions) {
            abstractSession.close(immediately).addListener(listener);
        }
        if (!immediately) {
            latch.await();
        }
        if (this.acceptor != null) {
            this.acceptor.dispose();
        }
        this.acceptor = null;
        if (this.shutdownExecutor && this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public List<AbstractSession> getActiveSessions() {
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession session = AbstractSession.getSession(ioSession, true);
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected IoAcceptor createAcceptor() {
        return new NioSocketAcceptor(this.getNioWorkers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(IoAcceptor acceptor) {
        if (acceptor instanceof NioSocketAcceptor) {
            NioSocketAcceptor nio = (NioSocketAcceptor)acceptor;
            nio.setReuseAddress(this.reuseAddress);
            nio.setBacklog(this.backlog);
            Socket s = new Socket();
            try {
                try {
                    nio.getSessionConfig().setReceiveBufferSize(s.getReceiveBufferSize());
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    s.close();
                    throw throwable;
                }
                s.close();
                {
                }
            }
            catch (IOException e) {
                this.log.warn("cannot adjust SO_RCVBUF back to system default", (Throwable)e);
            }
        }
        if (this.sessionConfig != null) {
            acceptor.getSessionConfig().setAll(this.sessionConfig);
        }
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory();
    }

    public static SshServer setUpDefaultServer() {
        SshServer sshd = new SshServer();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHG14.Factory(), new DHG1.Factory()));
            sshd.setRandomFactory(new SingletonRandomFactory(new BouncyCastleRandom.Factory()));
        } else {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHG1.Factory()));
            sshd.setRandomFactory(new SingletonRandomFactory(new JceRandom.Factory()));
        }
        SshServer.setUpDefaultCiphers(sshd);
        sshd.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
        sshd.setMacFactories(Arrays.asList(new HMACMD5.Factory(), new HMACSHA1.Factory(), new HMACMD596.Factory(), new HMACSHA196.Factory()));
        sshd.setChannelFactories(Arrays.asList(new ChannelSession.Factory(), new ChannelDirectTcpip.Factory()));
        sshd.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory()));
        sshd.setFileSystemFactory(new NativeFileSystemFactory());
        DefaultForwardingAcceptorFactory faf = new DefaultForwardingAcceptorFactory();
        sshd.setTcpipForwardNioSocketAcceptorFactory(faf);
        sshd.setX11ForwardNioSocketAcceptorFactory(faf);
        return sshd;
    }

    private static void setUpDefaultCiphers(SshServer sshd) {
        LinkedList<NamedFactory<Cipher>> avail = new LinkedList<NamedFactory<Cipher>>();
        avail.add(new AES128CBC.Factory());
        avail.add(new TripleDESCBC.Factory());
        avail.add(new BlowfishCBC.Factory());
        avail.add(new AES192CBC.Factory());
        avail.add(new AES256CBC.Factory());
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        sshd.setCipherFactories(avail);
    }

    public static void main(String[] args) throws Exception {
        int port = 8000;
        boolean error = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-p".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    break;
                }
            } else {
                if (args[i].startsWith("-")) {
                    System.err.println("illegal option: " + args[i]);
                    error = true;
                    break;
                }
                System.err.println("extra argument: " + args[i]);
                error = true;
                break;
            }
            port = Integer.parseInt(args[++i]);
        }
        if (error) {
            System.err.println("usage: sshd [-p port]");
            System.exit(-1);
        }
        System.err.println("Starting SSHD on port " + port);
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setPort(port);
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyPairProvider(new PEMGeneratorHostKeyProvider("key.pem"));
        } else {
            sshd.setKeyPairProvider(new SimpleGeneratorHostKeyProvider("key.ser"));
        }
        if (OsUtils.isUNIX()) {
            sshd.setShellFactory(new ProcessShellFactory(new String[]{"/bin/sh", "-i", "-l"}, EnumSet.of(ProcessShellFactory.TtyOptions.ONlCr)));
        } else {
            sshd.setShellFactory(new ProcessShellFactory(new String[]{"cmd.exe "}, EnumSet.of(ProcessShellFactory.TtyOptions.Echo, ProcessShellFactory.TtyOptions.ICrNl, ProcessShellFactory.TtyOptions.ONlCr)));
        }
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return username != null && username.equals(password);
            }
        });
        sshd.setPublickeyAuthenticator(new PublickeyAuthenticator(){

            public boolean authenticate(String username, PublicKey key, ServerSession session) {
                return true;
            }
        });
        sshd.setForwardingFilter(new ForwardingFilter(){

            public boolean canForwardAgent(ServerSession session) {
                return true;
            }

            public boolean canForwardX11(ServerSession session) {
                return true;
            }

            public boolean canListen(InetSocketAddress address, ServerSession session) {
                return true;
            }

            public boolean canConnect(InetSocketAddress address, ServerSession session) {
                return true;
            }
        });
        sshd.start();
    }
}

