/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class WordCorrectionProposal
implements IJavaCompletionProposal {
    private final IQuickAssistInvocationContext fContext;
    private final int fLength;
    private final String fLine;
    private final int fOffset;
    private final int fRelevance;
    private final String fWord;

    public static String getHtmlRepresentation(String string) {
        int length = string.length();
        StringBuffer buffer = new StringBuffer(string);
        int offset = length - 1;
        while (offset >= 0) {
            int index = 0;
            while (index < IHtmlTagConstants.HTML_ENTITY_CHARACTERS.length) {
                if (string.charAt(offset) == IHtmlTagConstants.HTML_ENTITY_CHARACTERS[index]) {
                    buffer.replace(offset, offset + 1, String.valueOf(IHtmlTagConstants.HTML_ENTITY_CODES[index]));
                    break;
                }
                ++index;
            }
            --offset;
        }
        return buffer.toString();
    }

    public WordCorrectionProposal(String word, String[] arguments, int offset, int length, IQuickAssistInvocationContext context, int relevance) {
        this.fWord = Character.isUpperCase(arguments[0].charAt(0)) ? String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1) : word;
        this.fOffset = offset;
        this.fLength = length;
        this.fContext = context;
        this.fRelevance = relevance;
        StringBuffer buffer = new StringBuffer(80);
        buffer.append("...<br>");
        buffer.append(WordCorrectionProposal.getHtmlRepresentation(arguments[1]));
        buffer.append("<b>");
        buffer.append(WordCorrectionProposal.getHtmlRepresentation(this.fWord));
        buffer.append("</b>");
        buffer.append(WordCorrectionProposal.getHtmlRepresentation(arguments[2]));
        buffer.append("<br>...");
        this.fLine = buffer.toString();
    }

    public final void apply(IDocument document) {
        try {
            document.replace(this.fOffset, this.fLength, this.fWord);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.fLine;
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(JavaUIMessages.Spelling_correct_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif");
    }

    @Override
    public final int getRelevance() {
        return this.fRelevance;
    }

    public final Point getSelection(IDocument document) {
        int offset = this.fContext.getOffset();
        int length = this.fContext.getLength();
        int delta = this.fWord.length() - this.fLength;
        if (offset <= this.fOffset && offset + length >= this.fOffset) {
            length += delta;
        } else if (offset > this.fOffset && offset + length > this.fOffset + this.fLength) {
            offset += delta;
            length -= delta;
        } else {
            length += delta;
        }
        return new Point(offset, length);
    }
}

