/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class JavadocProblemsConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_JAVADOC_SUPPORT = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.doc.comment.support");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadoc");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTags");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS_METHOD_TYPE_PARAMETERS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAG_DESCRIPTION = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTagDescription");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_COMMENTS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocComments");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String INFO = "info";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private static final String DEFAULT = "default";
    private static final String PRIVATE = "private";
    private static final String NO_TAG = "no_tag";
    private static final String ALL_STANDARD_TAGS = "all_standard_tags";
    private static final String RETURN_TAGS = "return_tag";
    private PixelConverter fPixelConverter;
    private Composite fJavadocComposite;
    private ControlEnableState fBlockEnableState = null;

    public JavadocProblemsConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, JavadocProblemsConfigurationBlock.getKeys(), container);
    }

    public static OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{PREF_JAVADOC_SUPPORT, PREF_PB_INVALID_JAVADOC, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, PREF_PB_INVALID_JAVADOC_TAGS, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF, PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF, PREF_PB_MISSING_JAVADOC_TAGS, PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING, PREF_PB_MISSING_JAVADOC_TAGS_METHOD_TYPE_PARAMETERS, PREF_PB_MISSING_JAVADOC_COMMENTS, PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING, PREF_PB_MISSING_JAVADOC_TAG_DESCRIPTION};
        return keys;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite javadocComposite = this.createJavadocTabContent(parent);
        this.validateSettings(null, null, null);
        return javadocComposite;
    }

    private Composite createJavadocTabContent(Composite folder) {
        String[] errorWarningInfoIgnore = new String[]{ERROR, WARNING, INFO, IGNORE};
        String[] errorWarningInfoIgnoreLabels = new String[]{PreferencesMessages.JavadocProblemsConfigurationBlock_error, PreferencesMessages.JavadocProblemsConfigurationBlock_warning, PreferencesMessages.JavadocProblemsConfigurationBlock_info, PreferencesMessages.JavadocProblemsConfigurationBlock_ignore};
        String[] enabledDisabled = new String[]{ENABLED, DISABLED};
        String[] disabledEnabled = new String[]{DISABLED, ENABLED};
        String[] visibilities = new String[]{PUBLIC, PROTECTED, DEFAULT, PRIVATE};
        String[] visibilitiesLabels = new String[]{PreferencesMessages.JavadocProblemsConfigurationBlock_public, PreferencesMessages.JavadocProblemsConfigurationBlock_protected, PreferencesMessages.JavadocProblemsConfigurationBlock_default, PreferencesMessages.JavadocProblemsConfigurationBlock_private};
        String[] missingTagValues = new String[]{ALL_STANDARD_TAGS, RETURN_TAGS, NO_TAG};
        String[] missingTagLabels = new String[]{PreferencesMessages.JavadocProblemsConfigurationBlock_allStandardTags, PreferencesMessages.JavadocProblemsConfigurationBlock_returnTag, PreferencesMessages.JavadocProblemsConfigurationBlock_ignore};
        int nColumns = 3;
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite outer = sc1.getBody();
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        outer.setLayout((Layout)layout);
        StyledText widget = new StyledText(outer, 72);
        widget.setText(Messages.format(PreferencesMessages.JavadocProblemsConfigurationBlock_note_message, PreferencesMessages.JavadocProblemsConfigurationBlock_note_title));
        widget.setBackground(outer.getBackground());
        widget.setLeftMargin(0);
        widget.setEnabled(false);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = PreferencesMessages.JavadocProblemsConfigurationBlock_note_title.length();
        styleRange.fontStyle = 1;
        widget.setStyleRange(styleRange);
        GridDataFactory.generate((Control)widget, (int)nColumns, (int)1);
        Composite spacer = new Composite(outer, 0);
        GridDataFactory.fillDefaults().span(nColumns, 1).hint(1, 5).applyTo((Control)spacer);
        Link ignoreOptionalProblemsLink = this.createIgnoreOptionalProblemsLink(outer);
        if (ignoreOptionalProblemsLink != null) {
            GridData gd = new GridData();
            gd.horizontalSpan = nColumns;
            ignoreOptionalProblemsLink.setLayoutData((Object)gd);
            spacer = new Composite(outer, 0);
            GridDataFactory.fillDefaults().span(nColumns, 1).hint(1, 5).applyTo((Control)spacer);
        }
        String label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_javadoc_support_label;
        this.addCheckBox(outer, label, PREF_JAVADOC_SUPPORT, enabledDisabled, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = indent;
        Composite composite = new Composite(outer, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.fJavadocComposite = composite;
        spacer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(nColumns, 1).hint(1, 5).applyTo((Control)spacer);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.JavadocProblemsConfigurationBlock_javadoc_description);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        spacer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(nColumns, 1).hint(1, 5).applyTo((Control)spacer);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_label;
        this.addComboBox(composite, label, PREF_PB_INVALID_JAVADOC, errorWarningInfoIgnore, errorWarningInfoIgnoreLabels, 0);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_visibility_label;
        this.addComboBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_label;
        this.addCheckBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS, enabledDisabled, indent);
        Composite validateTagComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalIndent = indent;
        gridData.horizontalSpan = nColumns;
        validateTagComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        validateTagComposite.setLayout((Layout)gridLayout);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_not_visible_ref_label;
        this.addCheckBox(validateTagComposite, label, PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF, enabledDisabled, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_deprecated_label;
        this.addCheckBox(validateTagComposite, label, PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF, enabledDisabled, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_tag_description;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAG_DESCRIPTION, missingTagValues, missingTagLabels, indent);
        spacer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(nColumns, 1).hint(1, 5).applyTo((Control)spacer);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_javadoc_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS, errorWarningInfoIgnore, errorWarningInfoIgnoreLabels, 0);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_javadoc_tags_visibility_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_javadoc_tags_overriding_label;
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING, disabledEnabled, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_method_type_parameter_label;
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_METHOD_TYPE_PARAMETERS, disabledEnabled, indent);
        spacer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(nColumns, 1).hint(1, 5).applyTo((Control)spacer);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS, errorWarningInfoIgnore, errorWarningInfoIgnoreLabels, 0);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_visibility_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_overriding_label;
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING, disabledEnabled, indent);
        return sc1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (!PREF_PB_INVALID_JAVADOC.equals(changedKey) && !PREF_PB_MISSING_JAVADOC_TAGS.equals(changedKey) && !PREF_PB_MISSING_JAVADOC_COMMENTS.equals(changedKey) && !PREF_JAVADOC_SUPPORT.equals(changedKey) && !PREF_PB_INVALID_JAVADOC_TAGS.equals(changedKey)) return;
            this.updateEnableStates();
        } else {
            this.updateEnableStates();
        }
        this.fContext.statusChanged(new StatusInfo());
    }

    private void updateEnableStates() {
        boolean enableJavadoc = this.checkValue(PREF_JAVADOC_SUPPORT, ENABLED);
        this.enableConfigControls(enableJavadoc);
        if (enableJavadoc) {
            boolean enableInvalidTagsErrors = !this.checkValue(PREF_PB_INVALID_JAVADOC, IGNORE);
            this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS).setEnabled(enableInvalidTagsErrors);
            boolean enableInvalidTagsDetailsErrors = enableInvalidTagsErrors && this.checkValue(PREF_PB_INVALID_JAVADOC_TAGS, ENABLED);
            this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF).setEnabled(enableInvalidTagsDetailsErrors);
            this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF).setEnabled(enableInvalidTagsDetailsErrors);
            this.setComboEnabled(PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, enableInvalidTagsErrors);
            this.setComboEnabled(PREF_PB_MISSING_JAVADOC_TAG_DESCRIPTION, enableInvalidTagsErrors);
            boolean enableMissingTagsErrors = !this.checkValue(PREF_PB_MISSING_JAVADOC_TAGS, IGNORE);
            this.getCheckBox(PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING).setEnabled(enableMissingTagsErrors);
            this.getCheckBox(PREF_PB_MISSING_JAVADOC_TAGS_METHOD_TYPE_PARAMETERS).setEnabled(enableMissingTagsErrors);
            this.setComboEnabled(PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, enableMissingTagsErrors);
            boolean enableMissingCommentsErrors = !this.checkValue(PREF_PB_MISSING_JAVADOC_COMMENTS, IGNORE);
            this.getCheckBox(PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING).setEnabled(enableMissingCommentsErrors);
            this.setComboEnabled(PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, enableMissingCommentsErrors);
        }
    }

    protected void enableConfigControls(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fJavadocComposite);
        }
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.JavadocProblemsConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.JavadocProblemsConfigurationBlock_needsfullbuild_message : PreferencesMessages.JavadocProblemsConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }
}

