/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import com.ibm.icu.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.fix.SortMembersFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class SortMembersCleanUp
extends AbstractCleanUp {
    private HashSet<IResource> fTouchedFiles;

    public SortMembersCleanUp() {
    }

    public SortMembersCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        boolean sortMembers;
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        ICleanUpFix fix = SortMembersFix.createCleanUp(compilationUnit, sortMembers, (sortMembers = this.isEnabled("cleanup.sort_members")) && this.isEnabled("cleanup.sort_members_all"));
        if (fix != null) {
            if (this.fTouchedFiles == null) {
                this.fTouchedFiles = new HashSet();
            }
            this.fTouchedFiles.add(((ICompilationUnit)compilationUnit.getJavaElement()).getResource());
        }
        return fix;
    }

    @Override
    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        if (this.fTouchedFiles == null) {
            return super.checkPostConditions(monitor);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", this.fTouchedFiles.size());
        try {
            RefactoringStatus result = new RefactoringStatus();
            for (IFile iFile : this.fTouchedFiles) {
                if (SortMembersCleanUp.containsRelevantMarkers(iFile)) {
                    String fileLocation = BasicElementLabels.getPathLabel((IPath)iFile.getProjectRelativePath(), (boolean)false);
                    String projectName = iFile.getProject().getName();
                    result.addWarning(MessageFormat.format((String)MultiFixMessages.SortMembersCleanUp_RemoveMarkersWarning0, (Object[])new Object[]{fileLocation, projectName}));
                }
                monitor.worked(1);
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
            this.fTouchedFiles = null;
        }
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.sort_members")) {
            if (this.isEnabled("cleanup.sort_members_all")) {
                return new String[]{MultiFixMessages.SortMembersCleanUp_AllMembers_description};
            }
            return new String[]{MultiFixMessages.SortMembersCleanUp_Excluding_description};
        }
        return null;
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class SortExample {\n");
        if (this.isEnabled("cleanup.sort_members") && this.isEnabled("cleanup.sort_members_all")) {
            buf.append("  private String bar;\n");
            buf.append("  private String foo;\n");
        } else {
            buf.append("  private String foo;\n");
            buf.append("  private String bar;\n");
        }
        if (this.isEnabled("cleanup.sort_members")) {
            buf.append("  private void bar() {}\n");
            buf.append("  private void foo() {}\n");
        } else {
            buf.append("  private void foo() {}\n");
            buf.append("  private void bar() {}\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.isEnabled("cleanup.sort_members"), false, false, null);
    }

    private static boolean containsRelevantMarkers(IFile file) throws CoreException {
        IMarker[] bookmarks = file.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
        if (bookmarks.length != 0) {
            return true;
        }
        IMarker[] tasks = file.findMarkers("org.eclipse.core.resources.taskmarker", true, 2);
        if (tasks.length != 0) {
            return true;
        }
        IMarker[] breakpoints = file.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        return breakpoints.length != 0;
    }
}

