/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventHandler;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.notification.ActivationNotificationProvider;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationProvider;

public class RuleInstance<EventAtom>
implements IActivationNotificationProvider {
    private final RuleSpecification<EventAtom> specification;
    private final Table<ActivationState, EventAtom, Activation<EventAtom>> activations;
    private final ActivationNotificationProvider activationNotificationProvider;
    private EventHandler<EventAtom> handler;

    protected RuleInstance(RuleSpecification<EventAtom> specification) {
        this.specification = (RuleSpecification)Preconditions.checkNotNull(specification, (Object)"Cannot create rule instance for null specification!");
        this.activations = HashBasedTable.create();
        this.activationNotificationProvider = new DefaultActivationNotificationProvider();
    }

    public void setHandler(EventHandler<EventAtom> handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Handler cannot be null!");
        Preconditions.checkState((this.handler == null || handler.equals(this.handler) ? 1 : 0) != 0, (Object)"Handler already set!");
        this.handler = handler;
    }

    public Activation<EventAtom> createActivation(EventAtom atom) {
        return new Activation<EventAtom>(this, atom, this.getActivationInactiveState());
    }

    private ActivationState getActivationInactiveState() {
        return this.specification.getLifeCycle().getInactiveState();
    }

    public void fire(Activation<EventAtom> activation, Context context) {
        Preconditions.checkNotNull(activation, (Object)"Cannot fire null activation!");
        Preconditions.checkNotNull((Object)context, (Object)"Cannot fire activation with null context");
        ActivationState activationState = activation.getState();
        EventAtom atom = activation.getAtom();
        this.doFire(activation, activationState, atom, context);
    }

    protected void doFire(Activation<EventAtom> activation, ActivationState activationState, EventAtom atom, Context context) {
        if (this.activations.contains((Object)activationState, atom)) {
            Collection<Job<EventAtom>> jobs = this.specification.getJobs(activationState);
            this.activationStateTransition(activation, EventType.RuleEngineEventType.FIRE);
            for (Job<EventAtom> job : jobs) {
                try {
                    job.execute(activation, context);
                }
                catch (Exception e) {
                    job.handleError(activation, e, context);
                }
            }
        }
    }

    public ActivationState activationStateTransition(Activation<EventAtom> activation, EventType event) {
        Preconditions.checkNotNull(activation, (Object)"Cannot perform state transition on null activation!");
        Preconditions.checkNotNull((Object)event, (Object)"Cannot perform state transition with null event!");
        ActivationState activationState = activation.getState();
        ActivationState nextActivationState = this.specification.getLifeCycle().nextActivationState(activationState, event);
        EventAtom atom = activation.getAtom();
        if (nextActivationState != null) {
            Activation removed = (Activation)this.activations.remove((Object)activationState, atom);
            activation.setState(nextActivationState);
            if (!nextActivationState.isInactive()) {
                this.activations.put((Object)nextActivationState, atom, activation);
                if (removed == null) {
                    this.activationNotificationProvider.notifyActivationCreated(activation, activationState);
                } else {
                    this.activationNotificationProvider.notifyActivationChanged(activation, activationState, event);
                }
            } else {
                this.activationNotificationProvider.notifyActivationRemoved(activation, activationState);
            }
        } else {
            nextActivationState = activationState;
            this.activationNotificationProvider.notifyActivationChanged(activation, activationState, event);
        }
        return nextActivationState;
    }

    @Override
    public boolean addActivationNotificationListener(IActivationNotificationListener listener, boolean fireNow) {
        return this.activationNotificationProvider.addActivationNotificationListener(listener, fireNow);
    }

    @Override
    public boolean removeActivationNotificationListener(IActivationNotificationListener listener) {
        return this.activationNotificationProvider.removeActivationNotificationListener(listener);
    }

    public RuleSpecification<EventAtom> getSpecification() {
        return this.specification;
    }

    public EventFilter<? super EventAtom> getFilter() {
        Preconditions.checkState((this.handler != null ? 1 : 0) != 0, (Object)"Cannot get filter, bacause handler is null!");
        return this.handler.getEventFilter();
    }

    public ActivationLifeCycle getLifeCycle() {
        return this.specification.getLifeCycle();
    }

    public Table<ActivationState, EventAtom, Activation<EventAtom>> getActivations() {
        return this.activations;
    }

    public Collection<Activation<EventAtom>> getAllActivations() {
        return this.activations.values();
    }

    public Collection<Activation<EventAtom>> getActivations(ActivationState state) {
        Preconditions.checkNotNull((Object)state, (Object)"Cannot return activations for null state");
        return this.activations.row((Object)state).values();
    }

    protected void dispose() {
        this.handler.dispose();
        for (Table.Cell cell : this.activations.cellSet()) {
            Activation activation = (Activation)cell.getValue();
            ActivationState activationState = activation.getState();
            activation.setState(this.specification.getLifeCycle().getInactiveState());
            this.activationNotificationProvider.notifyActivationRemoved(activation, activationState);
        }
        this.activationNotificationProvider.dispose();
    }

    public String toString() {
        return String.format("%s{spec=%s, activations=%s}", this.getClass().getName(), this.specification, this.activations);
    }

    private final class DefaultActivationNotificationProvider
    extends ActivationNotificationProvider {
        private DefaultActivationNotificationProvider() {
        }

        @Override
        protected void listenerAdded(IActivationNotificationListener listener, boolean fireNow) {
            if (fireNow) {
                ActivationState inactiveState = RuleInstance.this.getActivationInactiveState();
                for (Activation activation : RuleInstance.this.getAllActivations()) {
                    listener.activationCreated(activation, inactiveState);
                }
            }
        }
    }
}

