/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;

public class Activation<EventAtom> {
    private EventAtom atom;
    private ActivationState state;
    private boolean enabled;
    private RuleInstance<EventAtom> instance;
    private int cachedHash = -1;

    protected Activation(RuleInstance<EventAtom> instance, EventAtom atom, ActivationState initState) {
        this.atom = Preconditions.checkNotNull(atom, (Object)"Cannot create activation with null patternmatch");
        this.instance = (RuleInstance)Preconditions.checkNotNull(instance, (Object)"Cannot create activation with null instance");
        this.state = (ActivationState)Preconditions.checkNotNull((Object)initState, (Object)"Cannot create activation with null initial state");
    }

    public EventAtom getAtom() {
        return this.atom;
    }

    public ActivationState getState() {
        return this.state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RuleInstance<EventAtom> getInstance() {
        return this.instance;
    }

    protected void setState(ActivationState state) {
        this.state = (ActivationState)Preconditions.checkNotNull((Object)state, (Object)"Activation state cannot be null!");
        this.enabled = this.instance.getSpecification().getEnabledStates().contains(state);
    }

    public void fire(Context context) {
        Preconditions.checkNotNull((Object)context, (Object)"Cannot fire activation with null context");
        this.instance.fire(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Activation) {
            Activation other = (Activation)obj;
            return other.instance.equals(this.instance) && other.atom.equals(this.atom);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHash == -1) {
            this.cachedHash = Objects.hashCode((Object[])new Object[]{this.instance, this.atom});
        }
        return this.cachedHash;
    }

    public String toString() {
        return String.format("%s{atom=%s, state=%s}", this.getClass().getName(), this.atom, this.state);
    }
}

