/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.interpreter.AbstractConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.interpreter.UnresolvableFeatureException;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;

public class SwitchConstantExpressionsInterpreter
extends AbstractConstantExpressionsInterpreter {
    @Inject
    @Extension
    private ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    @Extension
    private NumberLiterals numberLiterals;

    public Object evaluate(XExpression it) {
        HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new XExpression[0]);
        Context _context = new Context(null, null, null, _newHashSet);
        return this.evaluate(it, _context);
    }

    public Object evaluate(XExpression it, boolean validationMode) {
        Object _xblockexpression = null;
        HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new XExpression[0]);
        SwitchContext ctx = new SwitchContext(null, null, null, _newHashSet);
        ctx.validationMode = validationMode;
        _xblockexpression = this.evaluate(it, ctx);
        return _xblockexpression;
    }

    protected Object _internalEvaluate(XNumberLiteral it, Context ctx) {
        Class<? extends Number> _javaType = this.numberLiterals.getJavaType(it);
        return this.numberLiterals.numberValue(it, _javaType);
    }

    protected Object _internalEvaluate(XAbstractFeatureCall it, Context ctx) {
        JvmIdentifiableElement _feature;
        JvmIdentifiableElement feature = _feature = it.getFeature();
        boolean _matched = false;
        if (feature instanceof JvmType) {
            _matched = true;
            return this.toTypeReference((JvmType)feature, 0);
        }
        if (!_matched && feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            return feature;
        }
        if (!_matched && feature instanceof JvmField) {
            _matched = true;
            boolean _isSetConstant = ((JvmField)feature).isSetConstant();
            if (_isSetConstant) {
                boolean _isConstant = ((JvmField)feature).isConstant();
                if (_isConstant) {
                    return ((JvmField)feature).getConstantValue();
                }
            } else if (((JvmField)feature).isFinal() && (((JvmField)feature).isStatic() || ctx instanceof SwitchContext && ((SwitchContext)ctx).validationMode)) {
                boolean _notEquals;
                XExpression associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression(feature);
                boolean bl = _notEquals = !Objects.equal((Object)associatedExpression, null);
                if (_notEquals) {
                    return this.evaluateAssociatedExpression(associatedExpression, ctx);
                }
            }
        }
        if (!_matched && feature instanceof XVariableDeclaration && !((XVariableDeclaration)feature).isWriteable() && !Objects.equal((Object)((XVariableDeclaration)feature).getRight(), null)) {
            _matched = true;
            XExpression _right = ((XVariableDeclaration)feature).getRight();
            return this.evaluateAssociatedExpression(_right, ctx);
        }
        if (!_matched && feature instanceof JvmFormalParameter) {
            EObject _eContainer;
            _matched = true;
            EObject container = _eContainer = ((JvmFormalParameter)feature).eContainer();
            boolean _matched_1 = false;
            if (container instanceof XSwitchExpression) {
                boolean _notEquals;
                XExpression _switch = ((XSwitchExpression)container).getSwitch();
                boolean bl = _notEquals = !Objects.equal((Object)_switch, null);
                if (_notEquals) {
                    _matched_1 = true;
                    XExpression _switch_1 = ((XSwitchExpression)container).getSwitch();
                    return this.evaluate(_switch_1, ctx);
                }
            }
        }
        JvmIdentifiableElement _feature_1 = it.getFeature();
        String _simpleName = _feature_1.getSimpleName();
        String _plus = "Couldn't resolve feature " + _simpleName;
        throw new UnresolvableFeatureException(_plus, it);
    }

    public Object evaluateAssociatedExpression(XExpression it, Context ctx) {
        JvmIdentifiableElement _feature;
        Object _switchResult = null;
        boolean _matched = false;
        if (it instanceof XAbstractFeatureCall && (_feature = ((XAbstractFeatureCall)it).getFeature()) instanceof JvmEnumerationLiteral) {
            _matched = true;
            throw this.notConstantExpression(it);
        }
        if (!_matched) {
            _switchResult = this.evaluate(it, ctx);
        }
        return _switchResult;
    }

    @Override
    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XAbstractFeatureCall) {
            return this._internalEvaluate((XAbstractFeatureCall)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XNumberLiteral) {
            return this._internalEvaluate((XNumberLiteral)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        if (it == null) {
            return this._internalEvaluate((Void)null, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }

    @FinalFieldsConstructor
    private static class SwitchContext
    extends Context {
        private boolean validationMode;

        public SwitchContext(JvmTypeReference expectedType, ClassFinder classFinder, Map<String, JvmIdentifiableElement> visibleFeatures, Set<XExpression> alreadyEvaluating) {
            super(expectedType, classFinder, visibleFeatures, alreadyEvaluating);
        }
    }
}

