/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.psystem.PTraceable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IDerivativeModificationReason;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IRewriterTraceCollector;

public class MappingTraceCollector
implements IRewriterTraceCollector {
    private final Multimap<PTraceable, PTraceable> traces = HashMultimap.create();
    private final Multimap<PTraceable, PTraceable> inverseTraces = HashMultimap.create();
    private final Map<PTraceable, IDerivativeModificationReason> removals = new HashMap<PTraceable, IDerivativeModificationReason>();
    private final Predicate<PTraceable> removed = new Predicate<PTraceable>(){

        public boolean apply(PTraceable input) {
            return MappingTraceCollector.this.removals.containsKey(input);
        }
    };

    @Override
    public Iterable<PTraceable> getCanonicalTraceables(PTraceable derivative) {
        return this.findTraceEnds(derivative, this.traces);
    }

    @Override
    public Iterable<PTraceable> getRewrittenTraceables(PTraceable source) {
        return this.findTraceEnds(source, this.inverseTraces);
    }

    private Set<PTraceable> findTraceEnds(PTraceable traceable, Multimap<PTraceable, PTraceable> traceRecords) {
        if (traceable instanceof PQuery) {
            return ImmutableSet.of((Object)traceable);
        }
        HashSet<PTraceable> visited = new HashSet<PTraceable>();
        HashSet<PTraceable> result = new HashSet<PTraceable>();
        LinkedList<PTraceable> queue = new LinkedList<PTraceable>();
        queue.add(traceable);
        while (!queue.isEmpty()) {
            PTraceable aDerivative = (PTraceable)queue.poll();
            visited.add(aDerivative);
            Collection nextOrigins = traceRecords.get((Object)aDerivative);
            if (nextOrigins.isEmpty()) {
                result.add(aDerivative);
                continue;
            }
            for (PTraceable nextOrigin : nextOrigins) {
                if (visited.contains(nextOrigin)) continue;
                queue.add(nextOrigin);
            }
        }
        return result;
    }

    @Override
    public void addTrace(PTraceable original, PTraceable derivative) {
        this.traces.put((Object)derivative, (Object)original);
        this.inverseTraces.put((Object)original, (Object)derivative);
        this.removals.remove(original);
    }

    @Override
    public void derivativeRemoved(PTraceable derivative, IDerivativeModificationReason reason) {
        Preconditions.checkState((!this.removals.containsKey(derivative) ? 1 : 0) != 0, (String)"Traceable %s removed multiple times", (Object[])new Object[]{derivative});
        if (!this.inverseTraces.containsKey((Object)derivative)) {
            this.removals.put(derivative, reason);
        }
    }

    @Override
    public boolean isRemoved(PTraceable traceable) {
        return Iterables.all(this.getRewrittenTraceables(traceable), this.removed);
    }

    @Override
    public Iterable<IDerivativeModificationReason> getRemovalReasons(PTraceable traceable) {
        Iterable removedTraceEnds = Iterables.filter(this.getRewrittenTraceables(traceable), this.removed);
        return Iterables.transform((Iterable)removedTraceEnds, (Function)new Function<PTraceable, IDerivativeModificationReason>(){

            public IDerivativeModificationReason apply(PTraceable input) {
                return (IDerivativeModificationReason)MappingTraceCollector.this.removals.get(input);
            }
        });
    }
}

