/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.ActionPairMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.ActionPairMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.AppInstanceWithStateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.AppInstanceWithStateMachineMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.ApplicationInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.ApplicationInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.HostInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.HostInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.StateMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.StateMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.TransitionMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.TransitionMatcher;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RuleProvider {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.viatra");
    @Extension
    private CpsXformM2M cpsXformM2M = new Functions.Function0<CpsXformM2M>(){

        public CpsXformM2M apply() {
            try {
                CpsXformM2M _instance = CpsXformM2M.instance();
                return _instance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    @Extension
    private BatchTransformationRuleFactory _batchTransformationRuleFactory = new BatchTransformationRuleFactory();
    @Extension
    private IModelManipulations manipulation;
    @Extension
    protected DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    @Extension
    protected TraceabilityFactory traceFactory = TraceabilityFactory.eINSTANCE;
    private CPSToDeployment mapping;
    private ViatraQueryEngine engine;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> hostRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> applicationRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateMachineRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> transitionRule;
    private BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> actionRule;

    public RuleProvider(ViatraQueryEngine engine, CPSToDeployment deployment) {
        this.mapping = deployment;
        this.engine = engine;
        SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(engine);
        this.manipulation = _simpleModelManipulations;
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getHostRule() {
        try {
            boolean _equals = Objects.equal(this.hostRule, null);
            if (_equals) {
                IMatchProcessor<HostInstanceMatch> _function = new IMatchProcessor<HostInstanceMatch>(){

                    public void process(HostInstanceMatch it) {
                        final HostInstance cpsHostInstance = it.getHostInstance();
                        final String nodeIp = it.getHostInstance().getNodeIp();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Mapping host with IP: ");
                        _builder.append((Object)nodeIp);
                        RuleProvider.this.logger.debug((Object)_builder);
                        DeploymentHost _createDeploymentHost = RuleProvider.this.depFactory.createDeploymentHost();
                        Procedures.Procedure1<DeploymentHost> _function = new Procedures.Procedure1<DeploymentHost>(){

                            public void apply(DeploymentHost it) {
                                it.setIp(nodeIp);
                            }
                        };
                        final DeploymentHost deploymentHost = (DeploymentHost)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentHost, (Procedures.Procedure1)_function);
                        EList _hosts = RuleProvider.this.mapping.getDeployment().getHosts();
                        _hosts.add((Object)deploymentHost);
                        EList _traces = RuleProvider.this.mapping.getTraces();
                        CPS2DeploymentTrace _createCPS2DeploymentTrace = RuleProvider.this.traceFactory.createCPS2DeploymentTrace();
                        Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                            public void apply(CPS2DeploymentTrace it) {
                                EList _cpsElements = it.getCpsElements();
                                _cpsElements.add((Object)cpsHostInstance);
                                EList _deploymentElements = it.getDeploymentElements();
                                _deploymentElements.add((Object)deploymentHost);
                            }
                        };
                        CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                        _traces.add((Object)_doubleArrow);
                    }
                };
                this.hostRule = this._batchTransformationRuleFactory.createRule().name("HostRule").precondition(HostInstanceMatcher.querySpecification()).action((IMatchProcessor)_function).build();
            }
            return this.hostRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getApplicationRule() {
        try {
            boolean _equals = Objects.equal(this.applicationRule, null);
            if (_equals) {
                IMatchProcessor<ApplicationInstanceMatch> _function = new IMatchProcessor<ApplicationInstanceMatch>(){

                    public void process(ApplicationInstanceMatch it) {
                        try {
                            final ApplicationInstance cpsApplicationInstance = it.getAppInstance();
                            final String appId = it.getAppInstance().getIdentifier();
                            HostInstance cpsHostInstance = cpsApplicationInstance.getAllocatedTo();
                            DeploymentHost depHost = (DeploymentHost)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)cpsHostInstance), DeploymentHost.class));
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping application with ID: ");
                            _builder.append((Object)appId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            DeploymentApplication _createDeploymentApplication = RuleProvider.this.depFactory.createDeploymentApplication();
                            Procedures.Procedure1<DeploymentApplication> _function = new Procedures.Procedure1<DeploymentApplication>(){

                                public void apply(DeploymentApplication it) {
                                    it.setId(appId);
                                }
                            };
                            final DeploymentApplication deploymentApplication = (DeploymentApplication)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentApplication, (Procedures.Procedure1)_function);
                            EList _traces = RuleProvider.this.mapping.getTraces();
                            CPS2DeploymentTrace _createCPS2DeploymentTrace = RuleProvider.this.traceFactory.createCPS2DeploymentTrace();
                            Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                                public void apply(CPS2DeploymentTrace it) {
                                    EList _cpsElements = it.getCpsElements();
                                    _cpsElements.add((Object)cpsApplicationInstance);
                                    EList _deploymentElements = it.getDeploymentElements();
                                    _deploymentElements.add((Object)deploymentApplication);
                                }
                            };
                            CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                            _traces.add((Object)_doubleArrow);
                            EList _applications = depHost.getApplications();
                            _applications.add((Object)deploymentApplication);
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append((Object)"Mapped application with ID: ");
                            _builder_1.append((Object)appId);
                            RuleProvider.this.logger.debug((Object)_builder_1);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.applicationRule = this._batchTransformationRuleFactory.createRule().name("ApplicationRule").precondition(ApplicationInstanceMatcher.querySpecification()).action((IMatchProcessor)_function).build();
            }
            return this.applicationRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateMachineRule() {
        try {
            boolean _equals = Objects.equal(this.stateMachineRule, null);
            if (_equals) {
                IMatchProcessor<AppInstanceWithStateMachineMatch> _function = new IMatchProcessor<AppInstanceWithStateMachineMatch>(){

                    public void process(AppInstanceWithStateMachineMatch it) {
                        try {
                            ApplicationInstance cpsApplicationInstance = it.getAppInstance();
                            final StateMachine cpsStateMachine = it.getStateMachine();
                            DeploymentApplication depApplication = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)cpsApplicationInstance), DeploymentApplication.class));
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping state machine with ID: ");
                            String _identifier = cpsStateMachine.getIdentifier();
                            _builder.append((Object)_identifier);
                            RuleProvider.this.logger.debug((Object)_builder);
                            DeploymentBehavior _createDeploymentBehavior = RuleProvider.this.depFactory.createDeploymentBehavior();
                            Procedures.Procedure1<DeploymentBehavior> _function = new Procedures.Procedure1<DeploymentBehavior>(){

                                public void apply(DeploymentBehavior it) {
                                    it.setDescription(cpsStateMachine.getIdentifier());
                                }
                            };
                            final DeploymentBehavior depBehavior = (DeploymentBehavior)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentBehavior, (Procedures.Procedure1)_function);
                            depApplication.setBehavior(depBehavior);
                            CPS2DeploymentTrace trace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsStateMachine);
                            boolean _equals = Objects.equal((Object)trace, null);
                            if (_equals) {
                                EList _traces = RuleProvider.this.mapping.getTraces();
                                CPS2DeploymentTrace _createCPS2DeploymentTrace = RuleProvider.this.traceFactory.createCPS2DeploymentTrace();
                                Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                                    public void apply(CPS2DeploymentTrace it) {
                                        EList _cpsElements = it.getCpsElements();
                                        _cpsElements.add((Object)cpsStateMachine);
                                        EList _deploymentElements = it.getDeploymentElements();
                                        _deploymentElements.add((Object)depBehavior);
                                    }
                                };
                                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                                _traces.add((Object)_doubleArrow);
                            } else {
                                EList _deploymentElements = trace.getDeploymentElements();
                                _deploymentElements.add((Object)depBehavior);
                            }
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.stateMachineRule = this._batchTransformationRuleFactory.createRule().name("StateMachineRule").precondition(AppInstanceWithStateMachineMatcher.querySpecification()).action((IMatchProcessor)_function).build();
            }
            return this.stateMachineRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateRule() {
        try {
            boolean _equals = Objects.equal(this.stateRule, null);
            if (_equals) {
                IMatchProcessor<StateMatch> _function = new IMatchProcessor<StateMatch>(){

                    public void process(StateMatch it) {
                        StateMachine cpsStateMachine = it.getStateMachine();
                        ApplicationInstance cpsAppInstance = it.getAppInstance();
                        final State cpsState = it.getState();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Mapping state with ID: ");
                        String _identifier = cpsState.getIdentifier();
                        _builder.append((Object)_identifier);
                        RuleProvider.this.logger.debug((Object)_builder);
                        BehaviorState _createBehaviorState = RuleProvider.this.depFactory.createBehaviorState();
                        Procedures.Procedure1<BehaviorState> _function = new Procedures.Procedure1<BehaviorState>(){

                            public void apply(BehaviorState it) {
                                it.setDescription(cpsState.getIdentifier());
                            }
                        };
                        final BehaviorState behaviorState = (BehaviorState)ObjectExtensions.operator_doubleArrow((Object)_createBehaviorState, (Procedures.Procedure1)_function);
                        CPS2DeploymentTrace appInstanceTrace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsAppInstance);
                        DeploymentApplication depApplication = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)appInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                        DeploymentBehavior depBehavior = depApplication.getBehavior();
                        EList _states = depBehavior.getStates();
                        _states.add((Object)behaviorState);
                        CPS2DeploymentTrace trace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsState);
                        boolean _equals = Objects.equal((Object)trace, null);
                        if (_equals) {
                            EList _traces = RuleProvider.this.mapping.getTraces();
                            CPS2DeploymentTrace _createCPS2DeploymentTrace = RuleProvider.this.traceFactory.createCPS2DeploymentTrace();
                            Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                                public void apply(CPS2DeploymentTrace it) {
                                    EList _cpsElements = it.getCpsElements();
                                    _cpsElements.add((Object)cpsState);
                                    EList _deploymentElements = it.getDeploymentElements();
                                    _deploymentElements.add((Object)behaviorState);
                                }
                            };
                            CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                            _traces.add((Object)_doubleArrow);
                        } else {
                            EList _deploymentElements = trace.getDeploymentElements();
                            _deploymentElements.add((Object)behaviorState);
                        }
                        State _initial = cpsStateMachine.getInitial();
                        boolean _equals_1 = Objects.equal((Object)_initial, (Object)cpsState);
                        if (_equals_1) {
                            depBehavior.setCurrent(behaviorState);
                        }
                    }
                };
                this.stateRule = this._batchTransformationRuleFactory.createRule().name("StateRule").precondition(StateMatcher.querySpecification()).action((IMatchProcessor)_function).build();
            }
            return this.stateRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getTransitionRule() {
        try {
            boolean _equals = Objects.equal(this.transitionRule, null);
            if (_equals) {
                IMatchProcessor<TransitionMatch> _function = new IMatchProcessor<TransitionMatch>(){

                    public void process(TransitionMatch it) {
                        ApplicationInstance cpsAppInstance = it.getAppInstance();
                        final State cpsState = it.getSourceState();
                        final State cpsTargetState = it.getTargetState();
                        final Transition cpsTransition = it.getTransition();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Mapping transition with ID: ");
                        String _identifier = cpsTransition.getIdentifier();
                        _builder.append((Object)_identifier);
                        RuleProvider.this.logger.debug((Object)_builder);
                        BehaviorTransition _createBehaviorTransition = RuleProvider.this.depFactory.createBehaviorTransition();
                        Procedures.Procedure1<BehaviorTransition> _function = new Procedures.Procedure1<BehaviorTransition>(){

                            public void apply(BehaviorTransition it) {
                                it.setDescription(cpsTransition.getIdentifier());
                            }
                        };
                        final BehaviorTransition behaviorTransition = (BehaviorTransition)ObjectExtensions.operator_doubleArrow((Object)_createBehaviorTransition, (Procedures.Procedure1)_function);
                        CPS2DeploymentTrace appInstanceTrace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsAppInstance);
                        DeploymentApplication depApplication = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)appInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                        DeploymentBehavior depBehavior = depApplication.getBehavior();
                        EList _transitions = depBehavior.getTransitions();
                        _transitions.add((Object)behaviorTransition);
                        CPS2DeploymentTrace trace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsTransition);
                        boolean _equals = Objects.equal((Object)trace, null);
                        if (_equals) {
                            EList _traces = RuleProvider.this.mapping.getTraces();
                            CPS2DeploymentTrace _createCPS2DeploymentTrace = RuleProvider.this.traceFactory.createCPS2DeploymentTrace();
                            Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                                public void apply(CPS2DeploymentTrace it) {
                                    EList _cpsElements = it.getCpsElements();
                                    _cpsElements.add((Object)cpsTransition);
                                    EList _deploymentElements = it.getDeploymentElements();
                                    _deploymentElements.add((Object)behaviorTransition);
                                }
                            };
                            CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                            _traces.add((Object)_doubleArrow);
                        } else {
                            EList _deploymentElements = trace.getDeploymentElements();
                            _deploymentElements.add((Object)behaviorTransition);
                        }
                        Functions.Function1<BehaviorState, Boolean> _function_2 = new Functions.Function1<BehaviorState, Boolean>(){

                            public Boolean apply(BehaviorState it) {
                                String _description = it.getDescription();
                                String _identifier = cpsTargetState.getIdentifier();
                                return Objects.equal((Object)_description, (Object)_identifier);
                            }
                        };
                        BehaviorState depTargetState = (BehaviorState)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)depBehavior.getStates(), (Functions.Function1)_function_2));
                        Functions.Function1<BehaviorState, Boolean> _function_3 = new Functions.Function1<BehaviorState, Boolean>(){

                            public Boolean apply(BehaviorState it) {
                                String _description = it.getDescription();
                                String _identifier = cpsState.getIdentifier();
                                return Objects.equal((Object)_description, (Object)_identifier);
                            }
                        };
                        BehaviorState depSourceState = (BehaviorState)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)depBehavior.getStates(), (Functions.Function1)_function_3));
                        EList _outgoing = depSourceState.getOutgoing();
                        _outgoing.add((Object)behaviorTransition);
                        behaviorTransition.setTo(depTargetState);
                    }
                };
                this.transitionRule = this._batchTransformationRuleFactory.createRule().name("TransitionRule").precondition(TransitionMatcher.querySpecification()).action((IMatchProcessor)_function).build();
            }
            return this.transitionRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public BatchTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getActionRule() {
        try {
            boolean _equals = Objects.equal(this.actionRule, null);
            if (_equals) {
                IMatchProcessor<ActionPairMatch> _function = new IMatchProcessor<ActionPairMatch>(){

                    public void process(ActionPairMatch it) {
                        Transition cpsSendTransition = it.getSendTransition();
                        ApplicationInstance cpsSendAppInstance = it.getSendAppInstance();
                        Transition cpsWaitTransition = it.getWaitTransition();
                        ApplicationInstance cpsWaitAppInstance = it.getWaitAppInstance();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Mapping trigger between transitions: ");
                        String _identifier = cpsSendTransition.getIdentifier();
                        _builder.append((Object)_identifier);
                        _builder.append((Object)" and ");
                        String _identifier_1 = cpsWaitTransition.getIdentifier();
                        _builder.append((Object)_identifier_1);
                        RuleProvider.this.logger.debug((Object)_builder);
                        CPS2DeploymentTrace sendTransitionTrace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsSendTransition);
                        CPS2DeploymentTrace sendAppInstanceTrace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsSendAppInstance);
                        final DeploymentApplication depSendApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)sendAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                        Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                            public Boolean apply(BehaviorTransition it) {
                                EObject _eContainer = it.eContainer().eContainer();
                                return Objects.equal((Object)depSendApp, (Object)_eContainer);
                            }
                        };
                        BehaviorTransition depSendTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)sendTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function);
                        CPS2DeploymentTrace waitTransitionTrace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsWaitTransition);
                        CPS2DeploymentTrace waitAppInstanceTrace = RuleProvider.this.getTraceForCPSElement((Identifiable)cpsWaitAppInstance);
                        final DeploymentApplication depWaitApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)waitAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                        Functions.Function1<BehaviorTransition, Boolean> _function_1 = new Functions.Function1<BehaviorTransition, Boolean>(){

                            public Boolean apply(BehaviorTransition it) {
                                EObject _eContainer = it.eContainer().eContainer();
                                return Objects.equal((Object)depWaitApp, (Object)_eContainer);
                            }
                        };
                        BehaviorTransition depWaitTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)waitTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function_1);
                        EList _trigger = depSendTransition.getTrigger();
                        _trigger.add((Object)depWaitTransition);
                    }
                };
                this.actionRule = this._batchTransformationRuleFactory.createRule().name("ActionRule").precondition(ActionPairMatcher.querySpecification()).action((IMatchProcessor)_function).build();
            }
            return this.actionRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CPS2DeploymentTrace getTraceForCPSElement(Identifiable cpsElement) {
        try {
            return (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, cpsElement, null), CPS2DeploymentTrace.class));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

