/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.builder.configuration;

import com.google.inject.Inject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageGeneratorConfig;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.ui.builder.XbaseBuilderPreferenceAccess;

public class EMFPatternLanguageBuilderPreferenceAccess
extends XbaseBuilderPreferenceAccess {
    public static final String PREF_GENERATE_MANIFEST_ENTRIES = "generateManifestEntries";
    public static final String PREF_GENERATE_ECLIPSE_EXTENSIONS = "generateEclipseExtensions";
    public static final String PREF_GENERATE_MATCH_PROCESSOR = "generateMatchProcessors";
    public static final String PREF_MATCHER_GENERATION_STRATEGY = "generateMatchers";
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;

    public boolean isManifestGenerationEnabled(Object context) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getContextPreferenceStore(context);
        return preferenceStore.getBoolean(PREF_GENERATE_MANIFEST_ENTRIES);
    }

    public boolean isExtensionGenerationEnabled(Object context) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getContextPreferenceStore(context);
        return preferenceStore.getBoolean(PREF_GENERATE_ECLIPSE_EXTENSIONS);
    }

    public void setManifestGenerationEnabled(Object context, boolean enabled) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(context);
        preferenceStore.setValue(PREF_GENERATE_MANIFEST_ENTRIES, enabled);
    }

    public void setExtensionGenerationEnabled(Object context, boolean enabled) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(context);
        preferenceStore.setValue(PREF_GENERATE_ECLIPSE_EXTENSIONS, enabled);
    }

    public void loadBuilderPreferences(GeneratorConfig generatorConfig, Object context) {
        super.loadBuilderPreferences(generatorConfig, context);
        if (generatorConfig instanceof EMFPatternLanguageGeneratorConfig) {
            EMFPatternLanguageGeneratorConfig config = (EMFPatternLanguageGeneratorConfig)generatorConfig;
            IPreferenceStore preferenceStore = this.preferenceStoreAccess.getContextPreferenceStore(context);
            config.setGenerateExtensions(preferenceStore.getBoolean(PREF_GENERATE_ECLIPSE_EXTENSIONS));
            config.setUpdateManifest(preferenceStore.getBoolean(PREF_GENERATE_MANIFEST_ENTRIES));
            config.setGenerateMatchProcessors(preferenceStore.getBoolean(PREF_GENERATE_MATCH_PROCESSOR));
            config.setMatcherGenerationStrategy(EMFPatternLanguageGeneratorConfig.MatcherGenerationStrategy.valueOf((String)preferenceStore.getString(PREF_MATCHER_GENERATION_STRATEGY)));
        }
    }

    public static class Initializer
    extends XbaseBuilderPreferenceAccess.Initializer {
        protected void initializeBuilderPreferences(IPreferenceStore store) {
            super.initializeBuilderPreferences(store);
            store.setDefault(EMFPatternLanguageBuilderPreferenceAccess.PREF_GENERATE_MANIFEST_ENTRIES, true);
            store.setDefault(EMFPatternLanguageBuilderPreferenceAccess.PREF_GENERATE_ECLIPSE_EXTENSIONS, true);
            store.setDefault(EMFPatternLanguageBuilderPreferenceAccess.PREF_GENERATE_MATCH_PROCESSOR, true);
            store.setDefault(EMFPatternLanguageBuilderPreferenceAccess.PREF_MATCHER_GENERATION_STRATEGY, EMFPatternLanguageGeneratorConfig.MatcherGenerationStrategy.defaultValue().toString());
        }
    }
}

