/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.AppInstancesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.AppTypesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.Cps2depTraceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.DepApp2depHostMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.DepBehavior2depAppMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.DepTransitionMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.HostInstancesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.SendTransitionAppSignalMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.Sm2DeploymentbehaviorMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.State2StatemachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.StateMachinesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.StatesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.Transition2StateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.TransitionsMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.AppInstancesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.AppTypesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.HostInstancesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.StateMachinesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.StatesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.TransitionsQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.util.NamingUtil;
import org.eclipse.viatra.examples.cps.xform.m2m.util.SignalUtil;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.ChangeDelta;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.ChangeMonitor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CPS2DeploymentPartialBatchTransformation {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.incr.aggr");
    @Extension
    private CpsXformM2M cpsXformM2M = new Functions.Function0<CpsXformM2M>(){

        public CpsXformM2M apply() {
            try {
                CpsXformM2M _instance = CpsXformM2M.instance();
                return _instance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    private DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    private TraceabilityFactory tracFactory = TraceabilityFactory.eINSTANCE;
    private CPSToDeployment mapping;
    private ViatraQueryEngine engine;
    private ChangeMonitor monitor;
    private Stopwatch clearModelPerformance;
    private Stopwatch hostTransformationPerformance;
    private Stopwatch appTransformationPerformance;
    private Stopwatch stateMachineTransformationPerformance;
    private Stopwatch stateTransformationPerformance;
    private Stopwatch transitionTransformationPerformance;
    private Stopwatch triggerTransformationPerformance;
    private Stopwatch otherTimer;
    private Table<State, DeploymentBehavior, BehaviorState> stateTable;
    private Map<Identifiable, CPS2DeploymentTrace> traceTable;
    private Map<Transition, String> transitionMap;

    public CPS2DeploymentPartialBatchTransformation(CPSToDeployment mapping, ViatraQueryEngine engine) {
        try {
            ChangeMonitor _changeMonitor;
            boolean _notEquals = !Objects.equal((Object)mapping, null);
            Preconditions.checkArgument((boolean)_notEquals, (Object)"Mapping cannot be null!");
            CyberPhysicalSystem _cps = mapping.getCps();
            boolean _notEquals_1 = !Objects.equal((Object)_cps, null);
            Preconditions.checkArgument((boolean)_notEquals_1, (Object)"CPS not defined in mapping!");
            Deployment _deployment = mapping.getDeployment();
            boolean _notEquals_2 = !Objects.equal((Object)_deployment, null);
            Preconditions.checkArgument((boolean)_notEquals_2, (Object)"Deployment not defined in mapping!");
            boolean _notEquals_3 = !Objects.equal((Object)engine, null);
            Preconditions.checkArgument((boolean)_notEquals_3, (Object)"Engine cannot be null!");
            this.mapping = mapping;
            this.engine = engine;
            this.logger.debug((Object)"Preparing queries on engine.");
            Stopwatch watch = Stopwatch.createStarted();
            this.cpsXformM2M.prepare(engine);
            HashMap<Transition, String> _hashMap = new HashMap<Transition, String>();
            this.transitionMap = _hashMap;
            Procedures.Procedure1<TransitionsMatch> _function = new Procedures.Procedure1<TransitionsMatch>(){

                public void apply(TransitionsMatch m) {
                    CPS2DeploymentPartialBatchTransformation.this.transitionMap.put(m.getTransition(), m.getTransition().getAction());
                }
            };
            IterableExtensions.forEach((Iterable)this.cpsXformM2M.getTransitions(engine).getAllMatches(), (Procedures.Procedure1)_function);
            this.monitor = _changeMonitor = new ChangeMonitor(engine);
            this.monitor.addRule((IQuerySpecification)HostInstancesQuerySpecification.instance());
            this.monitor.addRule((IQuerySpecification)AppTypesQuerySpecification.instance());
            this.monitor.addRule((IQuerySpecification)AppInstancesQuerySpecification.instance());
            this.monitor.addRule((IQuerySpecification)StateMachinesQuerySpecification.instance());
            this.monitor.addRule((IQuerySpecification)StatesQuerySpecification.instance());
            this.monitor.addRule((IQuerySpecification)TransitionsQuerySpecification.instance());
            this.monitor.startMonitoring();
            watch.stop();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Prepared queries on engine (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder.append((Object)_elapsed);
            _builder.append((Object)" ms)");
            this.logger.info((Object)_builder);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void execute() {
        try {
            this.initPerformanceTimers();
            final ChangeDelta delta = this.monitor.createCheckpoint();
            Procedures.Procedure1<IQuerySpecification<? extends ViatraQueryMatcher<IPatternMatch>>> _function = new Procedures.Procedure1<IQuerySpecification<? extends ViatraQueryMatcher<IPatternMatch>>>(){

                public void apply(IQuerySpecification<? extends ViatraQueryMatcher<IPatternMatch>> spec) {
                    Procedures.Procedure1<IPatternMatch> _function = new Procedures.Procedure1<IPatternMatch>(){

                        public void apply(IPatternMatch b) {
                            if (b instanceof TransitionsMatch) {
                                Transition transition = ((TransitionsMatch)b).getTransition();
                                CPS2DeploymentPartialBatchTransformation.this.transitionMap.put(transition, transition.getAction());
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)delta.appeared.get(spec), (Procedures.Procedure1)_function);
                }
            };
            IterableExtensions.forEach((Iterable)delta.appeared.keySet(), (Procedures.Procedure1)_function);
            this.clearModelPerformance.start();
            this.clearModel(delta);
            this.clearModelPerformance.stop();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing transformation on:");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Cyber-physical system: ");
            String _identifier = this.mapping.getCps().getIdentifier();
            _builder.append((Object)_identifier, "\t");
            this.logger.info((Object)_builder);
            this.stateTable = HashBasedTable.create();
            this.traceTable = Maps.newHashMap();
            this.logger.debug((Object)"Running host transformations.");
            Functions.Function1<HostType, EList<HostInstance>> _function_1 = new Functions.Function1<HostType, EList<HostInstance>>(){

                public EList<HostInstance> apply(HostType it) {
                    return it.getInstances();
                }
            };
            Procedures.Procedure1<HostInstance> _function_2 = new Procedures.Procedure1<HostInstance>(){

                public void apply(HostInstance it) {
                    CPS2DeploymentPartialBatchTransformation.this.transform(it);
                }
            };
            IterableExtensions.forEach((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)this.mapping.getCps().getHostTypes(), (Functions.Function1)_function_1)), (Procedures.Procedure1)_function_2);
            this.logger.debug((Object)"Running action transformations.");
            Functions.Function1<DepTransitionMatch, BehaviorTransition> _function_3 = new Functions.Function1<DepTransitionMatch, BehaviorTransition>(){

                public BehaviorTransition apply(DepTransitionMatch it) {
                    return it.getDepTransition();
                }
            };
            Procedures.Procedure1<BehaviorTransition> _function_4 = new Procedures.Procedure1<BehaviorTransition>(){

                public void apply(BehaviorTransition it) {
                    CPS2DeploymentPartialBatchTransformation.this.mapAction(it);
                }
            };
            IterableExtensions.forEach((Iterable)IterableExtensions.map((Iterable)this.cpsXformM2M.getDepTransition(this.engine).getAllMatches(), (Functions.Function1)_function_3), (Procedures.Procedure1)_function_4);
            this.reportPerformance();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Stopwatch initPerformanceTimers() {
        Stopwatch _xblockexpression = null;
        this.clearModelPerformance = Stopwatch.createUnstarted();
        this.hostTransformationPerformance = Stopwatch.createUnstarted();
        this.appTransformationPerformance = Stopwatch.createUnstarted();
        this.stateMachineTransformationPerformance = Stopwatch.createUnstarted();
        this.stateTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionTransformationPerformance = Stopwatch.createUnstarted();
        this.triggerTransformationPerformance = Stopwatch.createUnstarted();
        _xblockexpression = this.otherTimer = Stopwatch.createUnstarted();
        return _xblockexpression;
    }

    private void reportPerformance() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)">>>Cleared model in: ");
        long _elapsed = this.clearModelPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Host transformation: ");
        long _elapsed_1 = this.hostTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_1);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Application Instance transformation: ");
        long _elapsed_2 = this.appTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_2);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>State Machine transformation: ");
        long _elapsed_3 = this.stateMachineTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_3);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>State transformation: ");
        long _elapsed_4 = this.stateTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_4);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Transition transformation: ");
        long _elapsed_5 = this.transitionTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_5);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Trigger transformation: ");
        long _elapsed_6 = this.triggerTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_6);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Other perf: ");
        long _elapsed_7 = this.otherTimer.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_7);
        _builder.append((Object)" ms");
        this.logger.debug((Object)_builder);
    }

    private void transform(HostInstance cpsHost) {
        try {
            boolean _equals;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: transform(cpsHost = ");
            String _name = NamingUtil.name((EObject)cpsHost);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            this.hostTransformationPerformance.start();
            int _size = this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsHost, null).size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                final DeploymentHost depHost = this.createDepHost(cpsHost);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Adding host (");
                String _description = depHost.getDescription();
                _builder_1.append((Object)_description);
                _builder_1.append((Object)") to deployment model.");
                this.logger.debug((Object)_builder_1);
                EList _hosts = this.mapping.getDeployment().getHosts();
                _hosts.add((Object)depHost);
                this.addTrace((Identifiable)cpsHost, (DeploymentElement)depHost);
                this.hostTransformationPerformance.stop();
                this.logger.debug((Object)"Running application instance transformations.");
                Functions.Function1<ApplicationInstance, Boolean> _function = new Functions.Function1<ApplicationInstance, Boolean>(){

                    public Boolean apply(ApplicationInstance it) {
                        ApplicationType _type = it.getType();
                        CyberPhysicalSystem _cps = null;
                        if (_type != null) {
                            _cps = _type.getCps();
                        }
                        CyberPhysicalSystem _cps_1 = CPS2DeploymentPartialBatchTransformation.this.mapping.getCps();
                        return Objects.equal((Object)_cps, (Object)_cps_1);
                    }
                };
                Procedures.Procedure1<ApplicationInstance> _function_1 = new Procedures.Procedure1<ApplicationInstance>(){

                    public void apply(ApplicationInstance it) {
                        CPS2DeploymentPartialBatchTransformation.this.transform(it, depHost);
                    }
                };
                IterableExtensions.forEach((Iterable)IterableExtensions.filter((Iterable)cpsHost.getApplications(), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"Running application instance transformations finished");
                this.logger.debug((Object)_builder_2);
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)"Execution ended: transform");
                this.logger.trace((Object)_builder_3);
            } else {
                DeploymentElement element = ((Cps2depTraceMatch[])Conversions.unwrapArray(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsHost, null), Cps2depTraceMatch.class))[0].getDepElement();
                final DeploymentHost depHost_1 = (DeploymentHost)element;
                this.hostTransformationPerformance.stop();
                this.logger.debug((Object)"Running application instance transformations.");
                Functions.Function1<ApplicationInstance, Boolean> _function_2 = new Functions.Function1<ApplicationInstance, Boolean>(){

                    public Boolean apply(ApplicationInstance it) {
                        ApplicationType _type = it.getType();
                        CyberPhysicalSystem _cps = null;
                        if (_type != null) {
                            _cps = _type.getCps();
                        }
                        CyberPhysicalSystem _cps_1 = CPS2DeploymentPartialBatchTransformation.this.mapping.getCps();
                        return Objects.equal((Object)_cps, (Object)_cps_1);
                    }
                };
                Procedures.Procedure1<ApplicationInstance> _function_3 = new Procedures.Procedure1<ApplicationInstance>(){

                    public void apply(ApplicationInstance it) {
                        CPS2DeploymentPartialBatchTransformation.this.transform(it, depHost_1);
                    }
                };
                IterableExtensions.forEach((Iterable)IterableExtensions.filter((Iterable)cpsHost.getApplications(), (Functions.Function1)_function_2), (Procedures.Procedure1)_function_3);
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append((Object)"Running application instance transformations finished");
                this.logger.debug((Object)_builder_4);
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append((Object)"Execution ended: transform");
                this.logger.trace((Object)_builder_5);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void transform(ApplicationInstance cpsInstance, DeploymentHost depHost) {
        try {
            boolean _equals;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: transform(cpsInstance = ");
            String _name = NamingUtil.name((EObject)cpsInstance);
            _builder.append((Object)_name);
            _builder.append((Object)", depHost = ");
            String _name_1 = NamingUtil.name((EObject)depHost);
            _builder.append((Object)_name_1);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            this.appTransformationPerformance.start();
            int _size = this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsInstance, null).size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                DeploymentApplication depApp = this.createDepApplication(cpsInstance);
                EList _applications = depHost.getApplications();
                _applications.add((Object)depApp);
                this.addTrace((Identifiable)cpsInstance, (DeploymentElement)depApp);
                this.appTransformationPerformance.stop();
                this.logger.debug((Object)"Running state machine transformations.");
                Stopwatch watch = Stopwatch.createStarted();
                StateMachine _behavior = cpsInstance.getType().getBehavior();
                if (_behavior != null) {
                    this.transform(_behavior, depApp);
                }
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Running state machine transformations (");
                long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
                _builder_1.append((Object)_elapsed);
                _builder_1.append((Object)" ms)");
                this.logger.debug((Object)_builder_1);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"Execution ended: transform");
                this.logger.trace((Object)_builder_2);
            } else {
                DeploymentElement _depElement = ((Cps2depTraceMatch[])Conversions.unwrapArray(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsInstance, null), Cps2depTraceMatch.class))[0].getDepElement();
                DeploymentApplication depApp_1 = (DeploymentApplication)_depElement;
                this.appTransformationPerformance.stop();
                this.logger.debug((Object)"Running state machine transformations.");
                Stopwatch watch_1 = Stopwatch.createStarted();
                StateMachine _behavior_1 = cpsInstance.getType().getBehavior();
                if (_behavior_1 != null) {
                    this.transform(_behavior_1, depApp_1);
                }
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)"Running state machine transformations (");
                long _elapsed_1 = watch_1.elapsed(TimeUnit.MILLISECONDS);
                _builder_3.append((Object)_elapsed_1);
                _builder_3.append((Object)" ms)");
                this.logger.debug((Object)_builder_3);
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append((Object)"Execution ended: transform");
                this.logger.trace((Object)_builder_4);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void transform(final StateMachine cpsBehavior, DeploymentApplication depApp) {
        try {
            boolean _equals;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: transform(cpsBehavior = ");
            String _name = NamingUtil.name((EObject)cpsBehavior);
            _builder.append((Object)_name);
            _builder.append((Object)", depApp = ");
            String _name_1 = NamingUtil.name((EObject)depApp);
            _builder.append((Object)_name_1);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            this.stateMachineTransformationPerformance.start();
            Collection<Sm2DeploymentbehaviorMatch> matches = this.cpsXformM2M.getSm2Deploymentbehavior(this.engine).getAllMatches(this.mapping, cpsBehavior, depApp, null);
            int _size = matches.size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                boolean _notEquals;
                final DeploymentBehavior depBehavior = this.createDepBehavior(cpsBehavior);
                depApp.setBehavior(depBehavior);
                this.addTraceOneToN((Identifiable)cpsBehavior, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depBehavior})));
                this.stateMachineTransformationPerformance.stop();
                this.logger.debug((Object)"Running state transformations.");
                Stopwatch watch = Stopwatch.createStarted();
                Procedures.Procedure1<State> _function = new Procedures.Procedure1<State>(){

                    public void apply(State it) {
                        CPS2DeploymentPartialBatchTransformation.this.transform(it, depBehavior);
                    }
                };
                IterableExtensions.forEach((Iterable)cpsBehavior.getStates(), (Procedures.Procedure1)_function);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Running state transformations finished");
                this.logger.debug((Object)_builder_1);
                this.logger.debug((Object)"Resolving state relationships.");
                watch.reset().start();
                Procedures.Procedure1<State> _function_1 = new Procedures.Procedure1<State>(){

                    public void apply(State it) {
                        CPS2DeploymentPartialBatchTransformation.this.buildStateRelations(it, depBehavior, cpsBehavior);
                    }
                };
                IterableExtensions.forEach((Iterable)cpsBehavior.getStates(), (Procedures.Procedure1)_function_1);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"Resolving state relationships finished");
                this.logger.debug((Object)_builder_2);
                this.logger.debug((Object)"Resolving initial state.");
                this.stateMachineTransformationPerformance.start();
                watch.reset().start();
                State _initial = cpsBehavior.getInitial();
                boolean bl2 = _notEquals = !Objects.equal((Object)_initial, null);
                if (_notEquals) {
                    Functions.Function1<Cps2depTraceMatch, DeploymentElement> _function_2 = new Functions.Function1<Cps2depTraceMatch, DeploymentElement>(){

                        public DeploymentElement apply(Cps2depTraceMatch it) {
                            return it.getDepElement();
                        }
                    };
                    Functions.Function1<BehaviorState, Boolean> _function_3 = new Functions.Function1<BehaviorState, Boolean>(){

                        public Boolean apply(BehaviorState it) {
                            return depBehavior.getStates().contains((Object)it);
                        }
                    };
                    depBehavior.setCurrent((BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.map(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsBehavior.getInitial(), null), (Functions.Function1)_function_2), BehaviorState.class), (Functions.Function1)_function_3));
                } else {
                    depBehavior.setCurrent(null);
                }
            }
            this.stateMachineTransformationPerformance.stop();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)"Resolving initial state finished");
            this.logger.debug((Object)_builder_3);
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)"Execution ended: transform");
            this.logger.trace((Object)_builder_4);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void transform(State cpsState, DeploymentBehavior depBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: transform(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append((Object)_name);
        _builder.append((Object)", depBehavior = ");
        String _name_1 = NamingUtil.name((EObject)depBehavior);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        this.stateTransformationPerformance.start();
        BehaviorState depState = this.createDepState(cpsState);
        EList _states = depBehavior.getStates();
        _states.add((Object)depState);
        this.addTraceOneToN((Identifiable)cpsState, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depState})));
        this.stateTable.put((Object)cpsState, (Object)depBehavior, (Object)depState);
        this.stateTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: transform");
        this.logger.trace((Object)_builder_1);
    }

    private void buildStateRelations(State cpsState, final DeploymentBehavior depBehavior, final StateMachine cpsBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: buildStateRelations(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append((Object)_name);
        _builder.append((Object)", depBehavior = ");
        String _name_1 = NamingUtil.name((EObject)depBehavior);
        _builder.append((Object)_name_1);
        _builder.append((Object)", cpsBehavior = ");
        String _name_2 = NamingUtil.name((EObject)cpsBehavior);
        _builder.append((Object)_name_2);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        this.transitionTransformationPerformance.start();
        final BehaviorState depState = (BehaviorState)this.stateTable.get((Object)cpsState, (Object)depBehavior);
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                return !Objects.equal((Object)it.getTargetState(), null) && cpsBehavior.getStates().contains((Object)it.getTargetState());
            }
        };
        Procedures.Procedure1<Transition> _function_1 = new Procedures.Procedure1<Transition>(){

            public void apply(Transition it) {
                CPS2DeploymentPartialBatchTransformation.this.mapTransition(it, depState, depBehavior);
            }
        };
        IterableExtensions.forEach((Iterable)IterableExtensions.filter((Iterable)cpsState.getOutgoingTransitions(), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
        this.transitionTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: buildStateRelations");
        this.logger.trace((Object)_builder_1);
    }

    private void mapTransition(Transition transition, BehaviorState depState, final DeploymentBehavior depBehavior) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: mapTransition(transition = ");
            String _name = NamingUtil.name((EObject)transition);
            _builder.append((Object)_name);
            _builder.append((Object)", depState = ");
            String _name_1 = NamingUtil.name((EObject)depState);
            _builder.append((Object)_name_1);
            _builder.append((Object)", depBehavior = ");
            String _name_2 = NamingUtil.name((EObject)depBehavior);
            _builder.append((Object)_name_2);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            BehaviorTransition depTransition = this.createDepTransition(transition);
            EList _outgoing = depState.getOutgoing();
            _outgoing.add((Object)depTransition);
            EList _transitions = depBehavior.getTransitions();
            _transitions.add((Object)depTransition);
            this.otherTimer.start();
            this.addTraceOneToN((Identifiable)transition, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depTransition})));
            this.otherTimer.stop();
            Functions.Function1<Cps2depTraceMatch, DeploymentElement> _function = new Functions.Function1<Cps2depTraceMatch, DeploymentElement>(){

                public DeploymentElement apply(Cps2depTraceMatch it) {
                    return it.getDepElement();
                }
            };
            Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                public Boolean apply(BehaviorState it) {
                    return depBehavior.getStates().contains((Object)it);
                }
            };
            depTransition.setTo((BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.map(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)transition.getTargetState(), null), (Functions.Function1)_function), BehaviorState.class), (Functions.Function1)_function_1));
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: mapTransition");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void mapAction(final BehaviorTransition depSendTransition) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: mapAction(depTrigger = ");
            String _name = NamingUtil.name((EObject)depSendTransition);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            this.triggerTransformationPerformance.start();
            Identifiable _head = (Identifiable)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfcpsElement(this.mapping, null, (DeploymentElement)depSendTransition));
            Transition cpsSendTransition = (Transition)_head;
            Iterable cpsWaitTransitions = Iterables.filter(this.cpsXformM2M.getTriggerPair(this.engine).getAllValuesOfcpsTarget(cpsSendTransition), Transition.class);
            EObject _eContainer = depSendTransition.eContainer().eContainer();
            DeploymentApplication senderDepApp = (DeploymentApplication)_eContainer;
            Identifiable _head_1 = (Identifiable)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfcpsElement(this.mapping, null, (DeploymentElement)senderDepApp));
            final ApplicationInstance cpsSendAppInstance = (ApplicationInstance)_head_1;
            Procedures.Procedure1<Transition> _function = new Procedures.Procedure1<Transition>(){

                public void apply(final Transition cpsWaitTransition) {
                    try {
                        Set<ApplicationInstance> cpsWaitAppInstances = CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getCpsApplicationTransition(CPS2DeploymentPartialBatchTransformation.this.engine).getAllValuesOfcpsApp(cpsWaitTransition);
                        Functions.Function1<ApplicationInstance, Boolean> _function = new Functions.Function1<ApplicationInstance, Boolean>(){

                            public Boolean apply(ApplicationInstance it) {
                                try {
                                    return CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getCommunicatingAppInstances(CPS2DeploymentPartialBatchTransformation.this.engine).hasMatch(cpsSendAppInstance, it);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        };
                        Iterable communicatingWaitAppInstances = IterableExtensions.filter(cpsWaitAppInstances, (Functions.Function1)_function);
                        Procedures.Procedure1<ApplicationInstance> _function_1 = new Procedures.Procedure1<ApplicationInstance>(){

                            public void apply(ApplicationInstance cpsWaitAppInstance) {
                                try {
                                    CPS2DeploymentTrace waitTransitionTrace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getCps2depTrace(CPS2DeploymentPartialBatchTransformation.this.engine).getAllValuesOftrace(CPS2DeploymentPartialBatchTransformation.this.mapping, (Identifiable)cpsWaitTransition, null), CPS2DeploymentTrace.class));
                                    CPS2DeploymentTrace waitAppInstanceTrace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getCps2depTrace(CPS2DeploymentPartialBatchTransformation.this.engine).getAllValuesOftrace(CPS2DeploymentPartialBatchTransformation.this.mapping, (Identifiable)cpsWaitAppInstance, null), CPS2DeploymentTrace.class));
                                    final DeploymentApplication depWaitApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)waitAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                                    Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                                        public Boolean apply(BehaviorTransition it) {
                                            EObject _eContainer = it.eContainer().eContainer();
                                            return Objects.equal((Object)depWaitApp, (Object)_eContainer);
                                        }
                                    };
                                    BehaviorTransition depWaitTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)waitTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function);
                                    EList _trigger = depSendTransition.getTrigger();
                                    _trigger.add((Object)depWaitTransition);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        };
                        IterableExtensions.forEach((Iterable)communicatingWaitAppInstances, (Procedures.Procedure1)_function_1);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)cpsWaitTransitions, (Procedures.Procedure1)_function);
            this.triggerTransformationPerformance.stop();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: mapAction");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private DeploymentHost createDepHost(HostInstance cpsHost) {
        DeploymentHost _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: createDepHost(cpsHost = ");
        String _name = NamingUtil.name((EObject)cpsHost);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        DeploymentHost depHost = this.depFactory.createDeploymentHost();
        depHost.setIp(cpsHost.getNodeIp());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: createDepHost");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depHost;
        return _xblockexpression;
    }

    private DeploymentApplication createDepApplication(ApplicationInstance cpsAppInstance) {
        DeploymentApplication _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: createDepApplication(cpsAppInstance = ");
        String _name = NamingUtil.name((EObject)cpsAppInstance);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        DeploymentApplication depApp = this.depFactory.createDeploymentApplication();
        depApp.setId(cpsAppInstance.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution: createDepApplication");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depApp;
        return _xblockexpression;
    }

    private DeploymentBehavior createDepBehavior(StateMachine cpsBehavior) {
        DeploymentBehavior _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: createDepBehavior(cpsBehavior = ");
        String _name = NamingUtil.name((EObject)cpsBehavior);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        DeploymentBehavior depBehavior = this.depFactory.createDeploymentBehavior();
        depBehavior.setDescription(cpsBehavior.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: createDepBehavior");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depBehavior;
        return _xblockexpression;
    }

    private BehaviorState createDepState(State cpsState) {
        BehaviorState _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: createDepState(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        BehaviorState depState = this.depFactory.createBehaviorState();
        depState.setDescription(cpsState.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: createDepState");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depState;
        return _xblockexpression;
    }

    private BehaviorTransition createDepTransition(Transition cpsTransition) {
        BehaviorTransition _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: createDepTransition(cpsTransition = ");
        String _name = NamingUtil.name((EObject)cpsTransition);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        BehaviorTransition depTransition = this.depFactory.createBehaviorTransition();
        depTransition.setDescription(cpsTransition.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: createDepTransition");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depTransition;
        return _xblockexpression;
    }

    private void clearModel(ChangeDelta delta) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: clearModel(ChangeDelta delta)");
        this.logger.trace((Object)_builder);
        ArrayListMultimap queue = ArrayListMultimap.create();
        queue.putAll(delta.disappeared);
        queue.putAll(delta.updated);
        Procedures.Procedure1<IQuerySpecification<? extends ViatraQueryMatcher<IPatternMatch>>> _function = new Procedures.Procedure1<IQuerySpecification<? extends ViatraQueryMatcher<IPatternMatch>>>((Multimap)queue){
            private final /* synthetic */ Multimap val$queue;
            {
                this.val$queue = multimap;
            }

            public void apply(IQuerySpecification<? extends ViatraQueryMatcher<IPatternMatch>> spec) {
                Procedures.Procedure1<IPatternMatch> _function = new Procedures.Procedure1<IPatternMatch>(){

                    public void apply(IPatternMatch b) {
                        try {
                            if (b instanceof HostInstancesMatch) {
                                CPS2DeploymentPartialBatchTransformation.this.removeHostInstance(((HostInstancesMatch)b).getHostInstance());
                            }
                            if (b instanceof AppTypesMatch) {
                                CPS2DeploymentPartialBatchTransformation.this.removeAppType(((AppTypesMatch)b).getAppType());
                            }
                            if (b instanceof AppInstancesMatch) {
                                CPS2DeploymentPartialBatchTransformation.this.removeAppInstance(((AppInstancesMatch)b).getAppInstance());
                            }
                            if (b instanceof StateMachinesMatch) {
                                CPS2DeploymentPartialBatchTransformation.this.removeStateMachine(((StateMachinesMatch)b).getStateMachine(), true);
                            }
                            if (b instanceof StatesMatch) {
                                State state = ((StatesMatch)b).getState();
                                CPS2DeploymentPartialBatchTransformation.this.removeState(state);
                                Procedures.Procedure1<State2StatemachineMatch> _function = new Procedures.Procedure1<State2StatemachineMatch>(){

                                    public void apply(State2StatemachineMatch match) {
                                        CPS2DeploymentPartialBatchTransformation.this.removeStateMachine(match.getSm(), true);
                                    }
                                };
                                IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getState2Statemachine(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(state, null), (Procedures.Procedure1)_function);
                            }
                            if (b instanceof TransitionsMatch) {
                                Transition transition = ((TransitionsMatch)b).getTransition();
                                String action = (String)CPS2DeploymentPartialBatchTransformation.this.transitionMap.get(transition);
                                if (!Objects.equal((Object)action, null) && SignalUtil.isWait((String)action)) {
                                    String id = SignalUtil.getSignalId((String)action);
                                    Procedures.Procedure1<SendTransitionAppSignalMatch> _function_1 = new Procedures.Procedure1<SendTransitionAppSignalMatch>(){

                                        public void apply(SendTransitionAppSignalMatch match) {
                                            try {
                                                CPS2DeploymentPartialBatchTransformation.this.removeTransition(match.getTransition());
                                                Procedures.Procedure1<Transition2StateMachineMatch> _function = new Procedures.Procedure1<Transition2StateMachineMatch>(){

                                                    public void apply(Transition2StateMachineMatch m) {
                                                        CPS2DeploymentPartialBatchTransformation.this.removeStateMachine(m.getSm(), true);
                                                    }
                                                };
                                                IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getTransition2StateMachine(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(match.getTransition(), null), (Procedures.Procedure1)_function);
                                            }
                                            catch (Throwable _e) {
                                                throw Exceptions.sneakyThrow((Throwable)_e);
                                            }
                                        }
                                    };
                                    IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getSendTransitionAppSignal(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(null, null, id), (Procedures.Procedure1)_function_1);
                                }
                                CPS2DeploymentPartialBatchTransformation.this.removeTransition(transition);
                                Procedures.Procedure1<Transition2StateMachineMatch> _function_2 = new Procedures.Procedure1<Transition2StateMachineMatch>(){

                                    public void apply(Transition2StateMachineMatch match) {
                                        CPS2DeploymentPartialBatchTransformation.this.removeStateMachine(match.getSm(), true);
                                    }
                                };
                                IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getTransition2StateMachine(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(transition, null), (Procedures.Procedure1)_function_2);
                            }
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)this.val$queue.get(spec), (Procedures.Procedure1)_function);
            }
        };
        IterableExtensions.forEach((Iterable)queue.keySet(), (Procedures.Procedure1)_function);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: clearModel");
        this.logger.trace((Object)_builder_1);
    }

    private void removeHostInstance(HostInstance host) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: removeHostInstance(app = ");
            String _name = NamingUtil.name((EObject)host);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            Procedures.Procedure1<Cps2depTraceMatch> _function = new Procedures.Procedure1<Cps2depTraceMatch>(){

                public void apply(Cps2depTraceMatch c) {
                    CPS2DeploymentPartialBatchTransformation.this.mapping.getTraces().remove((Object)c.getTrace());
                    CPS2DeploymentPartialBatchTransformation.this.mapping.getDeployment().getHosts().remove((Object)c.getDepElement());
                }
            };
            IterableExtensions.forEach(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)host, null), (Procedures.Procedure1)_function);
            Procedures.Procedure1<ApplicationInstance> _function_1 = new Procedures.Procedure1<ApplicationInstance>(){

                public void apply(ApplicationInstance app) {
                    CPS2DeploymentPartialBatchTransformation.this.removeAppInstance(app);
                }
            };
            IterableExtensions.forEach((Iterable)host.getApplications(), (Procedures.Procedure1)_function_1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: removeHostInstance");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void removeAppInstance(ApplicationInstance app) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: removeAppinstance(app = ");
            String _name = NamingUtil.name((EObject)app);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            Procedures.Procedure1<Cps2depTraceMatch> _function = new Procedures.Procedure1<Cps2depTraceMatch>(){

                public void apply(Cps2depTraceMatch c) {
                    try {
                        boolean _notEquals;
                        DeploymentElement _depElement = c.getDepElement();
                        boolean bl = _notEquals = !Objects.equal((Object)_depElement, null);
                        if (_notEquals) {
                            CPS2DeploymentPartialBatchTransformation.this.mapping.getTraces().remove((Object)c.getTrace());
                            DeploymentElement _depElement_1 = c.getDepElement();
                            final DeploymentApplication depapp = (DeploymentApplication)_depElement_1;
                            Procedures.Procedure1<DepApp2depHostMatch> _function = new Procedures.Procedure1<DepApp2depHostMatch>(){

                                public void apply(DepApp2depHostMatch match) {
                                    DeploymentHost host = match.getDephost();
                                    host.getApplications().remove((Object)depapp);
                                }
                            };
                            IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getDepApp2depHost(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(depapp, null), (Procedures.Procedure1)_function);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.forEach(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)app, null), (Procedures.Procedure1)_function);
            ApplicationType _type = app.getType();
            StateMachine _behavior = null;
            if (_type != null) {
                _behavior = _type.getBehavior();
            }
            if (_behavior != null) {
                this.removeStateMachine(_behavior, true);
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: removeAppinstance");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void removeAppType(ApplicationType app) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: removeAppType(app = ");
        String _name = NamingUtil.name((EObject)app);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        StateMachine _behavior = app.getBehavior();
        if (_behavior != null) {
            this.removeStateMachine(_behavior, true);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Execution ended: removeAppType");
        this.logger.trace((Object)_builder_1);
    }

    private void removeStateMachine(final StateMachine sm, final boolean recursive) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: removeStateMachine(sm = ");
            String _name = NamingUtil.name((EObject)sm);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            Procedures.Procedure1<Cps2depTraceMatch> _function = new Procedures.Procedure1<Cps2depTraceMatch>(){

                public void apply(Cps2depTraceMatch c) {
                    try {
                        boolean _notEquals;
                        DeploymentElement _depElement = c.getDepElement();
                        boolean bl = _notEquals = !Objects.equal((Object)_depElement, null);
                        if (_notEquals) {
                            CPS2DeploymentPartialBatchTransformation.this.mapping.getTraces().remove((Object)c.getTrace());
                            DeploymentElement _depElement_1 = c.getDepElement();
                            DeploymentBehavior depBehavior = (DeploymentBehavior)_depElement_1;
                            Procedures.Procedure1<DepBehavior2depAppMatch> _function = new Procedures.Procedure1<DepBehavior2depAppMatch>(){

                                public void apply(DepBehavior2depAppMatch match) {
                                    DeploymentApplication app = match.getDepapp();
                                    app.setBehavior(null);
                                }
                            };
                            IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getDepBehavior2depApp(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(depBehavior, null), (Procedures.Procedure1)_function);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.forEach(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)sm, null), (Procedures.Procedure1)_function);
            Procedures.Procedure1<State> _function_1 = new Procedures.Procedure1<State>(){

                public void apply(State state) {
                    CPS2DeploymentPartialBatchTransformation.this.removeState(state);
                    Procedures.Procedure1<Transition> _function = new Procedures.Procedure1<Transition>(){

                        public void apply(Transition trans) {
                            try {
                                String action;
                                if (recursive && !Objects.equal((Object)(action = (String)CPS2DeploymentPartialBatchTransformation.this.transitionMap.get(trans)), null) && SignalUtil.isWait((String)action)) {
                                    String id = SignalUtil.getSignalId((String)action);
                                    Procedures.Procedure1<SendTransitionAppSignalMatch> _function = new Procedures.Procedure1<SendTransitionAppSignalMatch>(){

                                        public void apply(SendTransitionAppSignalMatch match) {
                                            try {
                                                Procedures.Procedure1<Transition2StateMachineMatch> _function = new Procedures.Procedure1<Transition2StateMachineMatch>(){

                                                    public void apply(Transition2StateMachineMatch m) {
                                                        boolean _not;
                                                        boolean _equals = m.getSm().equals(sm);
                                                        boolean bl = _not = !_equals;
                                                        if (_not) {
                                                            CPS2DeploymentPartialBatchTransformation.this.removeStateMachine(m.getSm(), false);
                                                        }
                                                    }
                                                };
                                                IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getTransition2StateMachine(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(match.getTransition(), null), (Procedures.Procedure1)_function);
                                            }
                                            catch (Throwable _e) {
                                                throw Exceptions.sneakyThrow((Throwable)_e);
                                            }
                                        }
                                    };
                                    IterableExtensions.forEach(CPS2DeploymentPartialBatchTransformation.this.cpsXformM2M.getSendTransitionAppSignal(CPS2DeploymentPartialBatchTransformation.this.engine).getAllMatches(null, null, id), (Procedures.Procedure1)_function);
                                }
                                CPS2DeploymentPartialBatchTransformation.this.removeTransition(trans);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)state.getOutgoingTransitions(), (Procedures.Procedure1)_function);
                }
            };
            IterableExtensions.forEach((Iterable)sm.getStates(), (Procedures.Procedure1)_function_1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: removeState");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void removeState(State state) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: removeState(trans = ");
            String _name = NamingUtil.name((EObject)state);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            Procedures.Procedure1<Cps2depTraceMatch> _function = new Procedures.Procedure1<Cps2depTraceMatch>(){

                public void apply(Cps2depTraceMatch c) {
                    boolean _notEquals;
                    DeploymentElement _depElement = c.getDepElement();
                    boolean bl = _notEquals = !Objects.equal((Object)_depElement, null);
                    if (_notEquals) {
                        CPS2DeploymentPartialBatchTransformation.this.mapping.getTraces().remove((Object)c.getTrace());
                    }
                }
            };
            IterableExtensions.forEach(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)state, null), (Procedures.Procedure1)_function);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: removeState");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void removeTransition(Transition trans) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing: removeTransition(trans = ");
            String _name = NamingUtil.name((EObject)trans);
            _builder.append((Object)_name);
            _builder.append((Object)")");
            this.logger.trace((Object)_builder);
            Procedures.Procedure1<Cps2depTraceMatch> _function = new Procedures.Procedure1<Cps2depTraceMatch>(){

                public void apply(Cps2depTraceMatch c) {
                    boolean _notEquals;
                    DeploymentElement _depElement = c.getDepElement();
                    boolean bl = _notEquals = !Objects.equal((Object)_depElement, null);
                    if (_notEquals) {
                        CPS2DeploymentPartialBatchTransformation.this.mapping.getTraces().remove((Object)c.getTrace());
                        DeploymentElement _depElement_1 = c.getDepElement();
                        BehaviorTransition depTrans = (BehaviorTransition)_depElement_1;
                        depTrans.getTrigger().clear();
                    }
                }
            };
            IterableExtensions.forEach(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)trans, null), (Procedures.Procedure1)_function);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Execution ended: removeTransition");
            this.logger.trace((Object)_builder_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void addTraceOneToN(Identifiable cpsElement, List<? extends DeploymentElement> depElements) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: addTraceOneToN(cpsElement = ");
        String _name = NamingUtil.name((EObject)cpsElement);
        _builder.append((Object)_name);
        _builder.append((Object)", depElements = [");
        boolean _hasElements = false;
        for (DeploymentElement deploymentElement : depElements) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = NamingUtil.name((EObject)deploymentElement);
            _builder.append((Object)_name_1);
        }
        _builder.append((Object)"])");
        this.logger.trace((Object)_builder);
        CPS2DeploymentTrace trace = this.traceTable.get(cpsElement);
        boolean bl = Objects.equal((Object)trace, null);
        if (bl) {
            trace = this.tracFactory.createCPS2DeploymentTrace();
            this.traceTable.put(cpsElement, trace);
            EList _cpsElements = trace.getCpsElements();
            _cpsElements.add((Object)cpsElement);
        }
        EList _deploymentElements = trace.getDeploymentElements();
        Iterables.addAll((Collection)_deploymentElements, depElements);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Adding trace (");
        String _name_2 = NamingUtil.name((EObject)cpsElement);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)"->[");
        boolean _hasElements_1 = false;
        for (DeploymentElement deploymentElement : depElements) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder_1.appendImmediate((Object)", ", "");
            }
            String _name_3 = NamingUtil.name((EObject)deploymentElement);
            _builder_1.append((Object)_name_3);
        }
        _builder_1.append((Object)"]) to traceability model.");
        this.logger.debug((Object)_builder_1);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append((Object)"Execution ended: addTraceOneToN");
        this.logger.trace((Object)stringConcatenation);
    }

    private void addTrace(Identifiable cpsElement, DeploymentElement depElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing: addTrace(cpsElement = ");
        String _name = NamingUtil.name((EObject)cpsElement);
        _builder.append((Object)_name);
        _builder.append((Object)", depElement = ");
        String _name_1 = NamingUtil.name((EObject)depElement);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.logger.trace((Object)_builder);
        CPS2DeploymentTrace trace = this.tracFactory.createCPS2DeploymentTrace();
        EList _cpsElements = trace.getCpsElements();
        _cpsElements.add((Object)cpsElement);
        EList _deploymentElements = trace.getDeploymentElements();
        _deploymentElements.add((Object)depElement);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"Adding trace (");
        String _name_2 = NamingUtil.name((EObject)cpsElement);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)"->");
        String _name_3 = NamingUtil.name((EObject)depElement);
        _builder_1.append((Object)_name_3);
        _builder_1.append((Object)") to traceability model.");
        this.logger.debug((Object)_builder_1);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"Execution ended: addTrace");
        this.logger.trace((Object)_builder_2);
    }

    public void dispose() {
        boolean _notEquals;
        this.logger.trace((Object)"dispose");
        boolean bl = _notEquals = !Objects.equal((Object)this.monitor, null);
        if (_notEquals) {
            this.monitor.dispose();
        }
        this.monitor = null;
    }
}

