/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;

public class TopologicalSorting {
    public static <T> List<T> compute(IGraphDataSource<T> gds) {
        HashSet visited = new HashSet();
        LinkedList result = new LinkedList();
        Stack<Pair<T>> dfsStack = new Stack<Pair<T>>();
        for (T node : gds.getAllNodes()) {
            if (!visited.contains(node)) {
                dfsStack.push(new Pair<T>(node, false));
            }
            while (!dfsStack.isEmpty()) {
                Pair head = (Pair)dfsStack.pop();
                Object source = head.element;
                if (head.isParent) {
                    result.addFirst(source);
                    continue;
                }
                visited.add(source);
                dfsStack.push(new Pair(source, true));
                for (T target : gds.getTargetNodes(source).keySet()) {
                    if (visited.contains(target)) continue;
                    dfsStack.push(new Pair<T>(target, false));
                }
            }
        }
        return result;
    }

    private static final class Pair<T> {
        public T element;
        public boolean isParent;

        public Pair(T element, boolean isParent) {
            this.element = element;
            this.isParent = isParent;
        }
    }
}

