/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternComposite;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternLeaf;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

public class PatternUnregistrationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        QueryExplorer queryExplorer = QueryExplorer.getInstance(activeWorkbenchWindow);
        TreeSelection selection = (TreeSelection)queryExplorer.getPatternsViewer().getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof PatternLeaf) {
                PatternLeaf leaf = (PatternLeaf)element;
                this.unregisterPattern(queryExplorer, leaf.getFullPatternNamePrefix());
            } else {
                PatternComposite composite = (PatternComposite)element;
                List<PatternLeaf> leaves = composite.getAllLeaves();
                for (PatternLeaf leaf : leaves) {
                    this.unregisterPattern(queryExplorer, leaf.getFullPatternNamePrefix());
                }
            }
            ++n2;
        }
        queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().purge();
        queryExplorer.refreshPatternsViewer();
        return null;
    }

    public void unregisterPattern(QueryExplorer queryExplorer, String fqn) {
        IQuerySpecification<?> specification = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(fqn);
        if (specification != null && !QueryExplorerPatternRegistry.getInstance().isGenerated(specification)) {
            List<IQuerySpecification<?>> removedSpecifications = QueryExplorerPatternRegistry.getInstance().unregisterPattern(specification);
            for (IQuerySpecification<?> removedSpecification : removedSpecifications) {
                queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().removeComponent(removedSpecification.getFullyQualifiedName());
                Iterator<PatternMatcherRootContent> iterator = queryExplorer.getRootContent().getChildrenIterator();
                while (iterator.hasNext()) {
                    PatternMatcherRootContent root = iterator.next();
                    root.unregisterPattern(removedSpecification);
                }
                QueryExplorerPatternRegistry.getInstance().removeActivePattern(removedSpecification);
            }
        }
    }
}

