/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternLeaf;

public class PatternComposite
extends PatternComponent {
    protected List<PatternComponent> children;
    private Map<String, PatternComposite> fragmentMap;

    public PatternComposite(String patternNameFragment, PatternComposite parent) {
        this.patternNameFragment = patternNameFragment;
        this.children = new ArrayList<PatternComponent>();
        this.fragmentMap = new HashMap<String, PatternComposite>();
        this.parent = parent;
    }

    public void clear() {
        this.children.clear();
        this.fragmentMap.clear();
    }

    public List<PatternComponent> find(String patternFragment) {
        ArrayList<PatternComponent> components = new ArrayList<PatternComponent>();
        this.find(patternFragment, components);
        return components;
    }

    public PatternComposite getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    private void find(String patternFragment, List<PatternComponent> components) {
        String[] tokens = patternFragment.split("\\.");
        if (tokens.length == 1) {
            for (PatternComponent pc : this.children) {
                if (!pc.getPatternNameFragment().matches(patternFragment)) continue;
                components.add(pc);
            }
        } else {
            String prefix = tokens[0];
            String suffix = patternFragment.substring(prefix.length() + 1);
            PatternComposite composite = this.fragmentMap.get(prefix);
            if (composite != null) {
                components.add(composite);
                composite.find(suffix, components);
            }
        }
    }

    public PatternComponent addComponent(String patternFragment) {
        if (patternFragment == null || "".equals(patternFragment)) {
            return null;
        }
        String[] tokens = patternFragment.split("\\.");
        if (tokens.length == 1) {
            PatternLeaf leaf = new PatternLeaf(patternFragment, this);
            leaf.selected = true;
            this.children.add(leaf);
            return leaf;
        }
        String prefix = tokens[0];
        String suffix = patternFragment.substring(prefix.length() + 1);
        PatternComposite composite = this.fragmentMap.get(prefix);
        if (composite == null) {
            composite = new PatternComposite(prefix, this);
            this.fragmentMap.put(prefix, composite);
            this.children.add(composite);
        }
        return composite.addComponent(suffix);
    }

    public List<PatternLeaf> getAllLeaves() {
        ArrayList<PatternLeaf> leaves = new ArrayList<PatternLeaf>();
        for (PatternComponent component : this.children) {
            if (component instanceof PatternLeaf) {
                leaves.add((PatternLeaf)component);
                continue;
            }
            leaves.addAll(((PatternComposite)component).getAllLeaves());
        }
        return leaves;
    }

    public List<PatternLeaf> getDirectLeaves() {
        ArrayList<PatternLeaf> leaves = new ArrayList<PatternLeaf>();
        for (PatternComponent component : this.children) {
            if (!(component instanceof PatternLeaf)) continue;
            leaves.add((PatternLeaf)component);
        }
        return leaves;
    }

    public void purge() {
        ArrayList<PatternComponent> copyOfChildren = new ArrayList<PatternComponent>(this.children);
        for (PatternComponent component : copyOfChildren) {
            if (!(component instanceof PatternComposite)) continue;
            PatternComposite composite = (PatternComposite)component;
            composite.purge();
        }
        if (this.getAllLeaves().size() == 0) {
            QueryExplorer.getInstance().getPatternsViewerRoot().getGenericPatternsRoot().removeComponent(this.getFullPatternNamePrefix());
        }
    }

    public List<PatternComponent> getAllChildren() {
        ArrayList<PatternComponent> result = new ArrayList<PatternComponent>(this.children);
        for (PatternComponent component : this.children) {
            if (!(component instanceof PatternComposite)) continue;
            result.addAll(((PatternComposite)component).getAllChildren());
        }
        return result;
    }

    @Override
    protected Set<PatternComponent> propagateSelectionStateUpwards() {
        HashSet<PatternComponent> changedComponents = new HashSet<PatternComponent>();
        boolean allSelected = true;
        for (PatternComponent child : this.children) {
            if (child.selected) continue;
            allSelected = false;
        }
        if (allSelected != this.selected) {
            if (QueryExplorer.getInstance() != null) {
                QueryExplorer.getInstance().getPatternsViewer().setChecked((Object)this, allSelected);
            }
            this.selected = allSelected;
            changedComponents.add(this);
        }
        if (this.parent != null) {
            changedComponents.addAll(this.parent.propagateSelectionStateUpwards());
        }
        return changedComponents;
    }

    @Override
    protected Set<PatternComponent> propagateSelectionStateDownwards() {
        HashSet<PatternComponent> changedComponents = new HashSet<PatternComponent>();
        for (PatternComponent child : this.children) {
            if (child.selected != this.selected) {
                changedComponents.add(child);
                child.selected = this.selected;
                if (QueryExplorer.getInstance() != null) {
                    QueryExplorer.getInstance().getPatternsViewer().setChecked((Object)child, this.selected);
                }
            }
            changedComponents.addAll(child.propagateSelectionStateDownwards());
        }
        return changedComponents;
    }

    public void removeComponent(String patternFragment) {
        if (patternFragment == null || "".equals(patternFragment)) {
            return;
        }
        String[] tokens = patternFragment.split("\\.");
        if (tokens.length == 1) {
            PatternComponent component = null;
            for (PatternComponent c : this.children) {
                if (!c.getPatternNameFragment().matches(patternFragment)) continue;
                component = c;
            }
            if (component != null) {
                this.children.remove(component);
                this.fragmentMap.remove(patternFragment);
            }
        } else {
            String prefix = tokens[0];
            String suffix = patternFragment.substring(prefix.length() + 1);
            PatternComposite composite = this.fragmentMap.get(prefix);
            if (composite != null) {
                composite.removeComponent(suffix);
            }
        }
    }

    public List<PatternComponent> getDirectChildren() {
        return this.children;
    }

    @Override
    public String getFullPatternNamePrefix() {
        StringBuilder sb = new StringBuilder(this.patternNameFragment);
        if (this.parent != null && this.parent.getParent() != null) {
            sb.insert(0, ".");
            sb.insert(0, this.parent.getFullPatternNamePrefix());
        }
        return sb.toString();
    }

    @Override
    public void updateHasChildren() {
        if (QueryExplorer.getInstance() != null) {
            CheckboxTreeViewer patternsViewer = QueryExplorer.getInstance().getPatternsViewer();
            if (patternsViewer.getExpandedState((Object)this)) {
                for (PatternComponent pc : this.children) {
                    pc.updateHasChildren();
                }
            } else {
                patternsViewer.setHasChildren((Object)this, this.children.size() > 0);
            }
        }
    }

    public int hashCode() {
        int hash = this.patternNameFragment.hashCode();
        for (PatternComponent pc : this.children) {
            hash += 31 * pc.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PatternComposite composite = (PatternComposite)obj;
        return this.patternNameFragment == composite.patternNameFragment && this.parent == composite.parent && this.children.equals(composite.children);
    }
}

