/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.xbase.lib.Extension;

public class ParallelFileSystemSupport
implements MutableFileSystemSupport {
    private final URI uri;
    private final MutableFileSystemSupport delegate;
    @Extension
    private final FileSystemAccessQueue queue;

    public ParallelFileSystemSupport(URI uri, MutableFileSystemSupport delegate, FileSystemAccessQueue queue) {
        this.uri = uri;
        this.delegate = delegate;
        this.queue = queue;
    }

    public void delete(final Path path) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                ParallelFileSystemSupport.this.delegate.delete(path);
            }
        };
        this.queue.sendAsync(this.uri, _function);
    }

    public void mkdir(final Path path) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                ParallelFileSystemSupport.this.delegate.mkdir(path);
            }
        };
        this.queue.sendAsync(this.uri, _function);
    }

    public void setContents(final Path path, final CharSequence contents) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                ParallelFileSystemSupport.this.delegate.setContents(path, contents);
            }
        };
        this.queue.sendAsync(this.uri, _function);
    }

    public void setContentsAsStream(final Path path, final InputStream source) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                ParallelFileSystemSupport.this.delegate.setContentsAsStream(path, source);
            }
        };
        this.queue.sendAsync(this.uri, _function);
    }

    public boolean exists(Path path) {
        return this.delegate.exists(path);
    }

    public String getCharset(Path path) {
        return this.delegate.getCharset(path);
    }

    public Iterable<? extends Path> getChildren(Path path) {
        return this.delegate.getChildren(path);
    }

    public CharSequence getContents(Path path) {
        return this.delegate.getContents(path);
    }

    public InputStream getContentsAsStream(Path path) {
        return this.delegate.getContentsAsStream(path);
    }

    public long getLastModification(Path path) {
        return this.delegate.getLastModification(path);
    }

    public boolean isFile(Path path) {
        return this.delegate.isFile(path);
    }

    public boolean isFolder(Path path) {
        return this.delegate.isFolder(path);
    }

    public java.net.URI toURI(Path path) {
        return this.delegate.toURI(path);
    }
}

