/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.tuple;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.tuple.Clearable;

public class TupleMemory
implements Clearable,
Collection<Tuple> {
    protected Map<Tuple, Integer> occurrences = CollectionsFactory.getMap();

    public int get(Tuple ps) {
        Integer count = this.occurrences.get(ps);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public boolean add(Tuple ps) {
        return this.add(ps, 1);
    }

    public boolean add(Tuple ps, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("The count value must be positive!");
        }
        Integer oldCount = this.occurrences.get(ps);
        if (oldCount != null) {
            this.occurrences.put(ps, oldCount + count);
        } else {
            this.occurrences.put(ps, count);
        }
        return oldCount == null;
    }

    public boolean demandAdd(Tuple ps) {
        return this.demandAdd(ps, 1);
    }

    public boolean demandAdd(Tuple ps, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("The count value must be positive!");
        }
        Integer oldCount = this.occurrences.get(ps);
        if (oldCount != null) {
            this.occurrences.put(ps, oldCount + count);
        }
        return oldCount != null;
    }

    public boolean remove(Tuple ps) {
        boolean empty;
        int rest = this.occurrences.get(ps) - 1;
        boolean bl = empty = rest == 0;
        if (!empty) {
            this.occurrences.put(ps, rest);
        } else {
            this.occurrences.remove(ps);
        }
        return empty;
    }

    public void clear(Tuple ps) {
        this.occurrences.remove(ps);
    }

    @Override
    public void clear() {
        this.occurrences.clear();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.occurrences.keySet().iterator();
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> arg0) {
        boolean change = false;
        for (Tuple tuple : arg0) {
            change |= this.add(tuple);
        }
        return change;
    }

    @Override
    public boolean contains(Object arg) {
        return this.occurrences.containsKey(arg);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.occurrences.keySet().containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.occurrences.isEmpty();
    }

    @Override
    public boolean remove(Object arg0) {
        return this.remove((Tuple)arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        boolean change = false;
        for (Object o : arg0) {
            change |= this.remove(o);
        }
        return change;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.occurrences.keySet().retainAll(arg0);
    }

    @Override
    public int size() {
        return this.occurrences.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.occurrences.size()]);
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.occurrences.keySet().toArray(arg0);
    }

    public String toString() {
        return "TM" + this.occurrences.keySet();
    }
}

