/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class GenericTypeCheck
extends CheckOperation
implements IIteratingSearchOperation {
    private final IInputKey type;
    private final Integer[] positions;

    public GenericTypeCheck(IInputKey type, Integer[] positions) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %s parameters, but %s positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        this.positions = positions;
        this.type = type;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.positions);
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        Object[] seed = new Object[this.positions.length];
        int i = 0;
        while (i < this.positions.length) {
            seed[i] = frame.get(this.positions[i]);
            ++i;
        }
        return context.getRuntimeContext().containsTuple(this.type, Tuples.flatTupleOf((Object[])seed));
    }

    public String toString() {
        Iterator parameterIndexii = Iterators.transform((Iterator)Iterators.forArray((Object[])this.positions), (Function)new Function<Integer, String>(){

            public String apply(Integer input) {
                return String.format("+%d", input);
            }
        });
        return "check     " + this.type.getPrettyPrintableName() + "(" + Joiner.on((String)", ").join(parameterIndexii) + ")";
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }
}

