/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;

public class ExtendToEStructuralFeatureSource
extends ExtendOperation<Object> {
    private int targetPosition;
    private EStructuralFeature feature;

    public ExtendToEStructuralFeatureSource(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        super(sourcePosition);
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        if (!(this.feature instanceof EReference)) {
            throw new LocalSearchException("Without base index, inverse navigation only possible along EReferences with defined EOpposite.");
        }
        EReference oppositeFeature = ((EReference)this.feature).getEOpposite();
        if (oppositeFeature == null) {
            throw new LocalSearchException("Feature has no EOpposite, so cannot do inverse navigation " + this.feature.toString());
        }
        try {
            EObject value = (EObject)frame.getValue(this.targetPosition);
            if (!oppositeFeature.getEContainingClass().isSuperTypeOf(value.eClass())) {
                this.it = Collections.emptyIterator();
                return;
            }
            Object featureValue = value.eGet((EStructuralFeature)oppositeFeature);
            if (oppositeFeature.isMany()) {
                if (featureValue != null) {
                    Collection objectCollection = (Collection)featureValue;
                    this.it = objectCollection.iterator();
                } else {
                    this.it = Collections.emptyIterator();
                }
            } else {
                this.it = featureValue != null ? Iterators.singletonIterator((Object)featureValue) : Collections.emptyIterator();
            }
        }
        catch (ClassCastException e) {
            throw new LocalSearchException("Invalid feature target in parameter" + Integer.toString(this.targetPosition), e);
        }
    }

    public String toString() {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + this.position + ", +" + this.targetPosition + ") iterating";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object)this.targetPosition, (Object[])new Integer[0]);
    }
}

