/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.CallOperationHelper;
import org.eclipse.viatra.query.runtime.localsearch.operations.TransitiveClosureGraph;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public abstract class ExtendBinaryTransitiveClosureIncremental
extends ExtendOperation<Object> {
    private final CallOperationHelper helper;
    private final int seedPosition;

    protected ExtendBinaryTransitiveClosureIncremental(MatcherReference calledQuery, int seedPosition, int targetPosition) {
        super(targetPosition);
        this.seedPosition = seedPosition;
        this.helper = new CallOperationHelper(calledQuery, (Map<PParameter, Integer>)ImmutableMap.of((Object)((PParameter)calledQuery.getQuery().getParameters().get(0)), (Object)seedPosition, (Object)((PParameter)calledQuery.getQuery().getParameters().get(1)), (Object)targetPosition));
    }

    protected abstract Object getSource(Tuple var1);

    protected abstract Iterable<Object> getTargets(Tuple var1, TransitiveClosureGraph var2);

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        TransitiveClosureGraph closure = TransitiveClosureGraph.accessClosureGraph(context, this.helper);
        this.it = this.getTargets(frame, closure).iterator();
    }

    public String toString() {
        String c = this.helper.toString();
        int p = c.indexOf(40);
        return "extend    find " + c.substring(0, p) + "+" + c.substring(p) + "[incremental]";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.seedPosition, (Object)this.position, (Object[])new Integer[0]);
    }

    public static class Backward
    extends ExtendBinaryTransitiveClosureIncremental {
        public Backward(MatcherReference calledQuery, int sourcePosition, int targetPosition) {
            super(calledQuery, targetPosition, sourcePosition);
        }

        @Override
        protected Object getSource(Tuple frame) {
            return frame.get(1);
        }

        @Override
        protected Iterable<Object> getTargets(Tuple frame, TransitiveClosureGraph closure) {
            return closure.getAllSources(frame.get(1));
        }
    }

    public static class Forward
    extends ExtendBinaryTransitiveClosureIncremental {
        public Forward(MatcherReference calledQuery, int sourcePosition, int targetPosition) {
            super(calledQuery, sourcePosition, targetPosition);
        }

        @Override
        protected Object getSource(Tuple frame) {
            return frame.get(1);
        }

        @Override
        protected Iterable<Object> getTargets(Tuple frame, TransitiveClosureGraph closure) {
            return closure.getAllSources(frame.get(0));
        }
    }
}

