/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.CallOperationHelper;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public abstract class ExtendBinaryTransitiveClosure
extends ExtendOperation<Object> {
    private final CallOperationHelper helper;
    private final int seedPosition;

    protected ExtendBinaryTransitiveClosure(MatcherReference calledQuery, int seedPosition, int targetPosition) {
        super(targetPosition);
        this.seedPosition = seedPosition;
        this.helper = new CallOperationHelper(calledQuery, (Map<PParameter, Integer>)ImmutableMap.of((Object)((PParameter)calledQuery.getQuery().getParameters().get(0)), (Object)seedPosition, (Object)((PParameter)calledQuery.getQuery().getParameters().get(1)), (Object)targetPosition));
    }

    protected abstract Object[] calculateCallFrame(Object var1);

    protected abstract Object getTarget(Tuple var1);

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        CallOperationHelper.PatternCall call = this.helper.createCall(context);
        LinkedList<Object> seedsToEvaluate = new LinkedList<Object>();
        seedsToEvaluate.add(frame.get(this.seedPosition));
        HashSet seedsEvaluated = new HashSet();
        HashSet<Object> targetsFound = new HashSet<Object>();
        while (!seedsToEvaluate.isEmpty()) {
            Object currentValue = seedsToEvaluate.poll();
            seedsEvaluated.add(currentValue);
            Object[] mappedFrame = this.calculateCallFrame(currentValue);
            for (Tuple tuple : call.getAllMatches(mappedFrame)) {
                Object foundTarget = this.getTarget(tuple);
                targetsFound.add(foundTarget);
                if (seedsEvaluated.contains(foundTarget)) continue;
                seedsToEvaluate.add(foundTarget);
            }
        }
        this.it = targetsFound.iterator();
    }

    public String toString() {
        String c = this.helper.toString();
        int p = c.indexOf(40);
        return "extend    find " + c.substring(0, p) + "+" + c.substring(p);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.seedPosition, (Object)this.position, (Object[])new Integer[0]);
    }

    public static class Backward
    extends ExtendBinaryTransitiveClosure {
        public Backward(MatcherReference calledQuery, int sourcePosition, int targetPosition) {
            super(calledQuery, targetPosition, sourcePosition);
        }

        @Override
        protected Object[] calculateCallFrame(Object seed) {
            Object[] objectArray = new Object[2];
            objectArray[1] = seed;
            return objectArray;
        }

        @Override
        protected Object getTarget(Tuple frame) {
            return frame.get(0);
        }
    }

    public static class Forward
    extends ExtendBinaryTransitiveClosure {
        public Forward(MatcherReference calledQuery, int sourcePosition, int targetPosition) {
            super(calledQuery, sourcePosition, targetPosition);
        }

        @Override
        protected Object[] calculateCallFrame(Object seed) {
            Object[] objectArray = new Object[2];
            objectArray[0] = seed;
            return objectArray;
        }

        @Override
        protected Object getTarget(Tuple frame) {
            return frame.get(1);
        }
    }
}

