/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystemFactory;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.HostClass;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CPSModelBuilderUtil {
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.generator.CPSModelBuilderUtil");
    @Extension
    protected CyberPhysicalSystemFactory cpsFactory = CyberPhysicalSystemFactory.eINSTANCE;
    @Extension
    protected DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    @Extension
    protected TraceabilityFactory traceFactory = TraceabilityFactory.eINSTANCE;

    public CPSToDeployment prepareEmptyModel(final String cpsId) {
        CPSToDeployment _xblockexpression = null;
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource cpsRes = rs.createResource(URI.createURI((String)"dummyCPSUri"));
        Resource depRes = rs.createResource(URI.createURI((String)"dummyDeploymentUri"));
        Resource trcRes = rs.createResource(URI.createURI((String)"dummyTraceabilityUri"));
        CyberPhysicalSystem _createCyberPhysicalSystem = this.cpsFactory.createCyberPhysicalSystem();
        Procedures.Procedure1<CyberPhysicalSystem> _function = new Procedures.Procedure1<CyberPhysicalSystem>(){

            public void apply(CyberPhysicalSystem it) {
                it.setIdentifier(cpsId);
            }
        };
        final CyberPhysicalSystem cps = (CyberPhysicalSystem)ObjectExtensions.operator_doubleArrow((Object)_createCyberPhysicalSystem, (Procedures.Procedure1)_function);
        EList _contents = cpsRes.getContents();
        _contents.add((Object)cps);
        final Deployment dep = this.depFactory.createDeployment();
        EList _contents_1 = depRes.getContents();
        _contents_1.add((Object)dep);
        CPSToDeployment _createCPSToDeployment = this.traceFactory.createCPSToDeployment();
        Procedures.Procedure1<CPSToDeployment> _function_1 = new Procedures.Procedure1<CPSToDeployment>(){

            public void apply(CPSToDeployment it) {
                it.setCps(cps);
                it.setDeployment(dep);
            }
        };
        CPSToDeployment cps2dep = (CPSToDeployment)ObjectExtensions.operator_doubleArrow((Object)_createCPSToDeployment, (Procedures.Procedure1)_function_1);
        EList _contents_2 = trcRes.getContents();
        _contents_2.add((Object)cps2dep);
        _xblockexpression = cps2dep;
        return _xblockexpression;
    }

    public CPSToDeployment prepareCPSModel(String cpsUri) {
        CPSToDeployment _xblockexpression = null;
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource cpsRes = rs.getResource(URI.createURI((String)cpsUri), true);
        Resource depRes = rs.createResource(URI.createURI((String)"dummyDeploymentUri"));
        Resource trcRes = rs.createResource(URI.createURI((String)"dummyTraceabilityUri"));
        EObject _head = (EObject)IterableExtensions.head((Iterable)cpsRes.getContents());
        final CyberPhysicalSystem cps = (CyberPhysicalSystem)_head;
        final Deployment dep = this.depFactory.createDeployment();
        EList _contents = depRes.getContents();
        _contents.add((Object)dep);
        CPSToDeployment _createCPSToDeployment = this.traceFactory.createCPSToDeployment();
        Procedures.Procedure1<CPSToDeployment> _function = new Procedures.Procedure1<CPSToDeployment>(){

            public void apply(CPSToDeployment it) {
                it.setCps(cps);
                it.setDeployment(dep);
            }
        };
        CPSToDeployment cps2dep = (CPSToDeployment)ObjectExtensions.operator_doubleArrow((Object)_createCPSToDeployment, (Procedures.Procedure1)_function);
        EList _contents_1 = trcRes.getContents();
        _contents_1.add((Object)cps2dep);
        _xblockexpression = cps2dep;
        return _xblockexpression;
    }

    public CPSToDeployment preparePersistedCPSModel(URI dirUri, final String modelName) {
        CPSToDeployment _xblockexpression = null;
        ResourceSetImpl rs = new ResourceSetImpl();
        URI modelNameURI = dirUri.appendSegment(modelName);
        Resource cpsRes = rs.createResource(modelNameURI.appendFileExtension("cyberphysicalsystem"));
        Resource depRes = rs.createResource(modelNameURI.appendFileExtension("deployment"));
        Resource trcRes = rs.createResource(modelNameURI.appendFileExtension("traceability"));
        CyberPhysicalSystem _createCyberPhysicalSystem = this.cpsFactory.createCyberPhysicalSystem();
        Procedures.Procedure1<CyberPhysicalSystem> _function = new Procedures.Procedure1<CyberPhysicalSystem>(){

            public void apply(CyberPhysicalSystem it) {
                it.setIdentifier(modelName);
            }
        };
        final CyberPhysicalSystem cps = (CyberPhysicalSystem)ObjectExtensions.operator_doubleArrow((Object)_createCyberPhysicalSystem, (Procedures.Procedure1)_function);
        EList _contents = cpsRes.getContents();
        _contents.add((Object)cps);
        final Deployment dep = this.depFactory.createDeployment();
        EList _contents_1 = depRes.getContents();
        _contents_1.add((Object)dep);
        CPSToDeployment _createCPSToDeployment = this.traceFactory.createCPSToDeployment();
        Procedures.Procedure1<CPSToDeployment> _function_1 = new Procedures.Procedure1<CPSToDeployment>(){

            public void apply(CPSToDeployment it) {
                it.setCps(cps);
                it.setDeployment(dep);
            }
        };
        CPSToDeployment cps2dep = (CPSToDeployment)ObjectExtensions.operator_doubleArrow((Object)_createCPSToDeployment, (Procedures.Procedure1)_function_1);
        EList _contents_2 = trcRes.getContents();
        _contents_2.add((Object)cps2dep);
        _xblockexpression = cps2dep;
        return _xblockexpression;
    }

    @Deprecated
    public CPSToDeployment preparePersistedCPSModel(String dirUri, String modelName) {
        return this.preparePersistedCPSModel(URI.createURI((String)dirUri), modelName);
    }

    public HostType prepareHostTypeWithId(CPSToDeployment cps2dep, String hostId) {
        return this.prepareHostTypeWithId(cps2dep.getCps(), hostId);
    }

    public HostType prepareHostTypeWithId(CyberPhysicalSystem cps, final String hostId) {
        HostType _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding host type (ID: ");
        _builder.append((Object)hostId);
        _builder.append((Object)") to model");
        this.logger.debug((Object)_builder);
        HostType _createHostType = this.cpsFactory.createHostType();
        Procedures.Procedure1<HostType> _function = new Procedures.Procedure1<HostType>(){

            public void apply(HostType it) {
                it.setIdentifier(hostId);
            }
        };
        HostType host = (HostType)ObjectExtensions.operator_doubleArrow((Object)_createHostType, (Procedures.Procedure1)_function);
        EList _hostTypes = cps.getHostTypes();
        _hostTypes.add((Object)host);
        _xblockexpression = host;
        return _xblockexpression;
    }

    public HostInstance prepareHostInstanceWithIP(HostType host, final String instanceId, final String ip) {
        HostInstance _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding host instance (IP: ");
        _builder.append((Object)ip);
        _builder.append((Object)") to host type ");
        String _identifier = host.getIdentifier();
        _builder.append((Object)_identifier);
        this.logger.debug((Object)_builder);
        HostInstance _createHostInstance = this.cpsFactory.createHostInstance();
        Procedures.Procedure1<HostInstance> _function = new Procedures.Procedure1<HostInstance>(){

            public void apply(HostInstance it) {
                it.setIdentifier(instanceId);
                it.setNodeIp(ip);
            }
        };
        HostInstance instance = (HostInstance)ObjectExtensions.operator_doubleArrow((Object)_createHostInstance, (Procedures.Procedure1)_function);
        EList _instances = host.getInstances();
        _instances.add((Object)instance);
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public HostInstance prepareHostInstance(CPSToDeployment cps2dep) {
        HostInstance hostInstance;
        HostInstance _xblockexpression = null;
        HostType host = this.prepareHostTypeWithId(cps2dep, "simple.cps.host");
        String ip = "1.1.1.1";
        _xblockexpression = hostInstance = this.prepareHostInstanceWithIP(host, "simple.cps.host.instance", "1.1.1.1");
        return _xblockexpression;
    }

    public ApplicationType prepareApplicationTypeWithId(CPSToDeployment cps2dep, String appId) {
        return this.prepareApplicationTypeWithId(cps2dep.getCps(), appId);
    }

    public ApplicationType prepareApplicationTypeWithId(CyberPhysicalSystem cps, final String appId) {
        ApplicationType _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding application type (ID: ");
        _builder.append((Object)appId);
        _builder.append((Object)") to model");
        this.logger.debug((Object)_builder);
        ApplicationType _createApplicationType = this.cpsFactory.createApplicationType();
        Procedures.Procedure1<ApplicationType> _function = new Procedures.Procedure1<ApplicationType>(){

            public void apply(ApplicationType it) {
                it.setIdentifier(appId);
            }
        };
        ApplicationType appType = (ApplicationType)ObjectExtensions.operator_doubleArrow((Object)_createApplicationType, (Procedures.Procedure1)_function);
        EList _appTypes = cps.getAppTypes();
        _appTypes.add((Object)appType);
        _xblockexpression = appType;
        return _xblockexpression;
    }

    public ApplicationInstance prepareApplicationInstanceWithId(ApplicationType app, final String appId, final HostInstance host) {
        ApplicationInstance _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding application instance (ID: ");
        _builder.append((Object)appId);
        _builder.append((Object)") to ");
        String _identifier = app.getIdentifier();
        _builder.append((Object)_identifier);
        this.logger.debug((Object)_builder);
        ApplicationInstance _createApplicationInstance = this.cpsFactory.createApplicationInstance();
        Procedures.Procedure1<ApplicationInstance> _function = new Procedures.Procedure1<ApplicationInstance>(){

            public void apply(ApplicationInstance it) {
                it.setIdentifier(appId);
                it.setAllocatedTo(host);
            }
        };
        ApplicationInstance instance = (ApplicationInstance)ObjectExtensions.operator_doubleArrow((Object)_createApplicationInstance, (Procedures.Procedure1)_function);
        EList _instances = app.getInstances();
        _instances.add((Object)instance);
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public ApplicationInstance prepareApplicationInstanceWithId(ApplicationType app, final String appId) {
        ApplicationInstance _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding application instance (ID: ");
        _builder.append((Object)appId);
        _builder.append((Object)") to ");
        String _identifier = app.getIdentifier();
        _builder.append((Object)_identifier);
        this.logger.debug((Object)_builder);
        ApplicationInstance _createApplicationInstance = this.cpsFactory.createApplicationInstance();
        Procedures.Procedure1<ApplicationInstance> _function = new Procedures.Procedure1<ApplicationInstance>(){

            public void apply(ApplicationInstance it) {
                it.setIdentifier(appId);
            }
        };
        ApplicationInstance instance = (ApplicationInstance)ObjectExtensions.operator_doubleArrow((Object)_createApplicationInstance, (Procedures.Procedure1)_function);
        EList _instances = app.getInstances();
        _instances.add((Object)instance);
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public ApplicationInstance prepareAppInstance(CPSToDeployment cps2dep, HostInstance hostInstance) {
        ApplicationInstance instance;
        ApplicationInstance _xblockexpression = null;
        ApplicationType app = this.prepareApplicationTypeWithId(cps2dep, "simple.cps.app");
        _xblockexpression = instance = this.prepareApplicationInstanceWithId(app, "simple.cps.app.instance", hostInstance);
        return _xblockexpression;
    }

    public StateMachine prepareStateMachine(ApplicationType app, final String smId) {
        StateMachine _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding state machine (ID: ");
        _builder.append((Object)smId);
        _builder.append((Object)") to ");
        String _identifier = app.getIdentifier();
        _builder.append((Object)_identifier);
        this.logger.debug((Object)_builder);
        StateMachine _createStateMachine = this.cpsFactory.createStateMachine();
        Procedures.Procedure1<StateMachine> _function = new Procedures.Procedure1<StateMachine>(){

            public void apply(StateMachine it) {
                it.setIdentifier(smId);
            }
        };
        StateMachine instance = (StateMachine)ObjectExtensions.operator_doubleArrow((Object)_createStateMachine, (Procedures.Procedure1)_function);
        app.setBehavior(instance);
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public State prepareState(StateMachine sm, final String stateId) {
        State _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding state (ID: ");
        _builder.append((Object)stateId);
        _builder.append((Object)") to ");
        String _identifier = sm.getIdentifier();
        _builder.append((Object)_identifier);
        this.logger.debug((Object)_builder);
        State _createState = this.cpsFactory.createState();
        Procedures.Procedure1<State> _function = new Procedures.Procedure1<State>(){

            public void apply(State it) {
                it.setIdentifier(stateId);
            }
        };
        State state = (State)ObjectExtensions.operator_doubleArrow((Object)_createState, (Procedures.Procedure1)_function);
        EList _states = sm.getStates();
        _states.add((Object)state);
        _xblockexpression = state;
        return _xblockexpression;
    }

    public Transition prepareTransition(State source, String trID, State target) {
        Transition _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Adding transition (ID: ");
        _builder.append((Object)trID);
        _builder.append((Object)") between ");
        String _identifier = source.getIdentifier();
        _builder.append((Object)_identifier);
        _builder.append((Object)" and ");
        String _identifier_1 = target.getIdentifier();
        _builder.append((Object)_identifier_1);
        this.logger.debug((Object)_builder);
        Transition transition = this.prepareTransition(source, trID);
        transition.setTargetState(target);
        _xblockexpression = transition;
        return _xblockexpression;
    }

    public Transition prepareTransition(State source, final String trID) {
        Transition _xblockexpression = null;
        Transition _createTransition = this.cpsFactory.createTransition();
        Procedures.Procedure1<Transition> _function = new Procedures.Procedure1<Transition>(){

            public void apply(Transition it) {
                it.setIdentifier(trID);
            }
        };
        Transition transition = (Transition)ObjectExtensions.operator_doubleArrow((Object)_createTransition, (Procedures.Procedure1)_function);
        EList _outgoingTransitions = source.getOutgoingTransitions();
        _outgoingTransitions.add((Object)transition);
        _xblockexpression = transition;
        return _xblockexpression;
    }

    public boolean prepareCommunication(HostInstance srcHost, HostInstance trgHost) {
        boolean _xblockexpression = false;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Create connection from ");
        String _identifier = srcHost.getIdentifier();
        _builder.append((Object)_identifier);
        _builder.append((Object)" to ");
        String _identifier_1 = trgHost.getIdentifier();
        _builder.append((Object)_identifier_1);
        this.logger.debug((Object)_builder);
        _xblockexpression = srcHost.getCommunicateWith().add((Object)trgHost);
        return _xblockexpression;
    }

    public static HashMultimap<HostClass, HostInstance> calculateHostInstancesToHostClassMap(final CPSFragment fragment) {
        final HashMultimap hostClassToInstanceMap = HashMultimap.create();
        Procedures.Procedure1<HostClass> _function = new Procedures.Procedure1<HostClass>(){

            public void apply(HostClass hc) {
                Functions.Function1<HostType, EList<HostInstance>> _function = new Functions.Function1<HostType, EList<HostInstance>>(){

                    public EList<HostInstance> apply(HostType ht) {
                        return ht.getInstances();
                    }
                };
                Iterable instances = Iterables.concat((Iterable)IterableExtensions.map((Iterable)fragment.getHostTypes().get((Object)hc), (Functions.Function1)_function));
                hostClassToInstanceMap.putAll((Object)hc, instances);
            }
        };
        IterableExtensions.forEach((Iterable)fragment.getHostTypes().keySet(), (Procedures.Procedure1)_function);
        return hostClassToInstanceMap;
    }
}

