/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.view;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public abstract class AbstractRegistryView
implements IRegistryView {
    private static final String LISTENER_EXCEPTION_REMOVE = "Exception occurred while notifying view listener %s about entry removal";
    private static final String LISTENER_EXCEPTION_ADD = "Exception occurred while notifying view listener %s about entry addition";
    protected final IQuerySpecificationRegistry registry;
    protected final SetMultimap<String, IQuerySpecificationRegistryEntry> fqnToEntryMap;
    protected final Set<IQuerySpecificationRegistryChangeListener> listeners;
    protected final boolean allowDuplicateFQNs;

    protected abstract boolean isEntryRelevant(IQuerySpecificationRegistryEntry var1);

    public AbstractRegistryView(IQuerySpecificationRegistry registry, boolean allowDuplicateFQNs) {
        this.registry = registry;
        this.allowDuplicateFQNs = allowDuplicateFQNs;
        this.fqnToEntryMap = Multimaps.newSetMultimap((Map)Maps.newTreeMap(), (Supplier)new Supplier<Set<IQuerySpecificationRegistryEntry>>(){

            public Set<IQuerySpecificationRegistryEntry> get() {
                return Sets.newHashSet();
            }
        });
        this.listeners = Sets.newHashSet();
    }

    @Override
    public IQuerySpecificationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Iterable<IQuerySpecificationRegistryEntry> getEntries() {
        ImmutableSet entrySet = ImmutableSet.copyOf((Collection)this.fqnToEntryMap.values());
        return entrySet;
    }

    @Override
    public Set<String> getQuerySpecificationFQNs() {
        ImmutableSet fqns = ImmutableSet.copyOf((Collection)this.fqnToEntryMap.keySet());
        return fqns;
    }

    @Override
    public boolean hasQuerySpecificationFQN(String fullyQualifiedName) {
        Preconditions.checkArgument((fullyQualifiedName != null ? 1 : 0) != 0, (Object)"FQN must not be null!");
        return this.fqnToEntryMap.containsKey((Object)fullyQualifiedName);
    }

    @Override
    public Set<IQuerySpecificationRegistryEntry> getEntries(String fullyQualifiedName) {
        Preconditions.checkArgument((fullyQualifiedName != null ? 1 : 0) != 0, (Object)"FQN must not be null!");
        Set entries = this.fqnToEntryMap.get((Object)fullyQualifiedName);
        return ImmutableSet.copyOf((Collection)entries);
    }

    @Override
    public void addViewListener(IQuerySpecificationRegistryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeViewListener(IQuerySpecificationRegistryChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void entryAdded(IQuerySpecificationRegistryEntry entry) {
        if (this.isEntryRelevant(entry)) {
            String fullyQualifiedName = entry.getFullyQualifiedName();
            if (!this.allowDuplicateFQNs && this.fqnToEntryMap.containsKey((Object)fullyQualifiedName)) {
                Set removed = this.fqnToEntryMap.removeAll((Object)fullyQualifiedName);
                for (IQuerySpecificationRegistryEntry e : removed) {
                    this.notifyListeners(e, false);
                }
            }
            this.fqnToEntryMap.put((Object)fullyQualifiedName, (Object)entry);
            this.notifyListeners(entry, true);
        }
    }

    @Override
    public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
        if (this.isEntryRelevant(entry)) {
            String fullyQualifiedName = entry.getFullyQualifiedName();
            this.fqnToEntryMap.remove((Object)fullyQualifiedName, (Object)entry);
            this.notifyListeners(entry, false);
        }
    }

    private void notifyListeners(IQuerySpecificationRegistryEntry entry, boolean addition) {
        for (IQuerySpecificationRegistryChangeListener listener : this.listeners) {
            try {
                if (addition) {
                    listener.entryAdded(entry);
                    continue;
                }
                listener.entryRemoved(entry);
            }
            catch (Exception ex) {
                Logger logger = ViatraQueryLoggingUtil.getLogger(AbstractRegistryView.class);
                String formatString = addition ? LISTENER_EXCEPTION_ADD : LISTENER_EXCEPTION_REMOVE;
                logger.error((Object)String.format(formatString, listener), (Throwable)ex);
            }
        }
    }
}

