/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.traceeventlogger;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class AsyncFileHandler
extends StreamHandler {
    private static final LogRecord CLOSE_EVENT = new LogRecord(Level.FINEST, "CLOSE_EVENT");
    private FileHandler fFileHandler;
    private BlockingQueue<List<LogRecord>> fQueue;
    private Thread fWriterThread;
    private int fMaxSize = 1024;
    private int fQueueDepth = 10000;
    private int fFlushRate = 1000;
    private String fEncoding;
    private Filter fFilter;
    private ErrorManager fErrorManager;
    private Formatter fFormatter;
    private Level fLevel;
    private volatile boolean fIsEnabled = true;
    private List<LogRecord> fRecordBuffer = new ArrayList<LogRecord>(this.fMaxSize);
    private Timer fTimer = new Timer(false);
    TimerTask fTask = new TimerTask(){

        @Override
        public void run() {
            if (!AsyncFileHandler.this.fRecordBuffer.isEmpty()) {
                AsyncFileHandler.this.flush();
            }
        }
    };

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String prop = manager.getProperty(cname + ".maxSize");
        this.fMaxSize = 1024;
        try {
            this.fMaxSize = Integer.parseInt(prop.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fMaxSize < 0) {
            this.fMaxSize = 1024;
        }
        this.fQueueDepth = 10000;
        prop = manager.getProperty(cname + ".queueDepth");
        try {
            this.fQueueDepth = Integer.parseInt(prop.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fQueueDepth < 0) {
            this.fQueueDepth = 10000;
        }
        this.fFlushRate = 1000;
        prop = manager.getProperty(cname + ".formatter");
        try {
            this.fFormatter = (Formatter)ClassLoader.getSystemClassLoader().loadClass(prop).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        prop = manager.getProperty(cname + ".filter");
        try {
            this.fFilter = (Filter)ClassLoader.getSystemClassLoader().loadClass(prop).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        prop = manager.getProperty(cname + ".encoding");
        try {
            this.setEncoding(prop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        prop = manager.getProperty(cname + ".flushRate");
        try {
            this.fFlushRate = Integer.parseInt(prop.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fFlushRate < 0) {
            this.fFlushRate = 1000;
        }
    }

    public AsyncFileHandler() throws SecurityException, IOException {
        this(null);
    }

    public AsyncFileHandler(String pattern) throws SecurityException, IOException {
        this.configure();
        FileHandler fileHandler = this.fFileHandler = pattern == null ? new FileHandler() : new FileHandler(pattern);
        if (this.fEncoding != null) {
            this.fFileHandler.setEncoding(this.fEncoding);
        }
        if (this.fErrorManager != null) {
            this.fFileHandler.setErrorManager(this.fErrorManager);
        }
        if (this.fFilter != null) {
            this.fFileHandler.setFilter(this.fFilter);
        }
        if (this.fLevel != null) {
            this.fFileHandler.setLevel(this.fLevel);
        }
        if (this.fFormatter != null) {
            this.fFileHandler.setFormatter(this.fFormatter);
        }
        this.fQueue = new ArrayBlockingQueue<List<LogRecord>>(this.fQueueDepth);
        this.fTimer.scheduleAtFixedRate(this.fTask, this.fFlushRate, (long)this.fFlushRate);
        this.fWriterThread = new Thread(() -> {
            try {
                block2: while (true) {
                    List<LogRecord> logRecords = this.fQueue.take();
                    Iterator<LogRecord> iterator = logRecords.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        LogRecord logRecord = iterator.next();
                        if (logRecord == CLOSE_EVENT) {
                            this.fFileHandler.flush();
                            this.fFileHandler.close();
                            return;
                        }
                        this.fFileHandler.publish(logRecord);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.fWriterThread.setName("AsyncFileHandler Writer");
        this.fWriterThread.start();
    }

    @Override
    public synchronized void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        if (this.fFileHandler != null) {
            this.fFileHandler.setEncoding(encoding);
        }
        this.fEncoding = encoding;
    }

    @Override
    public synchronized void setErrorManager(ErrorManager em) {
        if (this.fFileHandler != null) {
            this.fFileHandler.setErrorManager(em);
        }
        this.fErrorManager = em;
    }

    @Override
    public synchronized void setFilter(Filter newFilter) throws SecurityException {
        if (this.fFileHandler != null) {
            this.fFileHandler.setFilter(newFilter);
        }
        this.fFilter = newFilter;
    }

    @Override
    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        if (this.fFileHandler != null) {
            this.fFileHandler.setFormatter(newFormatter);
        }
        this.fFormatter = newFormatter;
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (this.fFileHandler != null) {
            this.fFileHandler.setLevel(newLevel);
        }
        this.fLevel = newLevel;
    }

    @Override
    public synchronized void close() throws SecurityException {
        try {
            this.fRecordBuffer.add(CLOSE_EVENT);
            this.fQueue.put(this.fRecordBuffer);
            this.fWriterThread.join();
            this.fTimer.cancel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.close();
    }

    @Override
    public synchronized void flush() {
        try {
            this.fQueue.put(this.fRecordBuffer);
            this.fRecordBuffer = new ArrayList<LogRecord>(this.fMaxSize);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Filter getFilter() {
        return this.fFileHandler.getFilter();
    }

    @Override
    public String getEncoding() {
        return this.fFileHandler.getEncoding();
    }

    @Override
    public Formatter getFormatter() {
        return this.fFileHandler.getFormatter();
    }

    @Override
    public Level getLevel() {
        return this.fFileHandler.getLevel();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.fIsEnabled && this.fFileHandler.isLoggable(record) && record instanceof LogUtils.TraceEventLogRecord;
    }

    @Override
    public ErrorManager getErrorManager() {
        return this.fFileHandler.getErrorManager();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        try {
            if (this.isLoggable(record)) {
                this.fRecordBuffer.add(record);
                if (this.fRecordBuffer.size() >= this.fMaxSize) {
                    this.fQueue.put(this.fRecordBuffer);
                    this.fRecordBuffer = new ArrayList<LogRecord>(this.fMaxSize);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setEnabled(Boolean isEnabled) {
        this.fIsEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }
}

