/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.core.impl.AbstractTSPoints;
import org.eclipse.trace4cps.core.impl.TimeValuePair;

public final class TSRange
extends AbstractTSPoints {
    private final BigDecimal start;
    private final BigDecimal step;
    private final List<Double> values;

    public TSRange(double start, double step, List<Double> values) {
        this.start = new BigDecimal(start);
        this.step = new BigDecimal(step);
        this.values = values;
    }

    @Override
    public Iterable<TimeValuePair> getData() {
        int index = 0;
        ArrayList<TimeValuePair> points = new ArrayList<TimeValuePair>(this.values.size());
        for (Double val : this.values) {
            BigDecimal ind = new BigDecimal(index);
            BigDecimal tim = this.start.add(ind.multiply(this.step));
            points.add(new TimeValuePair(tim.doubleValue(), val));
            ++index;
        }
        return points;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public Double getFirstTimeStamp() {
        return this.start.doubleValue();
    }

    @Override
    public Double getLastTimeStamp() {
        BigDecimal nSteps = new BigDecimal(this.values.size() > 0 ? this.values.size() - 1 : 0);
        BigDecimal last = this.start.add(nSteps.multiply(this.step));
        return last.doubleValue();
    }

    public Double getStep() {
        return this.step.doubleValue();
    }
}

