/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.select_union;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsChoosenExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

class ChangeCreator {
    private final IFile selectedFile;
    private Change change;
    private final CompilationTimeStamp timestamp;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
        this.timestamp = CompilationTimeStamp.getBaseTimestamp();
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        DefinitionVisitor vis = new DefinitionVisitor();
        module.accept((ASTVisitor)vis);
        List nodes = vis.getLocations();
        if (nodes.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        if (nodes.isEmpty()) {
            return tfc;
        }
        Integer i = 0;
        while (i < nodes.size()) {
            this.makeChange((SelectCase_Statement)nodes.get(i), rootEdit, (List)vis.getReferences().get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (!rootEdit.hasChildren()) {
            return null;
        }
        return tfc;
    }

    private void makeChange(SelectCase_Statement statement, MultiTextEdit rootEdit, List<Reference> elements) {
        List scs = statement.getSelectCases().getSelectCaseArray();
        if (scs.size() < elements.size()) {
            return;
        }
        ReplaceEdit insertUnion = new ReplaceEdit(statement.getLocation().getOffset() + 6, 0, " union");
        int statementBegin = statement.getExpression().getLocation().getOffset();
        int statementEnd = statement.getExpression().getLocation().getEndOffset();
        int elementNameLength = elements.get(0).getDisplayName().lastIndexOf(".");
        String elementName = elements.get(0).getDisplayName().substring(0, elementNameLength);
        ReplaceEdit changeExpression = new ReplaceEdit(statementBegin, statementEnd - statementBegin, elementName);
        ReplaceEdit[] changeCases = new ReplaceEdit[elements.size()];
        Integer i = 0;
        while (i < elements.size()) {
            int startOfIschosen = ((SelectCase)scs.get(i)).getLocation().getOffset();
            int startOfStatement = ((SelectCase)scs.get(i)).getStatementBlock().getLocation().getOffset();
            String fieldName = elements.get(i).getDisplayName().substring(elementNameLength + 1);
            changeCases[i.intValue()] = new ReplaceEdit(startOfIschosen, startOfStatement - startOfIschosen, "case(" + fieldName + ")");
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        try {
            rootEdit.addChild((TextEdit)insertUnion);
            rootEdit.addChild((TextEdit)changeExpression);
            rootEdit.addChildren((TextEdit[])changeCases);
        }
        catch (MalformedTreeException malformedTreeException) {
            // empty catch block
        }
    }

    private class DefinitionVisitor
    extends ASTVisitor {
        private final List<SelectCase_Statement> locations = new ArrayList<SelectCase_Statement>();
        private final List<List<Reference>> references = new ArrayList<List<Reference>>();

        DefinitionVisitor() {
        }

        private List<SelectCase_Statement> getLocations() {
            return this.locations;
        }

        private List<List<Reference>> getReferences() {
            return this.references;
        }

        public int visit(IVisitableNode node) {
            if (!(node instanceof SelectCase_Statement)) {
                return 3;
            }
            SelectCase_Statement s = (SelectCase_Statement)node;
            Value v = s.getExpression();
            if (v == null || v.getIsErroneous(ChangeCreator.this.timestamp)) {
                return 3;
            }
            SelectCases scs = s.getSelectCases();
            if (scs == null || scs.getSelectCaseArray() == null) {
                return 3;
            }
            boolean hasElseBranch = false;
            for (SelectCase sc : scs.getSelectCaseArray()) {
                if (!sc.hasElse()) continue;
                hasElseBranch = true;
            }
            if (!(v instanceof Boolean_Value) || !((Boolean_Value)v).getValue()) {
                return 3;
            }
            CaseVisitor caseVisitor = new CaseVisitor();
            scs.accept((ASTVisitor)caseVisitor);
            if (caseVisitor.isErronous()) {
                return 3;
            }
            UnionItemVisitor unionVisitor = new UnionItemVisitor();
            ArrayList<Identifier> foundIds = new ArrayList<Identifier>();
            for (Reference ref : caseVisitor.getReferenceList()) {
                List reflist = ref.getSubreferences();
                if (reflist.isEmpty()) continue;
                foundIds.add(((ISubReference)reflist.get(reflist.size() - 1)).getId());
            }
            if (foundIds.isEmpty()) {
                return 3;
            }
            if (caseVisitor.getUnionType() == null) {
                return 3;
            }
            caseVisitor.getUnionType().accept((ASTVisitor)unionVisitor);
            List<Identifier> unionItems = unionVisitor.getItemsFound();
            if (unionItems.isEmpty() || !hasElseBranch && unionItems.size() != foundIds.size()) {
                return 3;
            }
            for (Identifier item : foundIds) {
                unionItems.remove(item);
            }
            if (!hasElseBranch && unionItems.isEmpty() || hasElseBranch) {
                this.locations.add(s);
                this.references.add(caseVisitor.getReferenceList());
            }
            return 3;
        }

        private final class UnionItemVisitor
        extends ASTVisitor {
            private final List<Identifier> itemsFound = new ArrayList<Identifier>();

            private UnionItemVisitor() {
            }

            public List<Identifier> getItemsFound() {
                return this.itemsFound;
            }

            public int visit(IVisitableNode node) {
                if (node instanceof TTCN3_Choice_Type) {
                    return 3;
                }
                if (node instanceof WithAttributesPath) {
                    return 3;
                }
                if (node instanceof CompFieldMap) {
                    CompFieldMap cm = (CompFieldMap)node;
                    Map map = cm.getComponentFieldMap(ChangeCreator.this.timestamp);
                    for (Map.Entry entry : map.entrySet()) {
                        this.itemsFound.add(((CompField)entry.getValue()).getIdentifier());
                    }
                    return 3;
                }
                return 1;
            }
        }

        private final class IsChoosenItemVisitor
        extends ASTVisitor {
            private Reference reference;

            private IsChoosenItemVisitor() {
            }

            public Reference getReference() {
                return this.reference;
            }

            public int visit(IVisitableNode node) {
                if (node instanceof IsChoosenExpression) {
                    return 3;
                }
                if (node instanceof Reference) {
                    this.reference = (Reference)node;
                    return 1;
                }
                return 1;
            }
        }

        private final class CaseVisitor
        extends ASTVisitor {
            private boolean errorDuringVisiting = false;
            private final List<Reference> references = new ArrayList<Reference>();
            private IType unionType = null;

            private CaseVisitor() {
            }

            public boolean isErronous() {
                return this.errorDuringVisiting;
            }

            public List<Reference> getReferenceList() {
                return this.references;
            }

            public IType getUnionType() {
                return this.unionType;
            }

            public int visit(IVisitableNode node) {
                if (node instanceof SelectCases) {
                    return 3;
                }
                if (node instanceof SelectCase) {
                    return 3;
                }
                if (node instanceof TemplateInstances) {
                    return 3;
                }
                if (node instanceof TemplateInstance) {
                    TemplateInstance ti = (TemplateInstance)node;
                    IValue val = ti.getTemplateBody().getValue();
                    if (val == null || val.getIsErroneous(ChangeCreator.this.timestamp) || !(val instanceof IsChoosenExpression)) {
                        this.errorDuringVisiting = true;
                        return 2;
                    }
                    IsChoosenExpression expr = (IsChoosenExpression)val;
                    IsChoosenItemVisitor itemVisitor = new IsChoosenItemVisitor();
                    expr.accept((ASTVisitor)itemVisitor);
                    if (itemVisitor.getReference() == null) {
                        this.errorDuringVisiting = true;
                        return 2;
                    }
                    if (!this.references.isEmpty() && !itemVisitor.getReference().getRefdAssignment(ChangeCreator.this.timestamp, false).equals(this.references.get(0).getRefdAssignment(ChangeCreator.this.timestamp, false))) {
                        this.errorDuringVisiting = true;
                        return 2;
                    }
                    if (this.unionType == null) {
                        IType itype = itemVisitor.getReference().checkVariableReference(ChangeCreator.this.timestamp);
                        if (itype instanceof Referenced_Type) {
                            itype = itype.getTypeRefdLast(ChangeCreator.this.timestamp);
                        }
                        if (itype != null) {
                            this.unionType = itype.getParentType();
                        }
                    }
                    this.references.add(itemVisitor.getReference());
                    return 1;
                }
                return 1;
            }
        }
    }
}

