/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.definition;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.definition.ExtractDefinitionHeadless;

public class ExtractDefinitionHeadlessRunner
implements IApplication {
    public Object start(IApplicationContext context) {
        Map<String, String> args;
        String[] cmdArguments = (String[])context.getArguments().get("application.args");
        try {
            args = this.processArgs(cmdArguments);
        }
        catch (ArgumentException e) {
            ErrorReporter.logError((String)e.getMessage());
            return -1;
        }
        String sourceProjName = args.get("in");
        String targetProjName = args.get("out");
        String moduleName = args.get("module");
        String definitionName = args.get("definition");
        IProject sourceProj = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProjName);
        if (sourceProj == null || !sourceProj.exists()) {
            ErrorReporter.logError((String)("ExtractDefinitionHeadless: Source project is not exist: " + sourceProjName));
            return -1;
        }
        IProject targetProj = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProjName);
        if (targetProj.exists()) {
            ErrorReporter.logError((String)("ExtractDefinitionHeadless: Output project is already exist: " + targetProjName));
            return -1;
        }
        HashSet<IProject> projsToUpdate = new HashSet<IProject>();
        projsToUpdate.add(sourceProj);
        Utils.updateASTBeforeRefactoring(projsToUpdate, "ExtractDefinition");
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser((IProject)sourceProj);
        Module sourceModule = parser.getModuleByName(moduleName);
        if (sourceModule == null) {
            ErrorReporter.logError((String)("ExtractDefinitionHeadless: Could not find module: " + moduleName));
            return -1;
        }
        Assignment assignment = sourceModule.getAssignments().getLocalAssignmentByID(CompilationTimeStamp.getBaseTimestamp(), new Identifier(Identifier.Identifier_type.ID_NAME, definitionName));
        if (assignment == null) {
            ErrorReporter.logError((String)("ExtractDefinitionHeadless: Could not find definition: " + definitionName));
            return -1;
        }
        if (!(assignment instanceof Definition)) {
            ErrorReporter.logError((String)"ExtractDefinitionHeadless: Currently only TTCN-3 definitions can be the source definition");
            return -1;
        }
        Definition definition = (Definition)assignment;
        ExtractDefinitionHeadless headless = new ExtractDefinitionHeadless();
        String location = args.get("location");
        if (location != null) {
            try {
                File d = new File(location);
                if (!d.exists()) {
                    try {
                        d.mkdirs();
                    }
                    catch (Exception e) {
                        throw new Exception("Could not create the parent folder of the project: " + d.getAbsolutePath());
                    }
                } else if (!d.isDirectory()) {
                    throw new Exception("Provided location must be a directory.");
                }
                File f = new File(location, targetProjName);
                if (f.exists()) {
                    throw new Exception("Project folder is already exist: " + f.getAbsolutePath());
                }
                headless.setLocation(f.toURI());
            }
            catch (URISyntaxException e) {
                ErrorReporter.logError((String)"ExtractDefinitionHeadless: Location parameter is not a valid URI.");
                return -1;
            }
            catch (Exception e) {
                ErrorReporter.logError((String)("ExtractDefinitionHeadless: " + e.getMessage()));
                return -1;
            }
        }
        headless.run(sourceProj, definition, targetProjName);
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private Map<String, String> processArgs(String[] cliArgs) throws ArgumentException {
        HashMap<String, String> arguments = new HashMap<String, String>(cliArgs.length);
        for (int i = 0; i < cliArgs.length; ++i) {
            String arg = cliArgs[i];
            if (!"-in".equals(arg) && !"-out".equals(arg) && !"-location".equals(arg) && !"-definition".equals(arg) && !"-module".equals(arg)) continue;
            if (++i == cliArgs.length) {
                ErrorReporter.logError((String)("Missing argument parameter of " + cliArgs[i - 1]));
                throw new ArgumentException("Missing argument parameter of " + cliArgs[i - 1]);
            }
            arguments.put(cliArgs[i - 1].substring(1), cliArgs[i]);
        }
        if (!arguments.containsKey("in") || ((String)arguments.get("in")).length() == 0) {
            ErrorReporter.logError((String)"Error, missing mandatory argument: -in");
            throw new ArgumentException("Error, missing mandatory argument: -in");
        }
        if (!arguments.containsKey("out") || ((String)arguments.get("out")).length() == 0) {
            ErrorReporter.logError((String)"Error, missing mandatory argument: -out");
            throw new ArgumentException("Error, missing mandatory argument: -out");
        }
        if (!arguments.containsKey("module") || ((String)arguments.get("module")).length() == 0) {
            ErrorReporter.logError((String)"Error, missing mandatory argument: -module");
            throw new ArgumentException("Error, missing mandatory argument: -module");
        }
        if (!arguments.containsKey("definition") || ((String)arguments.get("definition")).length() == 0) {
            ErrorReporter.logError((String)"Error, missing mandatory argument: -definition");
            throw new ArgumentException("Error, missing mandatory argument: -definition");
        }
        return arguments;
    }

    private class ArgumentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ArgumentException(String message) {
            super(message);
        }
    }
}

