/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public final class ConfigReferenceParser
implements IReferenceParser {
    private boolean reportErrors;
    private boolean moduleParameter;
    private String exactModuleName;
    private String defineName;

    public ConfigReferenceParser(boolean reportErrors) {
        this.reportErrors = reportErrors;
        this.moduleParameter = true;
        this.exactModuleName = null;
        this.defineName = null;
    }

    @Override
    public void setErrorReporting(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    @Override
    public Reference findReferenceForCompletion(IFile file, int offset, IDocument document) {
        return null;
    }

    public String findIncludedFileForOpening(int offset, IDocument document) {
        this.moduleParameter = false;
        int ofs = offset - 1;
        int endoffset = offset;
        if (-1 == offset) {
            return null;
        }
        try {
            int tempOfs = this.includeStartOffset(ofs, document);
            if (-1 == tempOfs) {
                return null;
            }
            ofs = tempOfs + 1;
            char currentChar = document.getChar(endoffset);
            while (endoffset < document.getLength() && currentChar != '\"') {
                currentChar = document.getChar(++endoffset);
            }
            return document.get(ofs, endoffset - ofs);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
    }

    @Override
    public Reference findReferenceForOpening(IFile file, int offset, IDocument document) {
        Reference reference = null;
        int ofs = offset - 1;
        int endoffset = offset;
        if (-1 == offset) {
            return reference;
        }
        try {
            String selected;
            int tempOfs = this.referenceStartOffset(ofs, document);
            if (-1 == tempOfs) {
                return reference;
            }
            ofs = tempOfs + 1;
            char currentChar = document.getChar(endoffset);
            while (endoffset < document.getLength() && (Character.isLetterOrDigit(currentChar) || currentChar == '*' || currentChar == '_' || currentChar == '.')) {
                currentChar = document.getChar(++endoffset);
            }
            if (!this.moduleParameter) {
                this.defineName = document.get(ofs, endoffset - ofs);
                return null;
            }
            String parameter = selected = document.get(ofs, endoffset - ofs);
            int dotIndex = selected.indexOf(46);
            if (dotIndex > 0) {
                String moduleName = selected.substring(0, dotIndex);
                if (!"*".equals(moduleName)) {
                    this.exactModuleName = moduleName;
                    IPreferencesService prefs = Platform.getPreferencesService();
                    if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
                        TITANDebugConsole.println("Module: " + this.exactModuleName);
                    }
                }
                parameter = selected.substring(dotIndex + 1);
            }
            reference = TTCN3ReferenceAnalyzer.parse(file, parameter, this.reportErrors, document.getLineOfOffset(ofs) + 1, ofs);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return reference;
    }

    private int referenceStartOffset(int offset, IDocument document) throws BadLocationException {
        int ofs = offset;
        char currentChar = document.getChar(ofs);
        while (ofs > 0 && (Character.isLetterOrDigit(currentChar) || currentChar == '*' || currentChar == '_' || currentChar == '.' || currentChar == '$' || currentChar == '{')) {
            if (currentChar == '$' || currentChar == '{') {
                this.moduleParameter = false;
                break;
            }
            currentChar = document.getChar(--ofs);
        }
        return ofs;
    }

    private int includeStartOffset(int offset, IDocument document) throws BadLocationException {
        int ofs = offset;
        char currentChar = document.getChar(ofs);
        while (ofs > 0 && currentChar != '\"') {
            currentChar = document.getChar(--ofs);
        }
        return ofs;
    }

    public String getExactModuleName() {
        return this.exactModuleName;
    }

    public String getDefinitionName() {
        return this.defineName;
    }

    public boolean isModuleParameter() {
        return this.moduleParameter;
    }
}

