/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class ImplicationMatch_template
extends TTCN3Template {
    private TemplateInstance precondition;
    private TemplateInstance implied_template;

    public ImplicationMatch_template(TTCN3Template precondition, TemplateInstance impliedTemplate) {
        this.precondition = new TemplateInstance(null, null, precondition);
        this.precondition.setLocation(precondition.getLocation());
        this.implied_template = impliedTemplate;
        this.precondition.setFullNameParent(this);
        this.implied_template.setFullNameParent(this);
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.precondition != null && this.precondition.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs)) {
            return true;
        }
        return this.implied_template != null && this.implied_template.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.precondition != null) {
            this.precondition.checkRecursions(timestamp, referenceChain);
        }
        if (this.implied_template != null) {
            this.implied_template.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an implication match");
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        this.precondition.check(timestamp, type);
        this.implied_template.check(timestamp, type);
        this.checkLengthRestriction(timestamp, type);
        return false;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.precondition.createStringRepresentation()).append(" implies ").append(this.implied_template.createStringRepresentation());
        return builder.toString();
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        String preconditionId = aData.getTemporaryVariableName();
        String impliedTemplateId = aData.getTemporaryVariableName();
        String typeName = this.myGovernor.getGenNameTemplate(aData, source);
        ExpressionStruct preconditionExpression = new ExpressionStruct();
        this.precondition.generateCode(aData, preconditionExpression, TemplateRestriction.Restriction_type.TR_NONE);
        if (preconditionExpression.preamble.length() > 0) {
            source.append((CharSequence)preconditionExpression.preamble);
        }
        source.append(MessageFormat.format("final {0} {1} = new {2}({3});\n", typeName, preconditionId, typeName, preconditionExpression.expression));
        if (preconditionExpression.postamble.length() > 0) {
            source.append((CharSequence)preconditionExpression.postamble);
        }
        ExpressionStruct impliedExpression = new ExpressionStruct();
        this.implied_template.generateCode(aData, impliedExpression, TemplateRestriction.Restriction_type.TR_NONE);
        if (impliedExpression.preamble.length() > 0) {
            source.append((CharSequence)impliedExpression.preamble);
        }
        source.append(MessageFormat.format("final {0} {1} = new {2}({3});\n", typeName, impliedTemplateId, typeName, impliedExpression.expression));
        if (impliedExpression.postamble.length() > 0) {
            source.append((CharSequence)impliedExpression.postamble);
        }
        source.append(MessageFormat.format("{0} = new {1}({2}, {3});\n", name, typeName, preconditionId, impliedTemplateId));
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        IType type = this.precondition.getExpressionGovernor(timestamp, expectedValue);
        if (type != null) {
            return type;
        }
        return this.implied_template.getExpressionGovernor(timestamp, expectedValue);
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        IType.Type_type type = this.precondition.getExpressionReturntype(timestamp, expectedValue);
        if (!IType.Type_type.TYPE_UNDEFINED.equals((Object)type)) {
            return type;
        }
        return this.implied_template.getExpressionReturntype(timestamp, expectedValue);
    }

    public TemplateInstance getImpliedTemplate() {
        return this.implied_template;
    }

    public TemplateInstance getPrecondition() {
        return this.precondition;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.IMPLICATION_MATCH;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous implication match";
        }
        return "implication match";
    }

    @Override
    public boolean needsTemporaryReference() {
        return true;
    }

    @Override
    public boolean hasSingleExpression() {
        return false;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        this.precondition.setCodeSection(codeSection);
        this.implied_template.setCodeSection(codeSection);
    }

    @Override
    public void setMyDefinition(Definition definition) {
        this.precondition.getTemplateBody().setMyDefinition(definition);
        this.implied_template.getTemplateBody().setMyDefinition(definition);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.precondition.setMyScope(scope);
        this.implied_template.setMyScope(scope);
    }
}

