/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArguments;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Verdict_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Setverdict_Statement
extends Statement {
    private static final String OPERANDERROR = "The operand of the `setverdict' operation should be a verdict value";
    private static final String INCONTROLPART = "Setverdict statement is not allowed in the control part";
    private static final String ERRORCANNOTBESET = "Error verdict cannot be set by the setverdict operation";
    private static final String FULLNAMEPART1 = ".verdictvalue";
    private static final String FULLNAMEPART2 = ".verdictreason";
    private static final String STATEMENT_NAME = "setverdict";
    private final Value verdictValue;
    private final LogArguments verdictReason;

    public Setverdict_Statement(Value verdictValue, LogArguments verdictReason) {
        this.verdictValue = verdictValue;
        this.verdictReason = verdictReason;
        if (verdictValue != null) {
            verdictValue.setFullNameParent(this);
        }
        if (verdictReason != null) {
            this.verdictReason.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SETVERDICT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.verdictValue == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.verdictReason == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.verdictValue != null) {
            this.verdictValue.setMyScope(scope);
        }
        if (this.verdictReason != null) {
            this.verdictReason.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.verdictValue != null) {
            this.verdictValue.setCodeSection(codeSection);
        }
        if (this.verdictReason != null) {
            this.verdictReason.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.myStatementBlock.getMyDefinition() == null) {
            this.location.reportSemanticError(INCONTROLPART);
        }
        if (this.verdictValue != null) {
            this.verdictValue.setLoweridToReference(timestamp);
            IValue last = this.verdictValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temp = this.verdictValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temp) {
                case TYPE_VERDICT: {
                    if (!IValue.Value_type.VERDICT_VALUE.equals((Object)last.getValuetype()) || !Verdict_Value.Verdict_type.ERROR.equals((Object)((Verdict_Value)last).getValue())) break;
                    this.verdictValue.getLocation().reportSemanticError(ERRORCANNOTBESET);
                    break;
                }
                default: {
                    this.verdictValue.getLocation().reportSemanticError(OPERANDERROR);
                    this.verdictValue.setIsErroneous(true);
                }
            }
        }
        if (this.verdictReason != null) {
            this.verdictReason.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.verdictValue != null) {
            this.verdictValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.verdictValue.getLocation());
        }
        if (this.verdictReason != null) {
            this.verdictReason.updateSyntax(reparser, false);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.verdictValue != null) {
            this.verdictValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.verdictReason != null) {
            this.verdictReason.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.verdictValue != null && !this.verdictValue.accept(v)) {
            return false;
        }
        return this.verdictReason == null || this.verdictReason.accept(v);
    }

    public Value getVerdictValue() {
        return this.verdictValue;
    }

    public LogArguments getVerdictReason() {
        return this.verdictReason;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        aData.addCommonLibraryImport("TTCN_Runtime");
        expression.expression.append("\t\t\tTTCN_Runtime.setverdict(");
        this.verdictValue.generateCodeExpression(aData, expression, false);
        if (this.verdictReason != null) {
            expression.expression.append(", ");
            ExpressionStruct reason = new ExpressionStruct();
            this.verdictReason.generateCodeExpression(aData, reason);
            if (reason.preamble.length() > 0) {
                expression.preamble.append((CharSequence)reason.preamble);
            }
            if (reason.postamble.length() > 0) {
                expression.postamble.append((CharSequence)reason.postamble);
            }
            expression.expression.append((CharSequence)reason.expression);
            expression.expression.append(".get_value().toString()");
        }
        expression.expression.append(')');
        expression.mergeExpression(source);
    }
}

