/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.TableConstraint;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.UnionGenerator;
import org.eclipse.titan.designer.AST.TTCN3.values.Choice_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Open_Type
extends ASN1Type {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for union type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for union type `{0}''";
    private static final String ONEFIELDEXPECTED = "A template for union type must contain exactly one selected field";
    private static final String REFERENCETONONEXISTENTFIELD = "Reference to non-existent field `{0}'' in template of type `{1}''";
    private static final String CHOICEEXPECTED = "CHOICE value was expected for type `{0}''";
    private static final String UNIONEXPECTED = "Union value was expected for type `{0}''";
    private static final String NONEXISTENTCHOICE = "Reference to a non-existent alternative `{0}'' in CHOICE value for type `{1}''";
    private static final String NONEXISTENTUNION = "Reference to a non-existent field `{0}'' in union value for type `{1}''";
    private CompFieldMap compFieldMap = new CompFieldMap();
    private final ObjectClass_Definition objectClass;
    private final Identifier fieldName;
    private TableConstraint myTableConstraint;
    private boolean insideCanHaveCoding = false;

    public Open_Type(ObjectClass_Definition objectClass, Identifier identifier) {
        this.objectClass = objectClass;
        this.fieldName = identifier;
        this.compFieldMap.setMyType(this);
        this.compFieldMap.setFullNameParent(this);
        if (null != objectClass) {
            objectClass.setFullNameParent(this);
        }
        this.isErroneous = false;
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_OPENTYPE;
    }

    @Override
    public IASN1Type newInstance() {
        return new Open_Type(this.objectClass, this.fieldName);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_CHOICE;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.compFieldMap) {
            this.compFieldMap.setMyScope(scope);
        }
    }

    public ObjectClass_Definition getMyObjectClass() {
        return this.objectClass;
    }

    public Identifier getObjectClassFieldName() {
        return this.fieldName;
    }

    public void setMyTableConstraint(TableConstraint constraint) {
        this.myTableConstraint = constraint;
    }

    public void addComponent(CompField field) {
        if (null != field && null != this.compFieldMap) {
            this.compFieldMap.addComp(field);
            this.lastTimeChecked = null;
        }
    }

    public final int getNofComponents() {
        if (this.compFieldMap == null) {
            return 0;
        }
        return this.compFieldMap.getNofComponents();
    }

    public final CompField getComponentByIndex(int index) {
        return this.compFieldMap.getComponentByIndex(index);
    }

    public boolean hasComponentWithName(Identifier identifier) {
        return null != this.getComponentByName(identifier);
    }

    public CompField getComponentByName(Identifier identifier) {
        String name = identifier.getName();
        name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (null != this.compFieldMap) {
            return this.compFieldMap.getCompWithName(name);
        }
        return null;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == otherType;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public String getTypename() {
        return "open type";
    }

    @Override
    public String getFullName() {
        if (null == this.getNameParent()) {
            return this.getTypename();
        }
        return super.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "asn1_opentype.gif";
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        Map<String, CompField> map = this.compFieldMap.getComponentFieldMap(timestamp);
        if (referenceChain.add(this) && 1 == map.size()) {
            for (CompField compField : map.values()) {
                Type type = compField.getType();
                if (null == type) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    public void clear() {
        this.lastTimeChecked = null;
        this.compFieldMap = new CompFieldMap();
        this.compFieldMap.setMyType(this);
        this.compFieldMap.setFullNameParent(this);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.compFieldMap.check(timestamp);
        if (this.compFieldMap.isEmpty()) {
            return;
        }
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        this.check(timestamp);
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.CHOICE_VALUE)).getIsErroneous(timestamp)) break;
                selfReference = this.checkThisValueChoice(timestamp, (Choice_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            case CHOICE_VALUE: {
                selfReference = this.checkThisValueChoice(timestamp, (Choice_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                } else {
                    value.getLocation().reportSemanticError(MessageFormat.format(UNIONEXPECTED, this.getFullName()));
                }
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueChoice(CompilationTimeStamp timestamp, Choice_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean strElem) {
        boolean selfReference = false;
        Identifier name = value.getName();
        CompField field = this.getComponentByName(name);
        if (field == null) {
            if (value.isAsn()) {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTCHOICE, name.getDisplayName(), this.getFullName()));
            } else {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTUNION, name.getDisplayName(), this.getFullName()));
            }
        } else {
            IValue alternativeValue = value.getValue();
            if (null == alternativeValue) {
                return selfReference;
            }
            Type alternativeType = field.getType();
            alternativeValue.setMyGovernor(alternativeType);
            alternativeValue = alternativeType.checkThisValueRef(timestamp, alternativeValue);
            selfReference = alternativeType.checkThisValue(timestamp, alternativeValue, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, false, strElem));
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = false;
        if (ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)template.getTemplatetype())) {
            Named_Template_List namedTemplateList = (Named_Template_List)template;
            int nofTemplates = namedTemplateList.getNofTemplates();
            if (nofTemplates != 1) {
                template.getLocation().reportSemanticError(ONEFIELDEXPECTED);
            }
            for (int i = 0; i < nofTemplates; ++i) {
                NamedTemplate namedTemplate = namedTemplateList.getTemplateByIndex(i);
                Identifier name = namedTemplate.getName();
                CompField field = this.getComponentByName(name);
                if (field == null) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(REFERENCETONONEXISTENTFIELD, name.getDisplayName(), this.getFullName()));
                    continue;
                }
                Type fieldType = field.getType();
                if (fieldType == null || fieldType.getIsErroneous(timestamp)) continue;
                ITTCN3Template namedTemplateTemplate = namedTemplate.getTemplate();
                namedTemplateTemplate.setMyGovernor(fieldType);
                namedTemplateTemplate = fieldType.checkThisTemplateRef(timestamp, namedTemplateTemplate);
                ITTCN3Template.Completeness_type completeness = namedTemplateList.getCompletenessConditionChoice(timestamp, isModified, name);
                selfReference |= namedTemplateTemplate.checkThisTemplateGeneric(timestamp, fieldType, ITTCN3Template.Completeness_type.MAY_INCOMPLETE.equals((Object)completeness), false, false, true, implicitOmit, lhs);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
        return selfReference;
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cf = this.getComponentByIndex(i);
            cf.getType().checkCodingAttributes(timestamp, refChain);
        }
        refChain.previousState();
    }

    @Override
    public void getTypesWithNoCodingTable(CompilationTimeStamp timestamp, ArrayList<IType> typeList, boolean onlyOwnTable) {
        if (typeList.contains(this)) {
            return;
        }
        if (onlyOwnTable && this.codingTable.isEmpty() || !onlyOwnTable && this.getTypeWithCodingTable(timestamp, false) == null) {
            typeList.add(this);
        }
        Map<String, CompField> map = this.compFieldMap.getComponentFieldMap(CompilationTimeStamp.getBaseTimestamp());
        for (CompField compField : map.values()) {
            compField.getType().getTypesWithNoCodingTable(timestamp, typeList, onlyOwnTable);
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                this.check(timestamp);
                Identifier id = subreference.getId();
                CompField compField = this.getComponentByName(id);
                if (compField == null) {
                    if (this.compFieldMap.getComponentFieldMap(timestamp).isEmpty()) {
                        return null;
                    }
                    reference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", id.getDisplayName(), this.getFullName()));
                    reference.setIsErroneous(true);
                    return this;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            type.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("open type");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.getComponentByName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(compField.getOutlineIcon()), proposalKind);
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.getComponentByName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.compFieldMap == null) {
            return;
        }
        this.compFieldMap.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.compFieldMap != null) {
            this.compFieldMap.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.objectClass != null) {
            this.objectClass.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.compFieldMap != null && !this.compFieldMap.accept(v)) {
            return false;
        }
        if (this.objectClass != null && !this.objectClass.accept(v)) {
            return false;
        }
        if (this.fieldName != null && !this.fieldName.accept(v)) {
            return false;
        }
        return this.myTableConstraint == null || this.myTableConstraint.accept(v);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameValue(aData, source).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (this.insideCanHaveCoding) {
            return true;
        }
        this.insideCanHaveCoding = true;
        if (coding == IType.MessageEncoding_type.BER) {
            boolean result = this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
            this.insideCanHaveCoding = false;
            return result;
        }
        Map<String, CompField> map = this.compFieldMap.getComponentFieldMap(CompilationTimeStamp.getBaseTimestamp());
        for (CompField compField : map.values()) {
            if (compField.getType().getTypeRefdLast(timestamp).canHaveCoding(timestamp, coding)) continue;
            this.insideCanHaveCoding = false;
            return false;
        }
        this.insideCanHaveCoding = false;
        return true;
    }

    @Override
    public void setGenerateCoderFunctions(CompilationTimeStamp timestamp, IType.MessageEncoding_type encodingType) {
        switch (encodingType) {
            case RAW: 
            case JSON: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.getGenerateCoderFunctions(encodingType)) {
            return;
        }
        this.codersToGenerate.add(encodingType);
        Map<String, CompField> map = this.compFieldMap.getComponentFieldMap(CompilationTimeStamp.getBaseTimestamp());
        for (CompField compField : map.values()) {
            compField.getType().getTypeRefdLast(timestamp).setGenerateCoderFunctions(timestamp, encodingType);
        }
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ObjectSet objectSet;
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String genName = this.getGenNameOwn();
        String displayName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, null);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        ArrayList<UnionGenerator.FieldInfo> fieldInfos = new ArrayList<UnionGenerator.FieldInfo>();
        boolean hasOptional = false;
        Map<String, CompField> map = this.compFieldMap.getComponentFieldMap(CompilationTimeStamp.getBaseTimestamp());
        for (CompField compField : map.values()) {
            Type cfType = compField.getType();
            String jsonAlias = cfType.getJsonAttribute() != null ? cfType.getJsonAttribute().alias : null;
            int JsonValueType = hasJson ? cfType.getJsonValueType() : 0;
            UnionGenerator.FieldInfo fi = new UnionGenerator.FieldInfo(cfType.getGenNameValue(aData, source), cfType.getGenNameTemplate(aData, source), compField.getIdentifier().getName(), compField.getIdentifier().getDisplayName(), cfType.getGenNameTypeDescriptor(aData, source), jsonAlias, JsonValueType);
            hasOptional |= compField.isOptional();
            fieldInfos.add(fi);
        }
        if (this.myTableConstraint != null && (objectSet = this.myTableConstraint.getObjectSet()).getMyScope().getModuleScopeGen() == this.myScope.getModuleScopeGen()) {
            objectSet.generateCode(aData);
        }
        boolean jsonAsValue = this.jsonAttribute != null ? this.jsonAttribute.as_value : false;
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        UnionGenerator.generateValueClass(aData, source, genName, displayName, fieldInfos, hasOptional, hasRaw, null, hasJson, false, jsonAsValue, localTypeDescriptor, localCodingHandler);
        UnionGenerator.generateTemplateClass(aData, source, genName, displayName, fieldInfos, hasOptional);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        return beginIndex >= subreferences.size();
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        String valueTypeGenName = this.getGenNameValue(aData, expression.expression);
        String currentTypeGenName = isTemplate ? this.getGenNameTemplate(aData, expression.expression) : valueTypeGenName;
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2}.union_selection_type.ALT_{3});\n", globalId, externalId, valueTypeGenName, FieldSubReference.getJavaGetterName(fieldId.getName())));
        expression.expression.append("}\n");
        CompField compField = this.getComponentByName(fieldId);
        Type nextType = compField.getType();
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        closingBrackets.insert(0, "}\n");
        String temporalId = aData.getTemporaryVariableName();
        String temporalId2 = aData.getTemporaryVariableName();
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        expression.expression.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", currentTypeGenName, temporalId, externalId));
        expression.expression.append(MessageFormat.format("final {0} {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId2, temporalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
        if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
        } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
        } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_present({2});\n", globalId, temporalId2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
        } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                expression.expression.append("}\n");
            }
        }
        nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
        expression.expression.append((CharSequence)closingBrackets);
    }
}

