/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ComponentTypeList;
import org.eclipse.titan.designer.AST.ASN1.types.ExceptionSpecification;
import org.eclipse.titan.designer.AST.ASN1.types.ExtensionAndException;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class CTs_EE_CTs
extends ASTNode {
    public static final String DUPLICATECOMPONENTFIRST = "{0} `{1}'' was first defined here";
    public static final String DUPLICATECOMPONENTREPEATED = "Duplicate {0} identifier in {1}: `{2}'' was declared here again";
    private final ComponentTypeList componentTypeList1;
    private final ExtensionAndException extensionAndException;
    private final ComponentTypeList componentTypeList2;
    private ASN1Type myType;
    private CompilationTimeStamp lastTimeChecked;
    private ArrayList<CompField> components = new ArrayList();
    private HashMap<String, CompField> componentsMap = new HashMap();

    public CTs_EE_CTs(ComponentTypeList componentTypeList1, ExtensionAndException extensionAndException, ComponentTypeList componentTypeList2) {
        this.componentTypeList1 = null != componentTypeList1 ? componentTypeList1 : new ComponentTypeList();
        this.extensionAndException = extensionAndException;
        this.componentTypeList2 = null != componentTypeList2 ? componentTypeList2 : new ComponentTypeList();
        this.componentTypeList1.setFullNameParent(this);
        if (null != extensionAndException) {
            extensionAndException.setFullNameParent(this);
        }
        this.componentTypeList2.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.componentTypeList1.setMyScope(scope);
        if (null != this.extensionAndException) {
            this.extensionAndException.setMyScope(scope);
        }
        this.componentTypeList2.setMyScope(scope);
    }

    public void setMyType(ASN1Type type) {
        this.myType = type;
    }

    public int getNofComps() {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.components.size();
    }

    public int getNofRootComps() {
        return this.componentTypeList1.getNofComps() + this.componentTypeList2.getNofComps();
    }

    public CompField getCompByIndex(int index) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.components.get(index);
    }

    public CompField getRootCompByIndex(int index) {
        int cts1Size = this.componentTypeList1.getNofComps();
        if (index < cts1Size) {
            return this.componentTypeList1.getCompByIndex(index);
        }
        return this.componentTypeList2.getCompByIndex(index - cts1Size);
    }

    public boolean hasCompWithName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.componentsMap.containsKey(identifier.getName());
    }

    public CompField getCompByName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.componentsMap.get(identifier.getName());
    }

    public int indexOf(CompField field) {
        return this.components.indexOf(field);
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain, boolean inEllipsis) {
        boolean isSet = IType.Type_type.TYPE_ASN1_SET.equals((Object)this.myType.getTypetype());
        if (inEllipsis) {
            if (null != this.extensionAndException) {
                this.extensionAndException.trCompsof(timestamp, referenceChain, isSet);
            }
        } else {
            this.componentTypeList1.trCompsof(timestamp, referenceChain, isSet);
            this.componentTypeList2.trCompsof(timestamp, referenceChain, isSet);
        }
    }

    public boolean hasEllipsis() {
        return null != this.extensionAndException;
    }

    public void check(CompilationTimeStamp timestamp) {
        CompField componentField;
        int i;
        String componentName;
        String typeName;
        Module module;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (null != this.myScope && null != this.lastTimeChecked && null != (module = this.myScope.getModuleScope()) && module.getSkippedFromSemanticChecking()) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if (null == this.myType) {
            return;
        }
        this.lastTimeChecked = timestamp;
        ArrayList<CompField> newComponents = new ArrayList<CompField>();
        HashMap<String, CompField> newComponentsMap = new HashMap<String, CompField>();
        switch (this.myType.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                typeName = "SEQUENCE";
                componentName = "Component";
                break;
            }
            case TYPE_ASN1_SET: {
                typeName = "SET";
                componentName = "Component";
                break;
            }
            case TYPE_ASN1_CHOICE: {
                typeName = "CHOICE";
                componentName = "Alternative";
                break;
            }
            default: {
                typeName = "<unknown>";
                componentName = "component";
            }
        }
        for (i = 0; i < this.componentTypeList1.getNofComps(); ++i) {
            componentField = this.componentTypeList1.getCompByIndex(i);
            this.checkComponentField(newComponents, newComponentsMap, componentField, typeName, componentName);
        }
        if (null != this.extensionAndException) {
            for (i = 0; i < this.extensionAndException.getNofComps(); ++i) {
                componentField = this.extensionAndException.getCompByIndex(i);
                this.checkComponentField(newComponents, newComponentsMap, componentField, typeName, componentName);
            }
            ExceptionSpecification es = this.extensionAndException.getExceptionSpecification();
            if (es != null) {
                es.getType().check(timestamp);
            }
        }
        for (i = 0; i < this.componentTypeList2.getNofComps(); ++i) {
            componentField = this.componentTypeList2.getCompByIndex(i);
            this.checkComponentField(newComponents, newComponentsMap, componentField, typeName, componentName);
        }
        newComponents.trimToSize();
        this.components = newComponents;
        this.componentsMap = newComponentsMap;
        for (CompField componentField2 : this.components) {
            Type type = componentField2.getType();
            type.setGenName(this.myType.getGenNameOwn(), componentField2.getIdentifier().getName());
            type.setParentType(this.myType);
            componentField2.check(timestamp);
            if (!componentField2.hasDefault()) continue;
            Value defaultValue = componentField2.getDefault();
            defaultValue.setMyGovernor(type);
            IType lastType = type.getTypeRefdLast(timestamp);
            IValue tempValue = lastType.checkThisValueRef(timestamp, defaultValue);
            lastType.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, false, false));
            defaultValue.setGenNameRecursive(type.getGenNameOwn() + "_defval_");
            defaultValue.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
        }
    }

    private void checkComponentField(ArrayList<CompField> newComponents, HashMap<String, CompField> newComponentMap, CompField componentField, String typeName, String componentName) {
        Identifier identifier = componentField.getIdentifier();
        String name = identifier.getName();
        if (newComponentMap.containsKey(name)) {
            Location tempLocation = newComponentMap.get(name).getIdentifier().getLocation();
            tempLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATECOMPONENTFIRST, componentName, identifier.getDisplayName()));
            identifier.getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATECOMPONENTREPEATED, componentName, typeName, identifier.getDisplayName()));
        } else {
            newComponentMap.put(name, componentField);
            newComponents.add(componentField);
            if (!identifier.getHasValid(Identifier.Identifier_type.ID_TTCN)) {
                identifier.getLocation().reportSingularSemanticWarning(MessageFormat.format("The identifier `{0}'' is not reachable from TTCN-3", identifier.getDisplayName()));
            }
        }
    }

    public List<CompField> getComponentsWithPrefix(String prefix) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        ArrayList<CompField> compFields = new ArrayList<CompField>();
        for (int i = 0; i < this.components.size(); ++i) {
            if (!this.components.get(i).getIdentifier().getName().startsWith(prefix)) continue;
            compFields.add(this.components.get(i));
        }
        return compFields;
    }

    public Object[] getOutlineChildren() {
        int i;
        int size;
        ArrayList<CompField> result = new ArrayList<CompField>();
        if (null != this.componentTypeList1) {
            size = this.componentTypeList1.getNofComps();
            for (i = 0; i < size; ++i) {
                result.add(this.componentTypeList1.getCompByIndex(i));
            }
        }
        if (null != this.componentTypeList2) {
            size = this.componentTypeList2.getNofComps();
            for (i = 0; i < size; ++i) {
                result.add(this.componentTypeList2.getCompByIndex(i));
            }
        }
        return result.toArray();
    }

    public void getEnclosingField(int offset, ReferenceFinder rf) {
        for (CompField field : this.components) {
            if (!field.getLocation().containsOffset(offset) && !field.getIdentifier().getLocation().containsOffset(offset)) continue;
            rf.type = this.myType;
            rf.fieldId = field.getIdentifier();
            field.getType().getEnclosingField(offset, rf);
            return;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.componentTypeList1 != null) {
            this.componentTypeList1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.extensionAndException != null) {
            this.extensionAndException.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentTypeList2 != null) {
            this.componentTypeList2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentTypeList1 != null && !this.componentTypeList1.accept(v)) {
            return false;
        }
        if (this.extensionAndException != null && !this.extensionAndException.accept(v)) {
            return false;
        }
        return this.componentTypeList2 == null || this.componentTypeList2.accept(v);
    }
}

