/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.AST.ASN1.definitions.ImportModule;
import org.eclipse.titan.designer.AST.ASN1.definitions.Symbols;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;

public final class Imports
extends ASTNode
implements IOutlineElement,
ILocateableNode {
    private static final String DUPLICATEIMPORTFIRST = "Duplicate import from module `{0}'' was first declared here";
    private static final String DUPLICATEIMPORTREPEATED = "Duplicate import from module `{0}'' was declared here again";
    private static final String TTCN3IMPORT = "An ASN.1 module cannot import from a TTCN-3 module";
    private static final String SELFIMPORT = "A module cannot import from itself";
    private ASN1Module module;
    private final List<ImportModule> importedModules_v = new ArrayList<ImportModule>();
    private final Map<String, ImportModule> importedModules_map = new HashMap<String, ImportModule>();
    protected final Map<String, Module> singularImportedSymbols_map = new HashMap<String, Module>();
    protected final Set<String> pluralImportedSymbols = new HashSet<String>();
    private CompilationTimeStamp lastImportCheckTimeStamp;
    private IProject project;
    private Location location = NULL_Location.INSTANCE;

    public void addImportModule(ImportModule importedModule) {
        if (null != importedModule && null != importedModule.getIdentifier() && null != importedModule.getIdentifier().getName()) {
            importedModule.setProject(this.project);
            this.importedModules_v.add(importedModule);
        }
    }

    public void setProject(IProject project) {
        this.project = project;
        for (ImportModule temp : this.importedModules_v) {
            temp.setProject(project);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setMyModule(ASN1Module module) {
        this.module = module;
    }

    @Override
    public Identifier getIdentifier() {
        return new Identifier(Identifier.Identifier_type.ID_ASN, "imports", this.location, true);
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public String getOutlineIcon() {
        return "imports.gif";
    }

    @Override
    public Object[] getOutlineChildren() {
        return this.importedModules_v.toArray();
    }

    @Override
    public int category() {
        return 0;
    }

    public void checkImports(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, List<Module> moduleStack) {
        if (null != this.lastImportCheckTimeStamp && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastImportCheckTimeStamp = timestamp;
        if (null == this.project) {
            return;
        }
        this.importedModules_map.clear();
        this.singularImportedSymbols_map.clear();
        this.pluralImportedSymbols.clear();
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(this.project);
        if (null == parser) {
            return;
        }
        for (ImportModule importModule : this.importedModules_v) {
            Identifier identifier = importModule.getIdentifier();
            if (null == identifier || null == identifier.getLocation()) continue;
            Module referredModule = parser.getModuleByName(identifier.getName());
            if (null == referredModule) {
                identifier.getLocation().reportSemanticError(MessageFormat.format("There is no ASN.1 module with name `{0}''", identifier.getDisplayName()));
                continue;
            }
            if (!(referredModule instanceof ASN1Module)) {
                identifier.getLocation().reportSemanticError(TTCN3IMPORT);
                continue;
            }
            if (referredModule == this.module) {
                identifier.getLocation().reportSemanticError(SELFIMPORT);
                continue;
            }
            String name = identifier.getName();
            if (this.importedModules_map.containsKey(name)) {
                Location importedLocation = this.importedModules_map.get(name).getIdentifier().getLocation();
                importedLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATEIMPORTFIRST, identifier.getDisplayName()));
                identifier.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEIMPORTREPEATED, identifier.getDisplayName()));
            } else {
                this.importedModules_map.put(name, importModule);
            }
            Symbols symbols = importModule.getSymbols();
            if (null == symbols) continue;
            for (int i = 0; i < symbols.size(); ++i) {
                name = symbols.getNthElement(i).getName();
                if (this.singularImportedSymbols_map.containsKey(name)) {
                    if (referredModule.equals(this.singularImportedSymbols_map.get(name))) continue;
                    this.singularImportedSymbols_map.remove(name);
                    this.pluralImportedSymbols.add(name);
                    continue;
                }
                if (this.pluralImportedSymbols.contains(name)) continue;
                this.singularImportedSymbols_map.put(name, referredModule);
            }
            importModule.setUnhandledChange(false);
            LoadBalancingUtilities.astNodeChecked();
        }
        for (ImportModule importModule : this.importedModules_v) {
            referenceChain.markState();
            importModule.checkImports(timestamp, referenceChain, moduleStack);
            referenceChain.previousState();
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        for (ImportModule importModule : this.importedModules_v) {
            importModule.check(timestamp);
        }
    }

    public List<Module> getImportedModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        for (ImportModule impmod : this.importedModules_v) {
            Module module = impmod.getReferredModule();
            if (module == null) continue;
            result.add(module);
        }
        return result;
    }

    public boolean hasUnhandledImportChanges() {
        for (ImportModule impmod : this.importedModules_v) {
            if (!impmod.hasUnhandledChange()) continue;
            return true;
        }
        return false;
    }

    public boolean hasImportedModuleWithId(Identifier id) {
        String name = id.getName();
        return this.importedModules_map.containsKey(name);
    }

    public ImportModule getImportedModuleById(Identifier id) {
        String name = id.getName();
        if (this.importedModules_map.containsKey(name)) {
            return this.importedModules_map.get(name);
        }
        return null;
    }

    public boolean hasImportedSymbolWithId(Identifier identifier) {
        return this.singularImportedSymbols_map.containsKey(identifier.getName()) || this.pluralImportedSymbols.contains(identifier.getName());
    }

    public void addProposal(ProposalCollector propCollector) {
        for (ImportModule importation : this.importedModules_map.values()) {
            importation.addProposal(propCollector, this.module.getIdentifier());
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector) {
        Reference reference = declarationCollector.getReference();
        Identifier identifier = reference.getId();
        if (this.singularImportedSymbols_map.containsKey(identifier.getName())) {
            Module tempModule = this.singularImportedSymbols_map.get(identifier.getName());
            tempModule.getAssignmentsScope().addDeclaration(declarationCollector);
        }
        if (!declarationCollector.getCollected().isEmpty()) {
            return;
        }
        for (ImportModule importation : this.importedModules_map.values()) {
            importation.addDeclaration(declarationCollector, this.module.getIdentifier());
        }
    }

    public void extractStructuralInformation(Identifier from, ProjectStructureDataCollector collector) {
        for (ImportModule imported : this.importedModules_v) {
            collector.addImportation(from, imported.getIdentifier());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.importedModules_v != null) {
            for (ImportModule im : this.importedModules_v) {
                if (im.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void generateCode(JavaGenData aData) {
    }
}

