/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.eclipse.titan.log.viewer.console.TITANDebugConsole;
import org.eclipse.titan.log.viewer.parsers.Constants;
import org.eclipse.titan.log.viewer.parsers.Tokens;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.parsers.token.ComponentReference;
import org.eclipse.titan.log.viewer.parsers.token.EventType;
import org.eclipse.titan.log.viewer.parsers.token.Message;
import org.eclipse.titan.log.viewer.parsers.token.SourceInfo;
import org.eclipse.titan.log.viewer.parsers.token.TimeStamp;
import org.eclipse.titan.log.viewer.parsers.token.Token;
import org.eclipse.titan.log.viewer.parsers.token.WhiteSpace;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.console.MessageConsoleStream;

public class RecordParser {
    private int bufPointer;
    private int startPointer;
    private List<Token> tokenBuffer;
    private byte[] buffer = null;
    private static final String UNDERSCORE = "_";

    public LogRecord parse(byte[] record) throws ParseException {
        this.buffer = record;
        this.bufPointer = 0;
        return this.parse();
    }

    public LogRecord parse(String record) throws ParseException {
        this.buffer = record.getBytes();
        this.bufPointer = 0;
        return this.parse();
    }

    private LogRecord parse() throws ParseException {
        if (this.buffer == null || this.buffer.length == 0) {
            throw new ParseException(Messages.getString("RecordParser.0"), this.bufPointer);
        }
        this.initialize();
        TimeStamp ts = this.readTimestamp();
        this.processToken(ts);
        return this.extractVector();
    }

    private LogRecord extractVector() {
        LogRecord thisLogRecord = new LogRecord();
        for (Token thisToken : this.tokenBuffer) {
            switch (thisToken.getType()) {
                case 128: {
                    thisLogRecord.setTimestamp(thisToken.getContent());
                    break;
                }
                case 4: {
                    thisLogRecord.setComponentReference(thisToken.getContent().toLowerCase());
                    break;
                }
                case 16: {
                    thisLogRecord.setEventType(thisToken.getContent());
                    break;
                }
                case 8: {
                    thisLogRecord.setSourceInformation(thisToken.getContent());
                    break;
                }
                case 64: {
                    thisLogRecord.setMessage(thisToken.getContent());
                    break;
                }
            }
        }
        return thisLogRecord;
    }

    private void initialize() {
        this.startPointer = 0;
        this.tokenBuffer = new ArrayList<Token>();
    }

    private void processToken(Token thisToken) throws ParseException {
        this.addToken(thisToken);
        Token token = this.readDelimiterToken(thisToken.getDelimiterList());
        this.addToken(token);
        if (token == Tokens.EOR) {
            return;
        }
        token = this.readNextToken(thisToken.getTokenList());
        this.processToken(token);
    }

    private void addToken(Token thisToken) {
        this.tokenBuffer.add(thisToken);
    }

    private Token readDelimiterToken(int expectedTokenMask) throws ParseException {
        if ((expectedTokenMask & 2) == 2 && this.bufPointer == this.buffer.length) {
            return Tokens.EOR;
        }
        if ((expectedTokenMask & 1) == 1) {
            return this.readWhitespace();
        }
        throw new ParseException(Messages.getString("RecordParser.1"), expectedTokenMask);
    }

    private Token readNextToken(int expectedTokenMask) throws ParseException {
        String token;
        String lookAheadToken = this.peek();
        if ((expectedTokenMask & 4) == 4 && this.isComponentRef(lookAheadToken)) {
            int storedStartPointer = this.startPointer;
            int storedBufPointer = this.bufPointer;
            String token2 = this.read();
            String nextWord = this.peekNextWord();
            if (nextWord.length() < 1) {
                this.startPointer = storedStartPointer;
                this.bufPointer = storedBufPointer;
            } else {
                return new ComponentReference(token2);
            }
        }
        if ((expectedTokenMask & 0x10) == 16 && this.isEventType(lookAheadToken)) {
            String token3 = this.read();
            return new EventType(token3);
        }
        if ((expectedTokenMask & 8) == 8 && this.isSourceInfo(lookAheadToken)) {
            String token4 = this.read();
            return new SourceInfo(token4);
        }
        if ((expectedTokenMask & 0x40) == 64 && (token = this.readUntilEOR()) != null && token.length() != 0) {
            return new Message(token);
        }
        throw new ParseException(Messages.getString("RecordParser.2") + lookAheadToken, expectedTokenMask);
    }

    private String readUntilEOR() {
        this.startPointer = this.bufPointer;
        while (this.bufPointer < this.buffer.length) {
            ++this.bufPointer;
        }
        return new String(this.buffer, this.startPointer, this.bufPointer - this.startPointer);
    }

    private String peek() {
        char thisChar;
        int localBufPointer;
        int localStartPointer = localBufPointer = this.bufPointer;
        while (localBufPointer < this.buffer.length && !this.isWhitespaceCharacter(thisChar = (char)this.buffer[localBufPointer])) {
            ++localBufPointer;
        }
        return new String(this.buffer, localStartPointer, localBufPointer - localStartPointer);
    }

    private String read() {
        char thisChar;
        this.startPointer = this.bufPointer;
        while (this.bufPointer < this.buffer.length && !this.isWhitespaceCharacter(thisChar = (char)this.buffer[this.bufPointer])) {
            ++this.bufPointer;
        }
        return new String(this.buffer, this.startPointer, this.bufPointer - this.startPointer);
    }

    private String peekNextWord() {
        char thisChar;
        int localBufPointer;
        int localStartPointer = localBufPointer = this.bufPointer;
        while (localBufPointer < this.buffer.length && this.isWhitespaceCharacter(thisChar = (char)this.buffer[localBufPointer])) {
            ++localBufPointer;
        }
        localStartPointer = localBufPointer;
        while (localBufPointer < this.buffer.length && !this.isWhitespaceCharacter(thisChar = (char)this.buffer[localBufPointer])) {
            ++localBufPointer;
        }
        return new String(this.buffer, localStartPointer, localBufPointer - localStartPointer);
    }

    private TimeStamp readTimestamp() throws ParseException {
        if (this.buffer.length == 0) {
            throw new ParseException(Messages.getString("RecordParser.3"), this.bufPointer);
        }
        this.startPointer = this.bufPointer;
        this.readNumeric();
        switch (this.getCurrentChar()) {
            case ':': {
                this.moveBufPointer(13);
                break;
            }
            case '/': {
                this.moveBufPointer(23);
                break;
            }
            case '.': {
                this.moveBufPointer(7);
                break;
            }
            default: {
                MessageConsoleStream stream = TITANDebugConsole.getConsole().newMessageStream();
                stream.println("actual buffer: " + new String(this.buffer));
                stream.println("actual buffer location: " + this.bufPointer);
                stream.println("actual byte: " + this.buffer[this.bufPointer] + ", as char: " + (char)this.buffer[this.bufPointer]);
                stream.println("the name of your charset: " + Charset.defaultCharset().name());
                throw new ParseException(Messages.getString("RecordParser.4"), this.bufPointer);
            }
        }
        return new TimeStamp(new String(this.buffer, this.startPointer, this.bufPointer - this.startPointer));
    }

    private void moveBufPointer(int counter) throws ParseException {
        int tempCounter = counter;
        while (tempCounter != 0 && this.bufPointer < this.buffer.length) {
            --tempCounter;
            ++this.bufPointer;
        }
        if (tempCounter != 0) {
            throw new ParseException(Messages.getString("RecordParser.5"), this.bufPointer);
        }
    }

    private char getCurrentChar() {
        return (char)this.buffer[this.bufPointer];
    }

    private void readNumeric() {
        char thisChar;
        while (this.bufPointer < this.buffer.length && this.isDigit(thisChar = (char)this.buffer[this.bufPointer])) {
            ++this.bufPointer;
        }
    }

    private boolean isDigit(char aChar) {
        return aChar >= '0' && aChar <= '9';
    }

    private boolean isWhitespaceCharacter(char aChar) {
        for (int i = 0; i < Constants.WS.length; ++i) {
            if (aChar != Constants.WS[i]) continue;
            return true;
        }
        return false;
    }

    private Token readWhitespace() throws ParseException {
        char thisChar;
        int isWhiteSpaceCounter = 0;
        this.startPointer = this.bufPointer;
        while (this.bufPointer < this.buffer.length && this.isWhitespaceCharacter(thisChar = (char)this.buffer[this.bufPointer])) {
            ++isWhiteSpaceCounter;
            ++this.bufPointer;
        }
        if (isWhiteSpaceCounter != 0) {
            return new WhiteSpace(new String(this.buffer, this.startPointer, this.bufPointer - this.startPointer));
        }
        throw new ParseException(Messages.getString("RecordParser.6"), isWhiteSpaceCounter);
    }

    private boolean isComponentRef(String token) {
        char tkn;
        if (token.length() == 1 && (tkn = token.charAt(0)) >= '0' && tkn <= '9') {
            return true;
        }
        for (int i = 0; i < Constants.COMPONENT_REFERENCES.length; ++i) {
            if (!token.equalsIgnoreCase(Constants.COMPONENT_REFERENCES[i])) continue;
            return true;
        }
        char char1 = token.charAt(0);
        if (char1 < '1' || char1 > '9') {
            return false;
        }
        for (int i = 1; i < token.length(); ++i) {
            char char2 = token.charAt(i);
            if (char2 >= '0' && char2 <= '9') continue;
            return false;
        }
        return true;
    }

    private boolean isSourceInfo(String token) {
        if (token.length() == 1 && token.charAt(0) == '-') {
            return true;
        }
        return token.contains(".ttcn") || token.contains(".3mp");
    }

    private boolean isEventType(String token) {
        SortedMap<String, String[]> eventCategories = org.eclipse.titan.log.viewer.utils.Constants.EVENT_CATEGORIES;
        if (token.contains(UNDERSCORE)) {
            String cat = token.split(UNDERSCORE)[0];
            String subCat = token.split(UNDERSCORE)[1];
            if (eventCategories.keySet().contains(cat)) {
                String[] subCategories;
                for (String subCategory : subCategories = (String[])eventCategories.get(cat)) {
                    if (!subCategory.equals(subCat)) continue;
                    return true;
                }
            }
        } else if (eventCategories.keySet().contains(token)) {
            return true;
        }
        return false;
    }
}

