/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.IDecode_Match;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanHexString;
import org.eclipse.titan.runtime.core.TitanHexString_Element;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanString_Utils;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanHexString_template
extends Restricted_Length_Template {
    private static final char[] patterns = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '?', '*'};
    private TitanHexString single_value;
    private ArrayList<TitanHexString_template> value_list;
    private byte[] pattern_value;
    private IDecode_Match dec_match;

    public TitanHexString_template() {
    }

    public TitanHexString_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanHexString_template.check_single_selection(otherValue);
    }

    public TitanHexString_template(TitanHexString otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound hexstring value.");
        this.single_value = new TitanHexString(otherValue);
    }

    public TitanHexString_template(Optional<TitanHexString> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanHexString(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a hexstring template from an unbound optional field.");
            }
        }
    }

    public TitanHexString_template(TitanHexString_template otherValue) {
        this.copy_template(otherValue);
    }

    public TitanHexString_template(TitanHexString_Element otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanHexString(otherValue);
    }

    public TitanHexString_template(byte[] pattern_elements) {
        super(Base_Template.template_sel.STRING_PATTERN);
        this.pattern_value = TitanString_Utils.copy_byte_list(pattern_elements);
    }

    public TitanHexString_template(String patternString) {
        super(Base_Template.template_sel.STRING_PATTERN);
        this.pattern_value = TitanHexString_template.pattern_string_2_list(patternString);
    }

    private static byte[] pattern_string_2_list(String patternString) {
        if (patternString == null) {
            throw new TtcnError("Internal error: hexstring pattern is null.");
        }
        byte[] result = new byte[patternString.length()];
        for (int i = 0; i < patternString.length(); ++i) {
            char patternChar = patternString.charAt(i);
            result[i] = TitanHexString_template.pattern_char_2_byte(patternChar);
        }
        return result;
    }

    private static byte pattern_char_2_byte(char patternChar) {
        if ('0' <= patternChar && '9' >= patternChar) {
            return (byte)(patternChar - 48);
        }
        if ('A' <= patternChar && 'F' >= patternChar) {
            return (byte)(patternChar - 65 + 10);
        }
        if ('a' <= patternChar && 'f' >= patternChar) {
            return (byte)(patternChar - 97 + 10);
        }
        if ('?' == patternChar) {
            return 16;
        }
        if ('*' == patternChar) {
            return 17;
        }
        throw new TtcnError("Internal error: invalid element in hexstring pattern.");
    }

    private static String pattern_list_2_string(byte[] list) {
        if (list == null) {
            throw new TtcnError("Internal error: hexstring pattern list is null.");
        }
        StringBuilder result = new StringBuilder(list.length);
        for (int i = 0; i < list.length; ++i) {
            result.append(patterns[list[i]]);
        }
        return result.toString();
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value = null;
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanHexString_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanHexString) {
            return this.operator_assign((TitanHexString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to hexstring", otherValue));
    }

    @Override
    public TitanHexString_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanHexString_template) {
            return this.operator_assign((TitanHexString_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to hexstring", otherValue));
    }

    @Override
    public TitanHexString_template operator_assign(Base_Template.template_sel otherValue) {
        TitanHexString_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanHexString_template operator_assign(byte[] otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanHexString(otherValue);
        return this;
    }

    public TitanHexString_template operator_assign(TitanHexString otherValue) {
        otherValue.must_bound("Assignment of an unbound hexstring value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanHexString(otherValue);
        return this;
    }

    public TitanHexString_template operator_assign(TitanHexString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound hexstring element to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanHexString(otherValue);
        return this;
    }

    public TitanHexString_template operator_assign(TitanHexString_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    private void copy_template(TitanHexString_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanHexString(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanHexString_template temp = new TitanHexString_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value = new byte[otherValue.pattern_value.length];
                System.arraycopy(otherValue.pattern_value, 0, this.pattern_value, 0, otherValue.pattern_value.length);
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = otherValue.dec_match;
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported hexstring template.");
            }
        }
        this.set_selection(otherValue);
    }

    public TitanHexString_Element get_at(int index_value) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a hexstring element of a non-specific hexstring template.");
        }
        return this.single_value.get_at(index_value);
    }

    public TitanHexString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a hexstring template with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public TitanHexString_Element constGet_at(int index_value) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a hexstring element of a non-specific hexstring template.");
        }
        return this.single_value.constGet_at(index_value);
    }

    public TitanHexString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a hexstring template with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanHexString) {
            return this.match((TitanHexString)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to hexstring", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanHexString) {
            this.log_match((TitanHexString)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to hexstring", match_value));
    }

    public boolean match(TitanHexString otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanHexString otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        TitanInteger value_length = otherValue.lengthof();
        if (!this.match_length(value_length.get_int())) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
            case STRING_PATTERN: {
                return this.match_pattern(this.pattern_value, otherValue);
            }
            case DECODE_MATCH: {
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_WARNING);
                TTCN_EncDec.clear_error();
                TitanOctetString os = AdditionalFunctions.hex2oct(otherValue);
                TTCN_Buffer buffer = new TTCN_Buffer(os);
                boolean ret_val = this.dec_match.match(buffer);
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);
                TTCN_EncDec.clear_error();
                return ret_val;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported hexstring template.");
    }

    public boolean match(TitanHexString_Element otherValue, boolean legacy) {
        return this.match(new TitanHexString(otherValue), legacy);
    }

    private boolean match_pattern(byte[] string_pattern, TitanHexString string_value) {
        int stringPatternSize = string_pattern.length;
        int stringValueNNibbles = string_value.get_value().length;
        if (stringPatternSize == 0) {
            return stringValueNNibbles == 0;
        }
        int value_index = 0;
        int template_index = 0;
        int last_asterisk = -1;
        int last_value_to_asterisk = -1;
        while (true) {
            byte pattern_element;
            if ((pattern_element = string_pattern[template_index]) < 16) {
                byte hex_digit = string_value.get_nibble(value_index);
                if (hex_digit == pattern_element) {
                    ++value_index;
                    ++template_index;
                } else {
                    if (last_asterisk == -1) {
                        return false;
                    }
                    template_index = last_asterisk + 1;
                    value_index = ++last_value_to_asterisk;
                }
            } else if (pattern_element == 16) {
                ++value_index;
                ++template_index;
            } else if (pattern_element == 17) {
                last_asterisk = template_index++;
                last_value_to_asterisk = value_index;
            } else {
                throw new TtcnError("Internal error: invalid element in a hexstring pattern.");
            }
            if (value_index == stringValueNNibbles && template_index == stringPatternSize) {
                return true;
            }
            if (template_index == stringPatternSize) {
                if (string_pattern[template_index - 1] == 17) {
                    return true;
                }
                if (last_asterisk == -1) {
                    return false;
                }
                template_index = last_asterisk + 1;
                value_index = ++last_value_to_asterisk;
                continue;
            }
            if (value_index == stringValueNNibbles) break;
        }
        while (template_index < stringPatternSize && string_pattern[template_index] == 17) {
            ++template_index;
        }
        return template_index == stringPatternSize;
    }

    @Override
    public TitanHexString valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific hexstring template.");
        }
        return this.single_value;
    }

    public TitanInteger lengthof() {
        if (this.is_ifPresent) {
            throw new TtcnError("Performing lengthof() operation on a hexstring template which has an ifpresent attribute.");
        }
        int min_length = 0;
        boolean has_any_or_none = false;
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                min_length = this.single_value.lengthof().get_int();
                break;
            }
            case OMIT_VALUE: {
                throw new TtcnError("Performing lengthof() operation on a hexstring template containing omit value.");
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                has_any_or_none = true;
                break;
            }
            case VALUE_LIST: {
                if (this.value_list.isEmpty()) {
                    throw new TtcnError("Internal error: Performing lengthof() operation on a hexstring template containing an empty list.");
                }
                int item_length = this.value_list.get(0).lengthof().get_int();
                for (int i = 1; i < this.value_list.size(); ++i) {
                    if (this.value_list.get(i).lengthof().get_int() == item_length) continue;
                    throw new TtcnError("Performing lengthof() operation on a hexstring template containing a value list with different lengths.");
                }
                min_length = item_length;
                break;
            }
            case COMPLEMENTED_LIST: {
                throw new TtcnError("Performing lengthof() operation on a hexstring template containing complemented list.");
            }
            case STRING_PATTERN: {
                has_any_or_none = false;
                for (int i = 0; i < this.pattern_value.length; ++i) {
                    if (this.pattern_value[i] < 17) {
                        ++min_length;
                        continue;
                    }
                    has_any_or_none = true;
                }
                break;
            }
            default: {
                throw new TtcnError("Performing lengthof() operation on an uninitialized/unsupported hexstring template.");
            }
        }
        return new TitanInteger(this.check_section_is_single(min_length, has_any_or_none, "length", "a", "hexstring template"));
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        if (templateType != Base_Template.template_sel.VALUE_LIST && templateType != Base_Template.template_sel.COMPLEMENTED_LIST && templateType != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Setting an invalid list type for a hexstring template.");
        }
        this.clean_up();
        this.set_selection(templateType);
        if (templateType != Base_Template.template_sel.DECODE_MATCH) {
            this.value_list = new ArrayList(listLength);
            for (int i = 0; i < listLength; ++i) {
                this.value_list.add(new TitanHexString_template());
            }
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list hexstring template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanHexString_template list_item(int listIndex) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list hexstring template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an hexstring value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex >= this.value_list.size()) {
            throw new TtcnError("Index overflow in a hexstring value list template.");
        }
        return this.value_list.get(listIndex);
    }

    public void set_decmatch(IDecode_Match dec_match) {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Setting the decoded content matching mechanism of a non-decmatch hexstring template.");
        }
        this.dec_match = dec_match;
    }

    public Object get_decmatch_dec_res() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoding result of a non-decmatch hexstring template.");
        }
        return this.dec_match.get_dec_res();
    }

    public Base_Type.TTCN_Typedescriptor get_decmatch_type_descr() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoded type's descriptor in a non-decmatch hexstring template.");
        }
        return this.dec_match.get_type_descr();
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value.log();
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case STRING_PATTERN: {
                TTCN_Logger.log_char('\'');
                for (int i = 0; i < this.pattern_value.length; ++i) {
                    byte pattern = this.pattern_value[i];
                    if (pattern < 16) {
                        TTCN_Logger.log_hex(pattern);
                        continue;
                    }
                    if (pattern == 16) {
                        TTCN_Logger.log_char('?');
                        continue;
                    }
                    if (pattern == 17) {
                        TTCN_Logger.log_char('*');
                        continue;
                    }
                    TTCN_Logger.log_event_str("<unknown>");
                }
                TTCN_Logger.log_event_str("'H");
                break;
            }
            case DECODE_MATCH: {
                TTCN_Logger.log_event_str("decmatch ");
                this.dec_match.log();
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_restricted();
        this.log_ifpresent();
    }

    public void log_match(TitanHexString match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "hexstring template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanHexString_template temp = new TitanHexString_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Hexstring: {
                this.operator_assign(new TitanHexString((byte[])param.get_string_data()));
                break;
            }
            case MP_Hexstring_Template: {
                this.operator_assign(new TitanHexString_template((TitanHexString_template)param.get_string_data()));
                break;
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanHexString operand1 = new TitanHexString();
                    TitanHexString operand2 = new TitanHexString();
                    operand1.set_param(param.get_operand1());
                    operand2.set_param(param.get_operand2());
                    this.operator_assign(operand1.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a hexstring");
                break;
            }
            default: {
                param.type_error("hexstring template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
        if (param.get_length_restriction() != null) {
            this.set_length_range(param);
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = this.single_value.get_param(param_name);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            case STRING_PATTERN: {
                mp = new Param_Types.Module_Param_Hexstring_Template(TitanHexString_template.pattern_list_2_string(this.pattern_value));
                break;
            }
            case DECODE_MATCH: {
                throw new TtcnError("Referencing a decoded content matching template is not supported.");
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported hexstring template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        mp.set_length_restriction(this.get_length_range());
        return mp;
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.encode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            case STRING_PATTERN: {
                text_buf.push_int(this.pattern_value.length);
                text_buf.push_raw(this.pattern_value);
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported hexstring template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanHexString();
                this.single_value.decode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanHexString_template temp = new TitanHexString_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            case STRING_PATTERN: {
                int n_elements = text_buf.pull_int().get_int();
                this.pattern_value = new byte[n_elements];
                text_buf.pull_raw(n_elements, this.pattern_value);
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a hexstring template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanHexString_template.get_res_name(restriction), name == null ? "hexstring" : name));
    }
}

