/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titanium.applications.InformationExporter;
import org.eclipse.titanium.error.ConsoleErrorHandler;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.clustering.ClustererBuilder;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.ModuleGraphGenerator;
import org.eclipse.titanium.graph.visualization.GraphHandler;

public class SaveModuleNet
extends InformationExporter {
    private DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph = null;

    @Override
    protected boolean checkParameters(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: <output path> [-c<clustering algorithm name>]");
            System.out.println("The possible clustering algorithms are: ");
            System.out.println("\tModuleLocation\n\tFolderName\n\tLinkedLocation\n\tRegularExpression\n\tModuleName\n");
            return false;
        }
        return true;
    }

    @Override
    protected void exportInformationForProject(String[] args, IProject project, IProgressMonitor monitor) {
        ConsoleErrorHandler errorHandler = new ConsoleErrorHandler();
        ModuleGraphGenerator generator = new ModuleGraphGenerator(project, errorHandler);
        try {
            generator.generateGraph();
            String clusterName = "";
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].startsWith("-c")) continue;
                clusterName = args[i].substring(2);
            }
            if (clusterName.isEmpty()) {
                this.graph = generator.getGraph();
            } else {
                BaseCluster clusterer = new ClustererBuilder().setAlgorithm(clusterName).setGraph(generator.getGraph()).setProject(project).build();
                clusterer.run(monitor, false);
                this.graph = clusterer.getGraph();
            }
            String fileName = args[0] + project.getName() + ".net";
            GraphHandler.saveGraphToPajek(this.graph, fileName);
            errorHandler.reportInformation("The graphs have been successfully saved. See results at " + new File(fileName).getAbsolutePath());
        }
        catch (Exception e) {
            errorHandler.reportException("Error while exporting", e);
        }
    }
}

