/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titanium.organize.OrganizeImports;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class OrganizeFromEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor) && !(editor instanceof TTCNPPEditor)) {
            ErrorReporter.logError((String)"The editor is not found or not a Titan TTCN-3 editor");
            return null;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        TextFileChange change = null;
        try {
            change = OrganizeImports.organizeImportsChange(file);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while creating the needed import changes", (Throwable)e);
            return null;
        }
        try {
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while performing the needed import changes", (Throwable)e);
        }
        IProject project = file.getProject();
        GlobalParser.getProjectSourceParser((IProject)project).reportOutdating(file);
        GlobalParser.getProjectSourceParser((IProject)project).analyzeAll();
        return null;
    }
}

