/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerQuery {
    private final String type;
    private final String[] attributes;
    private final boolean matchTypeChildren;
    private int hashCode;

    public MarkerQuery(String markerType, String[] markerAttributes) {
        this(markerType, markerAttributes, false);
    }

    public MarkerQuery(String markerType, String[] markerAttributes, boolean matchTypeChildren) {
        if (markerAttributes == null) {
            throw new IllegalArgumentException();
        }
        this.type = markerType;
        this.attributes = markerAttributes;
        this.matchTypeChildren = matchTypeChildren;
        this.computeHashCode();
    }

    public MarkerQueryResult performQuery(IMarker marker) {
        block9: {
            block10: {
                try {
                    if (this.type == null) break block9;
                    if (!this.matchTypeChildren) break block10;
                    if (!marker.isSubtypeOf(this.type)) {
                        return null;
                    }
                }
                catch (CoreException e) {
                    Policy.handle(e);
                    return null;
                }
            }
            if (!this.type.equals(marker.getType())) {
                return null;
            }
        }
        String[] values = new String[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            Object value;
            block11: {
                try {
                    value = marker.getAttribute(this.attributes[i]);
                    if (value != null) break block11;
                    return null;
                }
                catch (CoreException e) {
                    Policy.handle(e);
                    return null;
                }
            }
            values[i] = value.toString();
            ++i;
        }
        return new MarkerQueryResult(values);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarkerQuery)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        MarkerQuery mq = (MarkerQuery)o;
        return Objects.equals(this.type, mq.type) && Objects.equals(this.matchTypeChildren, mq.matchTypeChildren) && Arrays.equals(this.attributes, mq.attributes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void computeHashCode() {
        this.hashCode = 19;
        if (this.type != null) {
            this.hashCode = this.hashCode * 37 + this.type.hashCode();
        }
        this.hashCode = this.hashCode * 37 + (this.matchTypeChildren ? 1 : 2);
        String[] stringArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            this.hashCode = this.hashCode * 37 + attribute.hashCode();
            ++n2;
        }
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

