/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.GraphStructureListener;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;

public class TreeLayoutObserver {
    private final GraphStructureListener structureListener = new GraphStructureListener(){

        @Override
        public boolean nodeRemoved(LayoutContext context, NodeLayout node) {
            TreeNode treeNode = TreeLayoutObserver.this.layoutToTree.get(node);
            treeNode.parent.children.remove(treeNode);
            TreeLayoutObserver.this.superRoot.precomputeTree();
            Iterator<TreeListener> iterator = TreeLayoutObserver.this.treeListeners.iterator();
            while (iterator.hasNext()) {
                TreeListener treeListener;
                TreeListener listener = treeListener = iterator.next();
                listener.nodeRemoved(treeNode);
            }
            return false;
        }

        @Override
        public boolean nodeAdded(LayoutContext context, NodeLayout node) {
            TreeNode treeNode = TreeLayoutObserver.this.getTreeNode(node);
            TreeLayoutObserver.this.superRoot.addChild(treeNode);
            TreeLayoutObserver.this.superRoot.precomputeTree();
            Iterator<TreeListener> iterator = TreeLayoutObserver.this.treeListeners.iterator();
            while (iterator.hasNext()) {
                TreeListener treeListener;
                TreeListener listener = treeListener = iterator.next();
                listener.nodeAdded(treeNode);
            }
            return false;
        }

        @Override
        public boolean connectionRemoved(LayoutContext context, ConnectionLayout connection) {
            TreeNode node1 = TreeLayoutObserver.this.layoutToTree.get(connection.getSource());
            TreeNode node2 = TreeLayoutObserver.this.layoutToTree.get(connection.getTarget());
            if (node1.parent == node2) {
                node1.findNewParent();
                if (node1.parent != node2) {
                    TreeLayoutObserver.this.superRoot.precomputeTree();
                    this.fireParentChanged(node1, node2);
                }
            }
            if (node2.parent == node1) {
                node2.findNewParent();
                if (node2.parent != node1) {
                    TreeLayoutObserver.this.superRoot.precomputeTree();
                    this.fireParentChanged(node2, node1);
                }
            }
            return false;
        }

        @Override
        public boolean connectionAdded(LayoutContext context, ConnectionLayout connection) {
            TreeNode previousParent;
            TreeNode target;
            TreeNode source = TreeLayoutObserver.this.layoutToTree.get(connection.getSource());
            if (source == (target = TreeLayoutObserver.this.layoutToTree.get(connection.getTarget()))) {
                return false;
            }
            if (target.isBetterParent(source)) {
                previousParent = target.parent;
                previousParent.children.remove(target);
                source.addChild(target);
                TreeLayoutObserver.this.superRoot.precomputeTree();
                this.fireParentChanged(target, previousParent);
            }
            if (!connection.isDirected() && source.isBetterParent(target)) {
                previousParent = source.parent;
                previousParent.children.remove(source);
                target.addChild(source);
                TreeLayoutObserver.this.superRoot.precomputeTree();
                this.fireParentChanged(source, previousParent);
            }
            return false;
        }

        private void fireParentChanged(TreeNode node, TreeNode previousParent) {
            for (TreeListener listener : TreeLayoutObserver.this.treeListeners) {
                listener.parentChanged(node, previousParent);
            }
        }
    };
    private final Map<NodeLayout, TreeNode> layoutToTree = new HashMap<NodeLayout, TreeNode>();
    private final TreeNodeFactory factory;
    private final LayoutContext context;
    private TreeNode superRoot;
    private final List<TreeListener> treeListeners = new CopyOnWriteArrayList<TreeListener>();

    public TreeLayoutObserver(LayoutContext context, TreeNodeFactory nodeFactory) {
        this.factory = nodeFactory == null ? new TreeNodeFactory() : nodeFactory;
        this.context = context;
        context.addGraphStructureListener(this.structureListener);
        this.recomputeTree();
    }

    public void recomputeTree() {
        this.superRoot = this.factory.createTreeNode(null, this);
        this.layoutToTree.put(null, this.superRoot);
        this.createTrees(this.context.getNodes());
    }

    public void stop() {
        this.context.removeGraphStructureListener(this.structureListener);
    }

    public TreeNode getSuperRoot() {
        return this.superRoot;
    }

    public TreeNode getTreeNode(NodeLayout node) {
        TreeNode treeNode = this.layoutToTree.get(node);
        if (treeNode == null) {
            treeNode = this.factory.createTreeNode(node, this);
            this.layoutToTree.put(node, treeNode);
        }
        return treeNode;
    }

    public void addTreeListener(TreeListener listener) {
        this.treeListeners.add(listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.treeListeners.add(listener);
    }

    private void createTrees(NodeLayout[] nodes) {
        HashSet<NodeLayout> alreadyVisited = new HashSet<NodeLayout>();
        LinkedList<Object[]> nodesToAdd = new LinkedList<Object[]>();
        NodeLayout[] nodeLayoutArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout node = nodeLayoutArray[n2];
            NodeLayout root = TreeLayoutObserver.findRoot(node, alreadyVisited);
            if (root != null) {
                alreadyVisited.add(root);
                nodesToAdd.addLast(new Object[]{root, this.superRoot});
            }
            ++n2;
        }
        while (!nodesToAdd.isEmpty()) {
            NodeLayout[] children;
            Object[] dequeued = (Object[])nodesToAdd.removeFirst();
            NodeLayout nodeLayout = (NodeLayout)dequeued[0];
            TreeNode currentNode = this.factory.createTreeNode(nodeLayout, this);
            this.layoutToTree.put(nodeLayout, currentNode);
            TreeNode currentRoot = (TreeNode)dequeued[1];
            currentRoot.addChild(currentNode);
            NodeLayout[] nodeLayoutArray2 = children = currentNode.node.getSuccessingNodes();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeLayout child = nodeLayoutArray2[n4];
                if (!alreadyVisited.contains(child)) {
                    alreadyVisited.add(child);
                    nodesToAdd.addLast(new Object[]{child, currentNode});
                }
                ++n4;
            }
        }
        this.superRoot.precomputeTree();
    }

    private static NodeLayout findRoot(NodeLayout nodeLayout, Set<NodeLayout> alreadyVisited) {
        HashSet<NodeLayout> alreadyVisitedRoot = new HashSet<NodeLayout>();
        while (!alreadyVisited.contains(nodeLayout)) {
            if (alreadyVisitedRoot.contains(nodeLayout)) {
                return nodeLayout;
            }
            alreadyVisitedRoot.add(nodeLayout);
            NodeLayout[] predecessingNodes = nodeLayout.getPredecessingNodes();
            if (predecessingNodes.length <= 0) {
                return nodeLayout;
            }
            nodeLayout = predecessingNodes[0];
        }
        return null;
    }

    public static class TreeListener {
        public void nodeAdded(TreeNode newNode) {
            this.defaultHandle(newNode);
        }

        public void nodeRemoved(TreeNode removedNode) {
            this.defaultHandle(removedNode);
        }

        public void parentChanged(TreeNode node, TreeNode previousParent) {
            this.defaultHandle(node);
        }

        protected void defaultHandle(TreeNode changedNode) {
        }
    }

    public static class TreeNode {
        protected final NodeLayout node;
        protected final TreeLayoutObserver owner;
        protected int height = 0;
        protected int depth = -1;
        protected int numOfLeaves = 0;
        protected int numOfDescendants = 0;
        protected int order = 0;
        protected final List<TreeNode> children = new ArrayList<TreeNode>();
        protected TreeNode parent;
        protected boolean firstChild = false;
        protected boolean lastChild = false;

        public NodeLayout getNode() {
            return this.node;
        }

        public TreeLayoutObserver getOwner() {
            return this.owner;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getNumOfLeaves() {
            return this.numOfLeaves;
        }

        public int getNumOfDescendants() {
            return this.numOfDescendants;
        }

        public int getOrder() {
            return this.order;
        }

        public List<? extends TreeNode> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isFirstChild() {
            return this.firstChild;
        }

        public boolean isLastChild() {
            return this.lastChild;
        }

        protected TreeNode(NodeLayout node, TreeLayoutObserver owner) {
            this.node = node;
            this.owner = owner;
        }

        protected void addChild(TreeNode child) {
            this.children.add(child);
            child.parent = this;
        }

        protected void precomputeTree() {
            if (this.children.isEmpty()) {
                this.height = 0;
                this.numOfLeaves = 1;
                this.numOfDescendants = 0;
            } else {
                this.height = 0;
                this.numOfLeaves = 0;
                this.numOfDescendants = 0;
                ListIterator<TreeNode> iterator = this.children.listIterator();
                while (iterator.hasNext()) {
                    TreeNode child = iterator.next();
                    child.depth = this.depth + 1;
                    child.order = this.order + this.numOfLeaves;
                    child.precomputeTree();
                    child.firstChild = this.numOfLeaves == 0;
                    child.lastChild = !iterator.hasNext();
                    this.height = Math.max(this.height, child.height + 1);
                    this.numOfLeaves += child.numOfLeaves;
                    this.numOfDescendants += child.numOfDescendants + 1;
                }
            }
        }

        protected void findNewParent() {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            NodeLayout[] predecessingNodes = this.node.getPredecessingNodes();
            this.parent = null;
            NodeLayout[] nodeLayoutArray = predecessingNodes;
            int n = predecessingNodes.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout predecessingNode = nodeLayoutArray[n2];
                TreeNode potentialParent = this.owner.layoutToTree.get(predecessingNode);
                if (!this.children.contains(potentialParent) && this.isBetterParent(potentialParent)) {
                    this.parent = potentialParent;
                }
                ++n2;
            }
            if (this.parent == null) {
                this.parent = this.owner.superRoot;
            }
            this.parent.addChild(this);
        }

        protected boolean isBetterParent(TreeNode potentialParent) {
            if (potentialParent == null) {
                return false;
            }
            if (this.parent == null && !this.isAncestorOf(potentialParent)) {
                return true;
            }
            if (potentialParent.depth <= this.depth && potentialParent.depth != -1) {
                return true;
            }
            return this.parent != null && this.parent.depth == -1 && potentialParent.depth >= 0 && !this.isAncestorOf(potentialParent);
        }

        public boolean isAncestorOf(TreeNode descendant) {
            while (descendant.depth > this.depth) {
                descendant = descendant.parent;
            }
            return descendant == this;
        }
    }

    public static class TreeNodeFactory {
        public TreeNode createTreeNode(NodeLayout nodeLayout, TreeLayoutObserver observer) {
            return new TreeNode(nodeLayout, observer);
        }
    }
}

