/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.project.IBuildProjectFileResolver;
import org.osgi.service.component.annotations.Component;

@Component(service={IBuildProjectFileResolver.class})
public class PDEBuildProjectFileResolver
implements IBuildProjectFileResolver {
    private static final Map<String, IPath> POM_NAME_2_PROJECT_FILE = Map.of(".polyglot.META-INF", IPath.forPosix((String)"META-INF/MANIFEST.MF"), ".polyglot.feature.xml", IPath.forPosix((String)"feature.xml"));

    public IPath resolveProjectFile(String pomFilename) {
        IPath realFile = POM_NAME_2_PROJECT_FILE.get(pomFilename);
        if (realFile != null) {
            return realFile;
        }
        if (pomFilename.startsWith(".polyglot.") && (pomFilename.endsWith(".product") || pomFilename.endsWith(".target"))) {
            return IPath.forPosix((String)pomFilename.substring(".polyglot.".length()));
        }
        return null;
    }
}

