/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri.model;

import java.util.Locale;
import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.Variables;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.VariablePointer;

public class VariablePointerFactory
implements NodePointerFactory {
    public static final int VARIABLE_POINTER_FACTORY_ORDER = 890;

    public static VariableContextWrapper contextWrapper(JXPathContext context) {
        return new VariableContextWrapper(context);
    }

    @Override
    public NodePointer createNodePointer(QName name, Object object, Locale locale) {
        if (object instanceof VariableContextWrapper) {
            JXPathContext varCtx = ((VariableContextWrapper)object).getContext();
            while (varCtx != null) {
                Variables vars = varCtx.getVariables();
                if (vars.isDeclaredVariable(name.toString())) {
                    return new VariablePointer(vars, name);
                }
                varCtx = varCtx.getParentContext();
            }
            return new VariablePointer(name);
        }
        return null;
    }

    @Override
    public NodePointer createNodePointer(NodePointer parent, QName name, Object object) {
        return this.createNodePointer(name, object, null);
    }

    @Override
    public int getOrder() {
        return 890;
    }

    public static final class VariableContextWrapper {
        private final JXPathContext context;

        private VariableContextWrapper(JXPathContext context) {
            this.context = context;
        }

        public JXPathContext getContext() {
            return this.context;
        }
    }
}

