/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.service.http.HttpService;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class Matcher {
    private final ServiceReference<HttpService> httpServiceReference;
    private final ServiceReference<ApplicationConfiguration> configurationReference;

    Matcher(ServiceReference<HttpService> httpServiceReference, ServiceReference<ApplicationConfiguration> configurationReference) {
        this.httpServiceReference = httpServiceReference;
        this.configurationReference = configurationReference;
    }

    public boolean matches() {
        return this.matchesHttpService() && this.matchesConfigurator();
    }

    private boolean matchesHttpService() {
        return Matcher.matchesTarget(this.configurationReference, this.httpServiceReference, HttpService.class);
    }

    private boolean matchesConfigurator() {
        Class<ApplicationConfiguration> targetType = ApplicationConfiguration.class;
        return Matcher.matchesTarget(this.httpServiceReference, this.configurationReference, targetType);
    }

    private static boolean matchesTarget(ServiceReference<?> serviceReference, ServiceReference<?> targetReference, Class<?> targetType) {
        String filterExpression = Matcher.getFilterExpression(serviceReference, targetType);
        if (filterExpression != null) {
            Filter filter = Matcher.createFilter(filterExpression);
            return filter.match(targetReference);
        }
        return targetReference != null;
    }

    private static String getFilterExpression(ServiceReference<?> serviceReference, Class<?> targetType) {
        if (serviceReference != null) {
            return (String)serviceReference.getProperty(Matcher.createTargetKey(targetType));
        }
        return null;
    }

    private static Filter createFilter(String filterExpression) {
        try {
            return FrameworkUtil.createFilter((String)filterExpression);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    static String createTargetKey(Class<?> targetType) {
        return targetType.getSimpleName().substring(0, 1).toLowerCase() + targetType.getSimpleName().substring(1) + ".target";
    }
}

