/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.explanation.Explanation;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class SPARQLGraphQuery
extends AbstractHTTPQuery
implements GraphQuery {
    public SPARQLGraphQuery(SPARQLProtocolSession httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        SPARQLProtocolSession client = this.getHttpClient();
        try {
            return client.sendGraphQuery(this.queryLanguage, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), (WeakReference)null, this.getBindingsArray());
        }
        catch (IOException | MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        SPARQLProtocolSession client = this.getHttpClient();
        try {
            client.sendGraphQuery(this.queryLanguage, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), handler, this.getBindingsArray());
        }
        catch (IOException | MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
    }

    private String getQueryString() {
        return QueryStringUtil.getGraphQueryString(this.queryString, this.getBindings());
    }

    public Explanation explain(Explanation.Level level) {
        throw new UnsupportedOperationException();
    }
}

