/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import java.util.Optional;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.federated.algebra.PrecompiledQueryNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.BindingAssignerOptimizer;

class SailSourceEvaluationStrategyFactory
implements EvaluationStrategyFactory {
    private final EvaluationStrategyFactory delegate;

    public SailSourceEvaluationStrategyFactory(EvaluationStrategyFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setQuerySolutionCacheThreshold(long threshold) {
        this.delegate.setQuerySolutionCacheThreshold(threshold);
    }

    @Override
    public long getQuerySolutionCacheThreshold() {
        return this.delegate.getQuerySolutionCacheThreshold();
    }

    @Override
    public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
        this.delegate.setOptimizerPipeline(pipeline);
    }

    @Override
    public Optional<QueryOptimizerPipeline> getOptimizerPipeline() {
        return this.delegate.getOptimizerPipeline();
    }

    @Override
    public EvaluationStrategy createEvaluationStrategy(Dataset dataset, TripleSource tripleSource, EvaluationStatistics evaluationStatistics) {
        EvaluationStrategy delegateStrategy = this.delegate.createEvaluationStrategy(dataset, tripleSource, evaluationStatistics);
        return new SailSourceEvaluationStrategy(delegateStrategy, dataset);
    }

    private static class SailSourceEvaluationStrategy
    implements EvaluationStrategy {
        private final EvaluationStrategy delegate;
        private final Dataset dataset;

        public SailSourceEvaluationStrategy(EvaluationStrategy delegate, Dataset dataset) {
            this.delegate = delegate;
            this.dataset = dataset;
        }

        @Override
        public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
            return this.delegate.getService(serviceUrl);
        }

        @Override
        public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
            this.delegate.setOptimizerPipeline(pipeline);
        }

        @Override
        public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
            if (expr instanceof PrecompiledQueryNode) {
                return this.optimizePreparedQuery((PrecompiledQueryNode)expr, bindings);
            }
            return this.delegate.optimize(expr, evaluationStatistics, bindings);
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service expr, String serviceUri, CloseableIteration<BindingSet, QueryEvaluationException> bindings) throws QueryEvaluationException {
            return this.delegate.evaluate(expr, serviceUri, bindings);
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate.evaluate(expr, bindings);
        }

        @Override
        public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.delegate.evaluate(expr, bindings);
        }

        @Override
        public boolean isTrue(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.delegate.isTrue(expr, bindings);
        }

        @Override
        public boolean isTrue(QueryValueEvaluationStep expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.delegate.isTrue(expr, bindings);
        }

        protected TupleExpr optimizePreparedQuery(PrecompiledQueryNode preparedQuery, BindingSet bindings) {
            TupleExpr actualQuery = preparedQuery.getQuery();
            if (bindings != null) {
                new BindingAssignerOptimizer().optimize(actualQuery, this.dataset, bindings);
            }
            return actualQuery;
        }

        @Override
        public QueryEvaluationMode getQueryEvaluationMode() {
            return this.delegate.getQueryEvaluationMode();
        }

        @Override
        public void setQueryEvaluationMode(QueryEvaluationMode queryEvaluationMode) {
            this.delegate.setQueryEvaluationMode(queryEvaluationMode);
        }
    }
}

