/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ObjStoreListProperties;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Enumeration;

public class ConsoleObjStoreManager
extends ObjStoreManager {
    private static ConsoleObjStoreManager mgr = null;
    private String fileName = "objstorelist.properties";

    protected ConsoleObjStoreManager() {
    }

    public static synchronized ConsoleObjStoreManager getConsoleObjStoreManager() {
        if (mgr == null) {
            mgr = new ConsoleObjStoreManager();
        }
        return mgr;
    }

    public void readObjStoresFromFile() throws UserPropertiesException, ObjStoreException {
        ObjStoreListProperties oslProps = this.readFromFile();
        int count = oslProps.getObjStoreCount();
        for (int i = 0; i < count; ++i) {
            ObjStoreAttrs osa = oslProps.getObjStoreAttrs(i);
            this.createStore(osa);
        }
    }

    private ObjStoreListProperties readFromFile() throws UserPropertiesException {
        ObjStoreListProperties oslProps = new ObjStoreListProperties();
        oslProps.setFileName(this.fileName);
        oslProps.load();
        return oslProps;
    }

    public void writeObjStoresToFile() throws UserPropertiesException {
        Enumeration e = this.objStores.elements();
        ObjStoreListProperties oslProps = new ObjStoreListProperties();
        while (e.hasMoreElements()) {
            ObjStore os = (ObjStore)e.nextElement();
            ObjStoreAttrs osa = os.getObjStoreAttrs();
            osa.prepareToTerminate();
            oslProps.addObjStoreAttrs(osa);
        }
        this.writeToFile(oslProps);
    }

    private void writeToFile(ObjStoreListProperties oslProps) throws UserPropertiesException {
        oslProps.setFileName(this.fileName);
        oslProps.save();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

