/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.CustomContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ZoomContributionItem
extends CustomContributionItem
implements ZoomListener,
Listener {
    private static final String ZOOM_IN = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomIn;
    private static final String ZOOM_OUT = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomOut;
    private static final String ZOOM_100 = DiagramUIMessages.ZoomAction_ZoomCombo_Zoom100;
    private static final String ZOOM_FIT = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToFit;
    private static final String ZOOM_WIDTH = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToWidth;
    private static final String ZOOM_HEIGHT = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToHeight;
    private static final String ZOOM_SELECTION = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToSelection;
    private static final String ZOOM_IN_ACTION = DiagramUIMessages.ZoomAction_ZoomIn;
    private static final String ZOOM_OUT_ACTION = DiagramUIMessages.ZoomAction_ZoomOut;
    private static final String ZOOM_100_ACTION = DiagramUIMessages.ZoomAction_Zoom100;
    private static final String ZOOM_FIT_ACTION = DiagramUIMessages.ZoomAction_ZoomToFit;
    private static final String ZOOM_WIDTH_ACTION = DiagramUIMessages.ZoomAction_ZoomToWidth;
    private static final String ZOOM_HEIGHT_ACTION = DiagramUIMessages.ZoomAction_ZoomToHeight;
    private static final String ZOOM_SELECTION_ACTION = DiagramUIMessages.ZoomAction_ZoomToSelection;
    private ZoomManager zoomManager;
    private List<Image> zoomImages = new ArrayList<Image>();

    public ZoomContributionItem(IWorkbenchPage workbenchPage) {
        super(workbenchPage, "zoomContributionItem");
        this.setLabel(DiagramUIMessages.ZoomActionMenu_ZoomLabel);
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setWorkbenchPart(workbenchPart);
        if (workbenchPart != null) {
            this.setZoomManager((ZoomManager)workbenchPart.getAdapter(ZoomManager.class));
        }
    }

    protected boolean calculateEnabled() {
        return this.getZoomManager() != null;
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public void setZoomManager(ZoomManager zm) {
        if (this.zoomManager == zm) {
            return;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
        }
        this.zoomManager = zm;
        this.update();
        if (this.zoomManager != null) {
            this.zoomManager.addZoomListener((ZoomListener)this);
        }
    }

    public void dispose() {
        if (this.getZoomManager() != null) {
            this.getZoomManager().removeZoomListener((ZoomListener)this);
            this.zoomManager = null;
        }
        for (Image image : this.zoomImages) {
            image.dispose();
        }
        this.zoomImages.clear();
        super.dispose();
    }

    public void zoomChanged(double zoom) {
        this.update();
    }

    protected Control createControl(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.addListener(13, (Listener)this);
        combo.addListener(1, (Listener)this);
        combo.setItems(this.getZoomLevelsAsText());
        combo.setVisibleItemCount(20);
        return combo;
    }

    protected MenuItem createMenuItem(Menu parent, int index) {
        MenuItem mi = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
        this.createMenu(mi);
        mi.setImage(DiagramUIPluginImages.get("icons/zoomplus.gif"));
        return mi;
    }

    private void createMenu(MenuItem mi) {
        Menu menu = new Menu(mi.getParent());
        this.createMenuItem(menu, ZOOM_IN_ACTION, ZOOM_IN, DiagramUIPluginImages.DESC_ZOOM_IN);
        this.createMenuItem(menu, ZOOM_OUT_ACTION, ZOOM_OUT, DiagramUIPluginImages.DESC_ZOOM_OUT);
        this.createMenuItem(menu, ZOOM_100_ACTION, ZOOM_100, DiagramUIPluginImages.DESC_ZOOM_100);
        this.createMenuItem(menu, ZOOM_FIT_ACTION, ZOOM_FIT, DiagramUIPluginImages.DESC_ZOOM_TOFIT);
        this.createMenuItem(menu, ZOOM_WIDTH_ACTION, ZOOM_WIDTH, DiagramUIPluginImages.DESC_ZOOM_TOFIT);
        this.createMenuItem(menu, ZOOM_HEIGHT_ACTION, ZOOM_HEIGHT, DiagramUIPluginImages.DESC_ZOOM_TOFIT);
        this.createMenuItem(menu, ZOOM_SELECTION_ACTION, ZOOM_SELECTION, DiagramUIPluginImages.DESC_ZOOM_TOFIT);
        mi.setMenu(menu);
    }

    private MenuItem createMenuItem(Menu menu, String text, String data, ImageDescriptor imageDescriptor) {
        MenuItem mi = new MenuItem(menu, 8);
        mi.setText(text);
        mi.setData((Object)data);
        if (imageDescriptor != null) {
            mi.setImage(this.createImage(imageDescriptor));
        }
        mi.addListener(13, (Listener)this);
        return mi;
    }

    public String[] getZoomLevelsAsText() {
        int nNumericZoomLevels = this.getZoomManager() != null ? this.getZoomManager().getZoomLevels().length : 0;
        String[] allZoomLevels = new String[nNumericZoomLevels + 6];
        allZoomLevels[0] = ZOOM_IN;
        allZoomLevels[1] = ZOOM_OUT;
        allZoomLevels[2] = ZOOM_FIT;
        allZoomLevels[3] = ZOOM_WIDTH;
        allZoomLevels[4] = ZOOM_HEIGHT;
        allZoomLevels[5] = ZOOM_SELECTION;
        if (this.getZoomManager() != null) {
            String[] numericZoomLevels = this.getZoomManager().getZoomLevelsAsText();
            int i = 0;
            while (i < this.getZoomManager().getZoomLevels().length) {
                allZoomLevels[i + 6] = numericZoomLevels[i];
                ++i;
            }
        }
        return allZoomLevels;
    }

    protected void refreshItem() {
        if (this.getZoomManager() != null && this.getControl() != null) {
            Combo combo = (Combo)this.getControl();
            combo.setItems(this.getZoomLevelsAsText());
            String zoom = this.getZoomManager().getZoomAsText();
            int index = combo.indexOf(zoom);
            if (index != -1) {
                combo.select(index);
            } else {
                combo.setText(zoom);
            }
        }
        super.refreshItem();
    }

    public void handleEvent(Event event) {
        if (event.type == 1 && event.character != '\r') {
            return;
        }
        if (this.getControl() != null) {
            this.setZoomAsText(((Combo)this.getControl()).getText());
        } else {
            this.setZoomAsText((String)event.widget.getData());
        }
    }

    public void setZoomAsText(String zoomText) {
        if (ZOOM_IN.equals(zoomText)) {
            this.getZoomManager().zoomIn();
        } else if (ZOOM_OUT.equals(zoomText)) {
            this.getZoomManager().zoomOut();
        } else if (ZOOM_100.equals(zoomText)) {
            this.getZoomManager().setZoom(1.0);
        } else if (ZOOM_FIT.equals(zoomText)) {
            this.zoomToFit(true, true, false);
        } else if (ZOOM_WIDTH.equals(zoomText)) {
            this.zoomToFit(true, false, false);
        } else if (ZOOM_HEIGHT.equals(zoomText)) {
            this.zoomToFit(false, true, false);
        } else if (ZOOM_SELECTION.equals(zoomText)) {
            this.zoomToFit(true, true, true);
        } else {
            this.getZoomManager().setZoomAsText(zoomText);
        }
    }

    protected void zoomToFit(boolean onWidth, boolean onHeight, boolean selectionOnly) {
        this.zoomToFit(onWidth, onHeight, selectionOnly, false);
    }

    protected void zoomToFit(boolean onWidth, boolean onHeight, boolean selectionOnly, boolean zoomOutOnly) {
        Iterator editParts;
        if (selectionOnly) {
            editParts = this.getStructuredSelection().iterator();
        } else {
            List allEditParts = this.getDiagramEditPart().getConnections();
            allEditParts.addAll(this.getDiagramEditPart().getChildrenAffectingZoom());
            editParts = allEditParts.iterator();
        }
        Rectangle targetRegion = null;
        while (editParts.hasNext()) {
            IFigure f = ((GraphicalEditPart)editParts.next()).getFigure();
            Rectangle rectangle = targetRegion = targetRegion == null ? f.getBounds().getCopy() : targetRegion.getUnion(f.getBounds());
        }
        if (targetRegion == null) {
            return;
        }
        MapModeUtil.getMapMode((IFigure)this.getDiagramEditPart().getFigure()).LPtoDP(targetRegion);
        Viewport viewport = this.getZoomManager().getViewport();
        float xratio = (float)viewport.getHorizontalRangeModel().getExtent() / (float)targetRegion.width;
        float yratio = (float)viewport.getVerticalRangeModel().getExtent() / (float)targetRegion.height;
        double zoom = 1.0;
        if (onHeight && onWidth) {
            zoom = yratio < xratio ? Math.floor(yratio * 100.0f) : Math.floor(xratio * 100.0f);
        } else if (onWidth) {
            zoom = Math.floor(xratio * 100.0f);
        } else if (onHeight) {
            zoom = Math.floor(yratio * 100.0f);
        }
        if (zoomOutOnly && zoom >= 100.0) {
            zoom = 100.0;
        }
        Point topLeft = targetRegion.getTopLeft();
        zoom = Math.min((double)((int)(this.zoomManager.getMaxZoom() * 100.0)), Math.max((double)((int)(this.zoomManager.getMinZoom() * 100.0)), zoom));
        int viewX = Math.round((float)topLeft.x * (float)zoom / 100.0f);
        int viewY = Math.round((float)topLeft.y * (float)zoom / 100.0f);
        this.getZoomManager().setZoom(zoom / 100.0);
        viewport.setHorizontalLocation(viewX);
        viewport.setVerticalLocation(viewY);
        this.update();
    }

    private Image createImage(ImageDescriptor descriptor) {
        int index = this.zoomImages.indexOf(descriptor);
        if (index != -1) {
            return this.zoomImages.get(index);
        }
        Image image = descriptor.createImage();
        this.zoomImages.add(image);
        return image;
    }
}

