/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.internal.l10n.Draw2dUIPluginImages;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class RectangularDropShadow {
    private static ImageData alpha_ilb = Draw2dUIPluginImages.DESC_LEFT_BOTTOM.getImageData();
    private static ImageData alpha_irb = Draw2dUIPluginImages.DESC_RIGHT_BOTTOM.getImageData();
    private static ImageData alpha_ir = Draw2dUIPluginImages.DESC_RIGHT.getImageData();
    private static ImageData alpha_itr = Draw2dUIPluginImages.DESC_TOP_RIGHT.getImageData();
    private static ImageData alpha_ib = Draw2dUIPluginImages.DESC_BOTTOM.getImageData();

    public int getShadowWidth() {
        return RectangularDropShadow.alpha_ir.width;
    }

    public int getShadowHeight() {
        return RectangularDropShadow.alpha_ib.height;
    }

    public void drawShadow(IFigure figure, Graphics g, Rectangle rect) {
        this.drawBottomLeftShadow(figure, g, rect);
        this.drawBottomShadow(figure, g, rect);
        this.drawBottomRightShadow(figure, g, rect);
        this.drawRightShadow(figure, g, rect);
        this.drawTopRightShadow(figure, g, rect);
    }

    protected void drawTopRightShadow(IFigure figure, Graphics g, Rectangle rBox) {
        Dimension dim = new Dimension(RectangularDropShadow.alpha_itr.width, RectangularDropShadow.alpha_itr.height);
        Image itr = this.createImageFromAlpha(figure, alpha_itr, dim);
        Point pt = new Point(rBox.getRight().x - MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ir.width), rBox.getTop().y);
        g.drawImage(itr, pt);
        itr.dispose();
    }

    protected void drawRightShadow(IFigure figure, Graphics g, Rectangle rBox) {
        Dimension dim = this.getRightShadowDimension(figure, rBox);
        Image ir = this.createImageFromAlpha(figure, alpha_ir, dim);
        Point pt = new Point(rBox.getRight().x - MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ir.width), rBox.getTop().y + MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_itr.height));
        g.drawImage(ir, pt);
        ir.dispose();
    }

    protected void drawBottomRightShadow(IFigure figure, Graphics g, Rectangle rBox) {
        Dimension dim = this.getBottomRightShadowDimension();
        Image irb = this.createImageFromAlpha(figure, alpha_irb, dim);
        Point pt = new Point(rBox.getRight().x - MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ir.width), rBox.getBottom().y - MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ib.height));
        g.drawImage(irb, pt);
        irb.dispose();
    }

    protected void drawBottomShadow(IFigure figure, Graphics g, Rectangle rBox) {
        Dimension dim = this.getBottomShadowDimension(figure, rBox);
        Image ib = this.createImageFromAlpha(figure, alpha_ib, dim);
        Point pt = new Point(rBox.getLeft().x + MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ilb.width), rBox.getBottom().y - MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ib.height));
        g.drawImage(ib, pt);
        ib.dispose();
    }

    private void drawBottomLeftShadow(IFigure figure, Graphics g, Rectangle rBox) {
        Dimension dim = this.getLeftShadowDimension();
        Image ilb = this.createImageFromAlpha(figure, alpha_ilb, dim);
        Point pt = new Point(rBox.getLeft().x, rBox.getBottom().y - MapModeUtil.getMapMode(figure).DPtoLP(RectangularDropShadow.alpha_ib.height));
        g.drawImage(ilb, pt);
        ilb.dispose();
    }

    protected Dimension getRightShadowDimension(IFigure figure, Rectangle rBox) {
        int height = Math.max(MapModeUtil.getMapMode(figure).LPtoDP(rBox.height) - RectangularDropShadow.alpha_itr.height - RectangularDropShadow.alpha_irb.height, 1);
        return new Dimension(RectangularDropShadow.alpha_ir.width, height);
    }

    protected Dimension getBottomRightShadowDimension() {
        return new Dimension(RectangularDropShadow.alpha_irb.width, RectangularDropShadow.alpha_irb.height);
    }

    protected Dimension getBottomShadowDimension(IFigure figure, Rectangle rBox) {
        int width = Math.max(MapModeUtil.getMapMode(figure).LPtoDP(rBox.width) - RectangularDropShadow.alpha_ilb.width - RectangularDropShadow.alpha_irb.width, 1);
        return new Dimension(width, RectangularDropShadow.alpha_ib.height);
    }

    protected Dimension getLeftShadowDimension() {
        return new Dimension(RectangularDropShadow.alpha_ilb.width, RectangularDropShadow.alpha_ilb.height);
    }

    private Image createImageFromAlpha(IFigure figure, ImageData alphaData, Dimension dim) {
        Color foreColor = figure.getForegroundColor();
        ImageData newAlpha = alphaData;
        if (alphaData.width != dim.width || alphaData.height != dim.height) {
            ImageData newAlphaData = new ImageData((dim.width + 3) / 4 * 4, dim.height, alphaData.depth, alphaData.palette);
            Image imgNewAlpha = new Image(null, newAlphaData);
            GC gc = new GC((Drawable)imgNewAlpha);
            Image imgAlpha = new Image(null, alphaData);
            gc.drawImage(imgAlpha, 0, 0, alphaData.width, alphaData.height, 0, 0, newAlphaData.width, newAlphaData.height);
            int nDelta = newAlphaData.width - dim.width;
            if (nDelta > 0) {
                gc.setForeground(ColorConstants.black);
                gc.setBackground(ColorConstants.black);
                gc.fillRectangle(newAlphaData.width - nDelta, 0, nDelta, newAlphaData.height);
            }
            newAlpha = imgNewAlpha.getImageData();
            imgNewAlpha.dispose();
            imgAlpha.dispose();
            gc.dispose();
        }
        Image img = new Image((Device)Display.getDefault(), newAlpha.width, newAlpha.height);
        GC gc = new GC((Drawable)img);
        gc.setForeground(foreColor);
        gc.setBackground(foreColor);
        gc.fillRectangle(0, 0, newAlpha.width, newAlpha.height);
        gc.dispose();
        ImageData filledData = img.getImageData();
        img.dispose();
        int i = 0;
        while (i < newAlpha.height) {
            filledData.setAlphas(0, i, newAlpha.width, newAlpha.data, i * newAlpha.width);
            ++i;
        }
        return new Image(null, filledData);
    }
}

