/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;

public class XpandFacade {
    private XpandExecutionContext ctx = null;

    public XpandFacade(XpandExecutionContext ctx) {
        this.ctx = ctx;
    }

    public void evaluate(String definitionName, Object targetObject, Object[] params) {
        params = params == null ? new Object[]{} : params;
        EClassifier targetType = BuiltinMetaModel.getType(targetObject);
        EClassifier[] paramTypes = new EClassifier[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = BuiltinMetaModel.getType(params[i]);
            ++i;
        }
        XpandDefinition def = this.ctx.findDefinition(definitionName, targetType, paramTypes);
        if (def == null) {
            throw new EvaluationException("No Definition " + definitionName + this.getParamString(paramTypes) + " for " + targetType.getName() + " could be found!", null);
        }
        ArrayList<Variable> vars = new ArrayList<Variable>(params.length + 1);
        vars.add(new Variable("this", targetObject));
        int i2 = 0;
        while (i2 < params.length) {
            vars.add(new Variable(def.getParams()[i2].getName().getValue(), params[i2]));
            ++i2;
        }
        this.ctx = (XpandExecutionContext)this.ctx.cloneWithVariable(vars);
        this.ctx = (XpandExecutionContext)this.ctx.cloneWithResource(def.getOwner());
        def.evaluate(this.ctx);
    }

    private String getParamString(EClassifier[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            EClassifier t = paramTypes[i];
            buff.append(t.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(",");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }

    public AnalysationIssue[] analyze(String templateName) {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        XpandResource tpl = this.ctx.findTemplate(templateName);
        tpl.analyze(this.ctx, issues);
        return issues.toArray(new AnalysationIssue[issues.size()]);
    }
}

