/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.XpandMigrationFacade;
import org.eclipse.gmf.internal.xpand.migration.XtendMigrationFacade;
import org.eclipse.gmf.internal.xpand.migration.ui.AbstractMigrationVisitor;
import org.eclipse.gmf.internal.xpand.migration.ui.BuildPropertiesManager;
import org.eclipse.gmf.internal.xpand.migration.ui.XpandResourceMigrationException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationVisitor
extends AbstractMigrationVisitor {
    static final String CHARSET = "ISO-8859-1";
    private int rootPathSegmentCount;
    private IFolder dstFolder;
    private IFolder dstNativeExtFolder;
    private RootManager rootManager;
    private IJavaProject javaProject;
    private IProject project;
    private List<CharSequence> nativeLibraryDeclarations = new ArrayList<CharSequence>();
    private BuildPropertiesManager buildPropertiesManager;

    public MigrationVisitor(IContainer rootContainer, IFolder templatesOutputFolder, RootManager rootManager, IProgressMonitor progressMonitor) {
        this(rootContainer, templatesOutputFolder, null, null, rootManager, null, progressMonitor);
    }

    public MigrationVisitor(IContainer rootContainer, IFolder templatesOutputFolder, IFolder nativeExtensionsRoot, IProject project, RootManager rootManager, BuildPropertiesManager buildPropertiesManager, IProgressMonitor progressMonitor) {
        super(progressMonitor);
        this.rootPathSegmentCount = rootContainer.getProjectRelativePath().segmentCount();
        this.dstFolder = templatesOutputFolder;
        this.dstNativeExtFolder = nativeExtensionsRoot;
        this.rootManager = rootManager;
        this.project = project;
        this.buildPropertiesManager = buildPropertiesManager;
    }

    public List<CharSequence> getNativeLibraryDeclarations() {
        return this.nativeLibraryDeclarations;
    }

    @Override
    protected void visitContainer(IContainer resource) throws CoreException {
        IPath relativePath = this.getRelativePath((IResource)resource);
        IFolder folder = this.dstFolder.getFolder(relativePath);
        folder.create(true, true, this.createSubProgressMonitor("Migrating " + resource.getProjectRelativePath().toString()));
        if (relativePath.isEmpty()) {
            folder.setDefaultCharset(CHARSET, null);
        }
    }

    @Override
    protected void visitOtherResource(IFile resource) throws CoreException {
        resource.copy(this.dstFolder.getFullPath().append(this.getRelativePath((IResource)resource)), true, this.createSubProgressMonitor("Copying " + resource.getProjectRelativePath().toString()));
    }

    @Override
    protected void visitXpandResource(IFile resource) throws CoreException {
        IProgressMonitor subMonitor = this.createSubProgressMonitor("Migrating " + resource.getProjectRelativePath().toString());
        this.dstFolder.getFile(this.getRelativePath((IResource)resource)).create(this.migrateXpandResource(resource), true, subMonitor);
    }

    private InputStream migrateXpandResource(IFile srcFile) throws CoreException {
        String templateFullName = this.rootManager.getTemplateFullName(srcFile);
        WorkspaceResourceManager resourceManager = this.rootManager.getResourceManager(srcFile);
        XpandMigrationFacade migrationFacade = new XpandMigrationFacade(resourceManager, templateFullName);
        try {
            String updatedResourceContent = migrationFacade.migrateXpandResource();
            return new ByteArrayInputStream(updatedResourceContent.getBytes(CHARSET));
        }
        catch (MigrationException ex) {
            throw MigrationVisitor.createCoreException(new XpandResourceMigrationException(ex, srcFile));
        }
        catch (UnsupportedEncodingException ex) {
            throw MigrationVisitor.createCoreException(ex);
        }
    }

    @Override
    protected void visitXtendResource(IFile resource) throws CoreException {
        try {
            String templateFullName = this.rootManager.getTemplateFullName(resource);
            WorkspaceResourceManager resourceManager = this.rootManager.getResourceManager(resource);
            XtendMigrationFacade migrationFacade = new XtendMigrationFacade(resourceManager, templateFullName);
            IProgressMonitor subMonitor = this.createSubProgressMonitor("Migrating xtend extensions from " + resource.getProjectRelativePath().toString());
            this.dstFolder.getFile(this.getRelativePath((IResource)resource).removeFileExtension().addFileExtension("qvto")).create((InputStream)new ByteArrayInputStream(migrationFacade.migrateXtendResource().toString().getBytes(CHARSET)), true, subMonitor);
            subMonitor = this.createSubProgressMonitor("Migrating native extensions from " + resource.getProjectRelativePath().toString());
            StringBuilder nativeLibraryClassBody = migrationFacade.getNativeLibraryClassBody();
            if (nativeLibraryClassBody != null) {
                this.nativeLibraryDeclarations.add(migrationFacade.getNativeLibraryXmlDeclaration());
                this.createNativeLibraryClass(migrationFacade.getNativeLibraryPackageName(), migrationFacade.getNativeLibraryClassName(), nativeLibraryClassBody, subMonitor);
            } else {
                subMonitor.done();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw MigrationVisitor.createCoreException(e);
        }
        catch (MigrationException e) {
            throw MigrationVisitor.createCoreException(new XpandResourceMigrationException(e, resource));
        }
    }

    private void createNativeLibraryClass(String nativeLibraryPackageName, String nativeLibraryClassName, StringBuilder nativeLibraryClassBody, IProgressMonitor subMonitor) throws CoreException, UnsupportedEncodingException {
        IFolder pkg = this.getNativeExtSourcesFolder().getFolder((IPath)new Path(nativeLibraryPackageName.replaceAll("\\.", "/")));
        this.createFolder(pkg);
        IFile javaClassFile = pkg.getFile(String.valueOf(nativeLibraryClassName) + ".java");
        javaClassFile.create((InputStream)new ByteArrayInputStream(nativeLibraryClassBody.toString().getBytes(pkg.getDefaultCharset())), true, subMonitor);
    }

    private void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    private IPath getRelativePath(IResource resource) {
        return resource.getProjectRelativePath().removeFirstSegments(this.rootPathSegmentCount);
    }

    private IProgressMonitor createSubProgressMonitor(String taskName) {
        SubProgressMonitor spm = new SubProgressMonitor(this.getProgressMonitor(), 1);
        spm.setTaskName(taskName);
        return spm;
    }

    private IFolder getNativeExtSourcesFolder() throws CoreException {
        assert (this.dstNativeExtFolder != null);
        if (!this.dstNativeExtFolder.exists()) {
            this.dstNativeExtFolder.create(true, true, this.createSubProgressMonitor("Creating folder: " + this.dstNativeExtFolder.getName()));
            IClasspathEntry[] rawClasspath = this.getJavaProject().getRawClasspath();
            IClasspathEntry[] newRawClasspath = new IClasspathEntry[rawClasspath.length + 1];
            System.arraycopy(rawClasspath, 0, newRawClasspath, 0, rawClasspath.length);
            newRawClasspath[rawClasspath.length] = JavaCore.newSourceEntry((IPath)this.dstNativeExtFolder.getFullPath());
            this.getJavaProject().setRawClasspath(newRawClasspath, this.createSubProgressMonitor("Setting classpath"));
            assert (this.buildPropertiesManager != null);
            this.buildPropertiesManager.addSourceFolder(this.dstNativeExtFolder);
        }
        return this.dstNativeExtFolder;
    }

    private IJavaProject getJavaProject() throws CoreException {
        if (this.javaProject == null) {
            IProjectDescription descr = this.project.getDescription();
            IClasspathEntry[] rawClasspath = null;
            if (!descr.hasNature("org.eclipse.jdt.core.javanature")) {
                String[] oldNatures = descr.getNatureIds();
                String[] newNatures = new String[oldNatures.length + 1];
                System.arraycopy(oldNatures, 0, newNatures, 0, oldNatures.length);
                newNatures[oldNatures.length] = "org.eclipse.jdt.core.javanature";
                descr.setNatureIds(newNatures);
                this.project.setDescription(descr, null);
                rawClasspath = new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)JavaCore.getClasspathVariable((String)"JRE_LIB"), null, null)};
            }
            this.javaProject = JavaCore.create((IProject)this.project);
            if (rawClasspath != null) {
                this.javaProject.setRawClasspath(rawClasspath, null);
            }
        }
        return this.javaProject;
    }

    public void done() {
        if (!this.dstNativeExtFolder.exists()) {
            this.getProgressMonitor().worked(2);
        }
    }
}

