/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class BorderItemLocator
implements IBorderItemLocator {
    private IFigure parentFigure = null;
    private Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private Dimension borderItemOffset = new Dimension(1, 1);
    private int preferredSide = 8;
    private int currentSide = 8;
    private int interval;

    protected Rectangle getConstraint() {
        return this.constraint;
    }

    public BorderItemLocator(int interval, IFigure parentFigure) {
        Assert.isTrue((interval > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)parentFigure);
        this.parentFigure = parentFigure;
        this.interval = interval;
    }

    public BorderItemLocator(IFigure parentFigure) {
        this(MapModeUtil.getMapMode((IFigure)parentFigure).DPtoLP(8), parentFigure);
    }

    public BorderItemLocator(IFigure parentFigure, int preferredSide) {
        this(parentFigure);
        this.preferredSide = preferredSide;
    }

    public BorderItemLocator(IFigure parentFigure, int preferredSide, int interval) {
        this(interval, parentFigure);
        this.preferredSide = preferredSide;
    }

    public BorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        this(parentFigure);
        this.setConstraint(constraint);
    }

    public BorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint, int interval) {
        this(interval, parentFigure);
        this.setConstraint(constraint);
    }

    public void setConstraint(Rectangle theConstraint) {
        this.constraint = theConstraint;
        if (theConstraint.getTopLeft().x == 0 || theConstraint.getTopLeft().y == 0) {
            this.setCurrentSideOfParent(this.getPreferredSideOfParent());
        }
    }

    protected Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        if (constraintLocation.x == 0 || constraintLocation.y == 0) {
            return this.getPreferredLocation(this.getPreferredSideOfParent(), borderItem);
        }
        return ptAbsoluteLocation;
    }

    protected Rectangle getParentBorder() {
        Rectangle bounds = this.getParentFigure().getBounds().getCopy();
        if (this.getParentFigure() instanceof NodeFigure) {
            bounds = ((NodeFigure)this.getParentFigure()).getHandleBounds().getCopy();
        }
        return bounds;
    }

    protected Point getPreferredLocation(int side, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        int x = parentFigureX;
        int y = parentFigureY;
        Dimension borderItemSize = this.getSize(borderItem);
        if (side == 8) {
            x = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
            y += parentFigureHeight / 2;
        } else if (side == 16) {
            x = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
            y += parentFigureHeight / 2;
        } else if (side == 1) {
            y = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
            x += parentFigureWidth / 2;
        } else if (side == 4) {
            x += parentFigureWidth / 2;
            y = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        }
        return new Point(x, y);
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }

    protected IFigure getConflictingBorderItemFigure(Point recommendedLocation, IFigure targetBorderItem) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation, this.getSize(targetBorderItem));
        List borderItems = targetBorderItem.getParent().getChildren();
        int currentIndex = borderItems.indexOf(targetBorderItem);
        int i = 0;
        while (i < currentIndex) {
            Rectangle rect;
            IFigure borderItem = (IFigure)borderItems.get(i);
            if (borderItem.isVisible() && (rect = borderItem.getBounds().getCopy()).intersects(recommendedRect)) {
                return borderItem;
            }
            ++i;
        }
        return null;
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        Dimension borderItemSize = this.getSize(borderItem);
        IFigure conflictingBorderItem = this.getConflictingBorderItemFigure(recommendedLocation, borderItem);
        if (circuitCount < 4 && conflictingBorderItem != null) {
            if (suggestedSide == 8) {
                do {
                    this.calculateNextNonConflictingPosition(recommendedLocation, this.interval, suggestedSide, borderItem, conflictingBorderItem.getBounds());
                } while ((conflictingBorderItem = this.getConflictingBorderItemFigure(recommendedLocation, borderItem)) != null);
                if (recommendedLocation.y > this.getParentBorder().getBottomLeft().y - borderItemSize.height) {
                    return this.locateOnBorder(recommendedLocation, 4, circuitCount + 1, borderItem);
                }
                if (recommendedLocation.y < this.getParentBorder().getTopLeft().y - borderItemSize.height) {
                    return this.locateOnBorder(recommendedLocation, 1, circuitCount + 1, borderItem);
                }
            } else if (suggestedSide == 4) {
                do {
                    this.calculateNextNonConflictingPosition(recommendedLocation, this.interval, suggestedSide, borderItem, conflictingBorderItem.getBounds());
                } while ((conflictingBorderItem = this.getConflictingBorderItemFigure(recommendedLocation, borderItem)) != null);
                if (recommendedLocation.x > this.getParentBorder().getBottomRight().x - borderItemSize.width) {
                    return this.locateOnBorder(recommendedLocation, 16, circuitCount + 1, borderItem);
                }
                if (recommendedLocation.x < this.getParentBorder().getBottomLeft().x - borderItemSize.width) {
                    return this.locateOnBorder(recommendedLocation, 8, circuitCount + 1, borderItem);
                }
            } else if (suggestedSide == 16) {
                do {
                    this.calculateNextNonConflictingPosition(recommendedLocation, this.interval, suggestedSide, borderItem, conflictingBorderItem.getBounds());
                } while ((conflictingBorderItem = this.getConflictingBorderItemFigure(recommendedLocation, borderItem)) != null);
                if (recommendedLocation.y < this.getParentBorder().getTopRight().y) {
                    return this.locateOnBorder(recommendedLocation, 1, circuitCount + 1, borderItem);
                }
                if (recommendedLocation.y > this.getParentBorder().getBottomRight().y) {
                    return this.locateOnBorder(recommendedLocation, 4, circuitCount + 1, borderItem);
                }
            } else {
                do {
                    this.calculateNextNonConflictingPosition(recommendedLocation, this.interval, suggestedSide, borderItem, conflictingBorderItem.getBounds());
                } while ((conflictingBorderItem = this.getConflictingBorderItemFigure(recommendedLocation, borderItem)) != null);
                if (recommendedLocation.x < this.getParentBorder().getTopLeft().x) {
                    return this.locateOnBorder(recommendedLocation, 8, circuitCount + 1, borderItem);
                }
                if (recommendedLocation.x > this.getParentBorder().getTopRight().x) {
                    return this.locateOnBorder(recommendedLocation, 16, circuitCount + 1, borderItem);
                }
            }
        }
        return recommendedLocation;
    }

    protected void calculateNextNonConflictingPosition(Point currentLocation, int interval, int currentSide, IFigure borderItem, Rectangle obstacle) {
        switch (currentSide) {
            case 8: {
                currentLocation.y = obstacle.getBottomLeft().y + interval;
                break;
            }
            case 4: {
                currentLocation.x = obstacle.getBottomRight().x + interval;
                break;
            }
            case 16: {
                currentLocation.y = obstacle.getTopRight().y - interval - this.getSize((IFigure)borderItem).height;
                break;
            }
            case 1: {
                currentLocation.x = obstacle.getTopLeft().x - interval - this.getSize((IFigure)borderItem).width;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid side argument: " + currentSide + ". Should be the value from PositionConstants: WEST, EAST, NORTH or SOUTH");
            }
        }
    }

    protected Point getAbsoluteToBorder(Point ptRelativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        return parentOrigin.translate(ptRelativeOffset);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = BorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            if (childCenter.y < parentCenter.y) {
                Point parentTopLeft = parentBorder.getTopLeft();
                if (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y) {
                    return 8;
                }
                return 1;
            }
            Point parentBottomLeft = parentBorder.getBottomLeft();
            if (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y) {
                return 8;
            }
            return 4;
        }
        if (childCenter.y < parentCenter.y) {
            Point parentTopRight = parentBorder.getTopRight();
            if (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y) {
                return 16;
            }
            return 1;
        }
        Point parentBottomRight = parentBorder.getBottomRight();
        if (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y) {
            return 16;
        }
        return 4;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        int closestSide = BorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder());
        this.setPreferredSideOfParent(closestSide);
        Point ptNewLocation = this.locateOnBorder(this.getPreferredLocation(borderItem), this.getPreferredSideOfParent(), 0, borderItem);
        borderItem.setBounds(new Rectangle(ptNewLocation, size));
        this.setCurrentSideOfParent(BorderItemLocator.findClosestSideOfParent(new Rectangle(ptNewLocation, size), this.getParentBorder()));
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    public Dimension getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public int getPreferredSideOfParent() {
        return this.preferredSide;
    }

    public void setPreferredSideOfParent(int preferredSide) {
        this.preferredSide = preferredSide;
        this.setCurrentSideOfParent(preferredSide);
    }

    public int getCurrentSideOfParent() {
        return this.currentSide;
    }

    public void setCurrentSideOfParent(int side) {
        this.currentSide = side;
    }

    protected final Dimension getSize(IFigure borderItem) {
        Dimension size = this.getConstraint().getSize();
        if (size.isEmpty()) {
            size = borderItem.getPreferredSize();
        }
        return size;
    }
}

